/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.history;

import java.util.LinkedList;
import se.ericsson.cello.ncli.server.command.history.CommandHistory;
import se.ericsson.cello.ncli.server.command.history.CommandHistoryItem;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;

public class CommandHistoryImpl
implements CommandHistory {
    LinkedList commandList = new LinkedList();
    int maxNoOfElements;
    int currIdx = 0;
    boolean firstItemFlag = false;
    int recordCounter = 1;

    public CommandHistoryImpl(int n) {
        this.maxNoOfElements = n;
    }

    public void addCommand(String string) {
        if (string != null && string.charAt(0) != '!') {
            if (this.commandList.size() == this.maxNoOfElements) {
                this.commandList.removeLast();
            }
            this.commandList.addFirst(new CommandHistoryItem(string, this.recordCounter++));
            this.currIdx = 0;
            this.firstItemFlag = true;
        }
    }

    public String getNextCommand() {
        Log.trace(CommandHistoryImpl.class, "getNextCommand() currIdx = " + this.currIdx);
        if (this.commandList.size() == 0) {
            Log.trace(CommandHistoryImpl.class, "next cmd: null");
            return null;
        }
        if (this.firstItemFlag) {
            this.firstItemFlag = false;
        } else if (this.currIdx + 1 != this.commandList.size()) {
            ++this.currIdx;
        }
        Log.trace(CommandHistoryImpl.class, "next cmd: " + ((CommandHistoryItem)this.commandList.get(this.currIdx)).getCommand());
        return ((CommandHistoryItem)this.commandList.get(this.currIdx)).getCommand();
    }

    public String getPreviousCommand() {
        Log.trace(CommandHistoryImpl.class, "getPreviousCommand() currIdx = " + this.currIdx);
        if (this.currIdx == 0) {
            Log.trace(CommandHistoryImpl.class, "prev cmd: null (bottom of list)");
            this.firstItemFlag = true;
            return null;
        }
        --this.currIdx;
        Log.trace(CommandHistoryImpl.class, "prev cmd: " + ((CommandHistoryItem)this.commandList.get(this.currIdx)).getCommand());
        return ((CommandHistoryItem)this.commandList.get(this.currIdx)).getCommand();
    }

    public LinkedList getHistoryList() {
        return this.commandList;
    }

    public String getCommand(int n) throws NcliException {
        for (int i = 0; i < this.commandList.size(); ++i) {
            if (((CommandHistoryItem)this.commandList.get(i)).getRecordNo() != n) continue;
            return ((CommandHistoryItem)this.commandList.get(i)).getCommand();
        }
        throw new NcliException("Event not found");
    }
}

