/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.MoSearchableCommand;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;

public class GroupCommand
extends MoSearchableCommand {
    private boolean addFlag;
    private ArrayList listOfLdnsToAdd = null;
    private boolean expressionFlag;
    private boolean rmFlag;
    private String groupMemberIndexes = null;
    private boolean clearFlag;

    public GroupCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setAddFlag(boolean bl) {
        this.addFlag = bl;
    }

    public void setClearFlag(boolean bl) {
        this.clearFlag = bl;
    }

    public void setExpressionFlag(boolean bl) {
        this.expressionFlag = bl;
    }

    public void setGroupMemberIndexes(String string) {
        this.groupMemberIndexes = string;
    }

    public void setListOfLdnsToAdd(ArrayList arrayList) {
        this.listOfLdnsToAdd = arrayList;
    }

    public void setRmFlag(boolean bl) {
        this.rmFlag = bl;
    }

    public void execute() {
        Log.trace(GroupCommand.class, "execute()");
        this.printout = PrintoutFactory.createPrintout();
        if (this.addFlag) {
            if (this.expressionFlag) {
                this.executeAddFlagExpression();
            } else {
                this.executeAddFlag();
            }
        } else if (this.rmFlag) {
            this.executeRmFlag();
        } else if (this.clearFlag) {
            this.executeClearFlag();
        } else {
            this.executeListFlag();
        }
    }

    private void executeAddFlag() {
        Log.trace(GroupCommand.class, "executeAddFlag");
        long l = this.validateMos(this.listOfLdnsToAdd);
        if (l < 0L) {
            this.sendResponse();
            return;
        }
        try {
            this.nodeServices.getMemoryChecker().memoryIsEnough(l);
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            for (int i = 0; i < this.listOfLdnsToAdd.size(); ++i) {
                if (!moGroup.containsLdn((String)this.listOfLdnsToAdd.get(i))) continue;
                this.printout.addNotAcceptedString();
                this.printout.addErrorText("The following MO was already in the group:\n" + this.listOfLdnsToAdd.get(i));
                this.sendResponse();
                return;
            }
            moGroup.addGroupMembers(this.listOfLdnsToAdd.toArray(new String[this.listOfLdnsToAdd.size()]));
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.sendResponse();
        }
    }

    private void executeAddFlagExpression() {
        Log.trace(GroupCommand.class, "execute()");
        try {
            Mo[] moArray = this.searchMos();
            if (moArray == null) {
                this.sendResponse();
                return;
            }
            this.listOfLdnsToAdd = new ArrayList(0);
            for (int i = 0; i < moArray.length; ++i) {
                this.listOfLdnsToAdd.add(moArray[i].getLdn());
            }
            this.executeAddFlag();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.sendResponse();
        }
    }

    private void executeRmFlag() {
        Log.trace(GroupCommand.class, "executeRmFlag");
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(this.groupMemberIndexes, moGroup.getGroupMembers().size() - 1);
            if (nArray == null) {
                this.printout.addNotAcceptedString();
                this.printout.addErrorText("Failed to parse the range of group members.");
                this.sendResponse();
                return;
            }
            String string = null;
            for (int i = 0; i < nArray.length; ++i) {
                string = moGroup.getLdnAtIndex(nArray[i]);
                if (string != null) continue;
                this.printout.addNotAcceptedString();
                this.printout.addErrorText("Index not found: " + nArray[i]);
                this.sendResponse();
                return;
            }
            moGroup.removeGroupMembers(nArray);
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.sendResponse();
        }
    }

    private void executeClearFlag() {
        Log.trace(GroupCommand.class, "executeClearFlag");
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            moGroup.clearGroup();
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.sendResponse();
        }
    }

    private void executeListFlag() {
        MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
        this.printout.addGroupMemberList(moGroup.getName(), moGroup.getGroupMembers());
        this.printout.addEndText();
        this.sendResponse();
    }

    private long validateMos(ArrayList arrayList) {
        Log.trace(GroupCommand.class, "validateMos");
        long l = 0L;
        if (arrayList == null || arrayList.size() <= 0) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText("The Managed Object(s) to add is not valid.");
            return -1L;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                Mo mo = this.nodeServices.getCm().getMo(string);
                if (!mo.exists()) {
                    this.printout.addNotAcceptedString();
                    this.printout.addErrorText(string + " does not exist.");
                    return -1L;
                }
                l += (long)string.length();
                l += (long)string.length();
            }
            catch (Exception exception) {
                this.printout.addNotAcceptedString();
                this.printout.addErrorText(ExceptionHandler.map(exception, ""));
                return -1L;
            }
        }
        return l;
    }
}

