/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.ncli.server.command.result.PlainTextFormatter;
import se.ericsson.cello.ncli.server.command.result.Printout;
import se.ericsson.cello.ncli.server.command.result.PrintoutFormatter;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmCounter;
import se.ericsson.cello.neal.fm.SeverityInfo;

public class PrintoutImpl
implements Printout {
    private boolean isErrorPrintout = false;
    private StringBuffer printoutBuf;
    private PrintoutFormatter myFormatter;

    public PrintoutImpl(PrintoutFormatter printoutFormatter) {
        this.myFormatter = printoutFormatter;
        this.printoutBuf = new StringBuffer();
    }

    public PrintoutImpl(PrintoutFormatter printoutFormatter, String string) {
        this.myFormatter = printoutFormatter;
        this.printoutBuf = new StringBuffer();
        this.printoutBuf.append(this.myFormatter.formatCmdNameHeader(string));
    }

    public void addActionResult(String string, Value value, NameValueFactory nameValueFactory) {
        this.printoutBuf.append(this.myFormatter.formatActionResult(string, value, nameValueFactory));
    }

    public void addResult(NameValue nameValue) {
        try {
            this.printoutBuf.append(this.myFormatter.format(nameValue));
        }
        catch (Exception exception) {
            this.addErrorText(new NcliException(exception));
        }
    }

    public void addAttrResult(NameValue nameValue) {
        try {
            this.printoutBuf.append(this.myFormatter.formatAttr(nameValue));
        }
        catch (Exception exception) {
            this.addErrorText(new NcliException(exception));
        }
    }

    public void addResult(NameValue[] nameValueArray) throws NcliException {
        this.printoutBuf.append(this.myFormatter.format(nameValueArray));
    }

    public void addResult(Mo[] moArray) {
        this.printoutBuf.append(this.myFormatter.format(moArray));
    }

    public void addResult(Alarm alarm) throws NcliException {
        this.printoutBuf.append(this.myFormatter.formatAlarm(alarm));
    }

    public void addResult(AlarmCounter alarmCounter) throws NcliException {
        this.printoutBuf.append(this.myFormatter.formatAlarmCounter(alarmCounter));
    }

    public void addResultAsRdn(Mo[] moArray) {
        this.printoutBuf.append(this.myFormatter.formatRdn(moArray));
    }

    public void addLDN(String string) {
        this.printoutBuf.append(this.myFormatter.formatLDN(string));
    }

    public void addResult(String string) {
        this.printoutBuf.append(this.myFormatter.format(string));
    }

    public void addExecutedString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("EXECUTED", 0));
    }

    public void addInhibitedString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("INHIBITED", 0));
    }

    public void addNotAcceptedString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("NOT ACCEPTED", 0));
    }

    public void addAttributesString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("ATTRIBUTES", 0));
    }

    public void addActionsString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("ACTIONS", 0));
    }

    public void addRelationsString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("RELATIONS", 0));
    }

    public void addChildrenString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("CHILDREN", 0));
    }

    public void addMoStart() {
        this.printoutBuf.append(this.myFormatter.formatEnd());
    }

    public void addEndText() {
        this.printoutBuf.append(this.myFormatter.formatEnd());
    }

    public void addResultString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("RESULT", 0));
    }

    public void addAlarmsString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("ALARMS", 0));
    }

    public void addAlarmCountString() {
        this.printoutBuf.append(this.myFormatter.formatHeader("ALARM COUNT", 0));
    }

    public void addConfirmationText() {
        this.printoutBuf.append(this.myFormatter.formatHeader("Proceed with command (yes/no)?", 0));
    }

    public void addParagraphSeparator() {
        this.printoutBuf.append(this.myFormatter.formatParagraphSeparator());
    }

    public void addAbortedText() {
        this.printoutBuf.append(this.myFormatter.formatHeader("ABORTED BY USER", 0));
    }

    public void addErrorText(NcliException ncliException) {
        this.setErrorPrintout(true);
        if (this.myFormatter instanceof PlainTextFormatter) {
            this.clearPrintoutBuf();
        }
        this.addNotAcceptedString();
        this.printoutBuf.append(this.myFormatter.formatError(ncliException));
    }

    public void addErrorText(String string) {
        this.setErrorPrintout(true);
        this.clearPrintoutBuf();
        this.addNotAcceptedString();
        this.printoutBuf.append(this.myFormatter.format(string));
    }

    public StringBuffer getPrintoutBuf() {
        return this.printoutBuf;
    }

    public void clearPrintoutBuf() {
        this.printoutBuf.setLength(0);
    }

    public boolean isErrorPrintout() {
        return this.isErrorPrintout;
    }

    public void setErrorPrintout(boolean bl) {
        this.isErrorPrintout = bl;
    }

    public void addClassDescription(MomClass momClass) {
        this.printoutBuf.append(this.myFormatter.formatClass(momClass));
    }

    public void addStructDescription(MomStruct momStruct) {
        this.printoutBuf.append(this.myFormatter.formatStruct(momStruct));
    }

    public void addEnumDescription(MomEnum momEnum) {
        this.printoutBuf.append(this.myFormatter.formatEnum(momEnum));
    }

    public void addActionsDescription(Iterator iterator) {
        this.printoutBuf.append(this.myFormatter.formatActionDetails(iterator));
    }

    public void addAttributesDescription(Iterator iterator) {
        this.printoutBuf.append(this.myFormatter.formatAttributeDetails(iterator));
    }

    public void addActionDescription(MomAction momAction) {
        ArrayList<MomAction> arrayList = new ArrayList<MomAction>(1);
        arrayList.add(momAction);
        this.addActionsDescription(arrayList.iterator());
    }

    public void addAttributeDescription(MomAttribute momAttribute) {
        ArrayList<MomAttribute> arrayList = new ArrayList<MomAttribute>(1);
        arrayList.add(momAttribute);
        this.addAttributesDescription(arrayList.iterator());
    }

    public void addDescriptionHeader(MomEntity momEntity) {
        this.printoutBuf.append(this.myFormatter.formatDescriptionSection(momEntity));
    }

    public void addGroupMemberList(String string, List list) {
        this.printoutBuf.append(this.myFormatter.formatGroupName(string));
        this.printoutBuf.append(this.myFormatter.formatGroupMembers(list));
    }

    public void addStructMemberDescription(Iterator iterator) {
        this.printoutBuf.append(this.myFormatter.formatStructDetails(iterator));
    }

    public void addNumberedLDNs(ArrayList arrayList) {
        this.printoutBuf.append(this.myFormatter.formatLDN(arrayList));
    }

    public void addMoStart(String string) {
        this.printoutBuf.append(this.myFormatter.formatMoStart(string));
    }

    public void addMoEnd() {
        this.printoutBuf.append(this.myFormatter.formatMoEnd());
    }

    public void addFilteredBuffer(String string) {
        if (string != null) {
            this.printoutBuf.append(string);
        }
    }

    public void addDiffResult(Mo[] moArray, String string) {
        this.printoutBuf.append(this.myFormatter.formatDiff(moArray, string));
    }

    public void addSeverityInfo(SeverityInfo[] severityInfoArray) {
        for (int i = 0; i < severityInfoArray.length; ++i) {
            this.printoutBuf.append(this.myFormatter.formatSeverityInfo(severityInfoArray[i]));
        }
    }

    public void addSeverityConfigHeader() {
        this.printoutBuf.append(this.myFormatter.formatHeader("SEVERITY CONFIGURATION", 0));
    }
}

