/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.cs.MoAddressResolver;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;

public class MoAddressResolverImpl
implements MoAddressResolver {
    private NodeServices cs;
    private Mo rootMo;
    private String root;
    private static final String COMMA_SIGN = ",";
    private static final String DOUBLE_DOT = "..";
    private static final String DOT = ".";
    private static final String MINUS_SIGN = "-";
    private static final String FRONT_SLASH = "/";

    public MoAddressResolverImpl(NodeServices nodeServices) {
        this.cs = nodeServices;
        this.rootMo = nodeServices.getRootMo();
        this.root = this.rootMo.getLdn();
    }

    public String[] getGlobalAddress(String string) {
        String[] stringArray = null;
        try {
            String string2 = string.substring(0, string.indexOf(61));
            String string3 = string.substring(string.indexOf(61) + 1);
            String string4 = string2 + "Id == '" + string3 + "'";
            Log.trace(MoAddressResolverImpl.class, "Type is " + string2 + " and criteria is " + string4);
            Mo[] moArray = this.rootMo.getChildren(string2, string4, Scope.ALL_LEVELS, this.cs.getTransactionHandler().getCurrentTransaction());
            Log.trace(MoAddressResolverImpl.class, "Found " + moArray.length + " children");
            if (moArray.length > 0) {
                stringArray = new String[moArray.length];
                for (int i = 0; i < moArray.length; ++i) {
                    stringArray[i] = moArray[i].getLdn();
                }
            }
        }
        catch (Exception exception) {
            Log.info(MoAddressResolverImpl.class, exception.getMessage());
            stringArray = null;
        }
        return stringArray;
    }

    public String resolveAddress(String string) {
        String string2 = null;
        string2 = this.isSpecialCharacter(string) ? this.resolveFromSpecialCharacter(string) : (string.startsWith(this.root) ? string : this.cs.getWorkingMo().getLdn().concat(COMMA_SIGN).concat(string));
        return string2;
    }

    private boolean isSpecialCharacter(String string) {
        return string.equals(FRONT_SLASH) || string.equals(DOUBLE_DOT) || string.equals(DOT) || string.equals(MINUS_SIGN);
    }

    public String resolveFromSpecialCharacter(String string) {
        String string2 = null;
        String string3 = this.cs.getWorkingMo().getLdn();
        string2 = string.equals(FRONT_SLASH) ? this.root : (string.equals(DOUBLE_DOT) ? (string3.equals(this.root) ? this.root : string3.substring(0, string3.lastIndexOf(COMMA_SIGN))) : (string.equals(DOT) ? string3 : (string.equals(MINUS_SIGN) ? this.cs.getPreviousWorkingMo().getLdn() : null)));
        return string2;
    }

    public int[] resolveIndexFromRange(String string, int n) {
        if (string == null) {
            return null;
        }
        try {
            Object object;
            HashMap hashMap = new HashMap(0);
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA_SIGN);
            while (stringTokenizer.hasMoreTokens()) {
                Integer n2;
                int n3;
                Object object2;
                object = stringTokenizer.nextToken();
                int n4 = ((String)object).indexOf(MINUS_SIGN);
                if (n4 < 0) {
                    object2 = new Integer((String)object);
                    if ((Integer)object2 < 0 || (Integer)object2 > n) {
                        throw new IndexOutOfBoundsException("The group member index range is out of bounds.");
                    }
                    if (hashMap.containsKey(object2)) continue;
                    hashMap.put(object2, null);
                    arrayList.add(object2);
                    continue;
                }
                object2 = new StringTokenizer((String)object, MINUS_SIGN);
                int n5 = new Integer(((StringTokenizer)object2).nextToken());
                int n6 = new Integer(((StringTokenizer)object2).nextToken());
                if (n5 < 0 || n6 < 0) {
                    throw new IndexOutOfBoundsException("The group member index range is out of bounds.");
                }
                if (n5 < n6) {
                    if (n6 > n) {
                        throw new IndexOutOfBoundsException("The group member index range is out of bounds.");
                    }
                    for (n3 = n5; n3 <= n6; ++n3) {
                        n2 = new Integer(n3);
                        if (hashMap.containsKey(n2)) continue;
                        hashMap.put(n2, null);
                        arrayList.add(n2);
                    }
                    continue;
                }
                if (n5 > n) {
                    throw new IndexOutOfBoundsException("The group member index range is out of bounds.");
                }
                for (n3 = n5; n3 >= n6; --n3) {
                    n2 = new Integer(n3);
                    if (hashMap.containsKey(n2)) continue;
                    hashMap.put(n2, null);
                    arrayList.add(n2);
                }
            }
            object = new int[arrayList.size()];
            Iterator iterator = arrayList.iterator();
            int n7 = 0;
            while (iterator.hasNext()) {
                Integer n8 = (Integer)iterator.next();
                object[n7] = n8;
                ++n7;
            }
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

