/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.services;

import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.services.MemoryChecking;
import se.ericsson.cello.ncli.server.services.NCLIServices;

public class MemoryChecker
implements MemoryChecking {
    private static MemoryChecking instance;

    public static synchronized MemoryChecking getInstance() {
        if (instance == null) {
            instance = new MemoryChecker();
        }
        return instance;
    }

    public void memoryIsEnough(long l) throws MemoryNotSufficientException {
        long l2;
        long l3 = this.getFreeMemory();
        if (l > l3 - (l2 = NCLIServices.getConfigurationReader().getRequiredFreeMemory())) {
            String string = "bytesToBeAllocated=" + l + ". Free memory of the JVM=" + l3 + ". Required free memory=" + l2;
            throw new MemoryNotSufficientException(string);
        }
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public void sufficientMemoryToStoreMom(long l, long l2) throws MemoryNotSufficientException {
        double d = 0.6667;
        double d2 = (double)l * d;
        long l3 = this.getFreeMemory();
        if (d2 > (double)(l3 - l2)) {
            String string = "Calculated memory to store MOM=" + d2 + ". Free memory of the JVM=" + l3 + ". Required free memory=" + l2;
            MemoryNotSufficientException memoryNotSufficientException = new MemoryNotSufficientException(string);
            Log.info(MemoryChecker.class, "sufficientMemoryToStoreMom(). MemoryNotSufficientException occured.", memoryNotSufficientException);
            throw memoryNotSufficientException;
        }
    }
}

