/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.commandlog;

import java.text.SimpleDateFormat;
import java.util.Date;
import se.ericsson.cello.commandlog.ObjectHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.support.debug.MessageLog;

public abstract class CMD {
    protected StringBuffer data = null;
    private String userName = null;
    protected String cmdName = null;
    protected static final String EXCEPTIONTAG = "exception";
    protected static final String MOTAG = "mo";
    protected static final String NROFPARAMTAG = "nrOfParameters";
    String exception = null;

    public CMD(String string, String string2, String string3) {
        this.cmdName = string;
        this.exception = this.removeSpecialCharacters(string3);
        this.data = new StringBuffer();
        this.userName = string2 != null ? string2 : "Unknown";
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d yyyy',' HH:mm:ss");
        this.data.append("<Request>\n");
        this.data.append("// " + this.userName + " " + simpleDateFormat.format(date) + "\n");
        this.data.append(string);
    }

    String getCMDName() {
        return this.cmdName;
    }

    public abstract String toString();

    protected void addBeginTag() {
        this.data.append("\n(");
    }

    protected void addEndTag() {
        this.data.append("\n)\n");
    }

    protected void handleContainedArray(Object[] objectArray) {
        if (objectArray == null) {
            this.data.append(" ");
        } else if (this.cmdName.equals("ACTION")) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[i];
                    this.data.append("\n\tArray " + ObjectHelper.getObjectByType(objectArray2) + " " + Integer.toString(objectArray2.length));
                    for (int j = 0; j < objectArray2.length; ++j) {
                        if (objectArray2[j] instanceof Struct) {
                            this.handleStructInArray((Struct)objectArray2[j]);
                            continue;
                        }
                        this.handleAllObjects(objectArray2[j], false);
                    }
                    continue;
                }
                this.handleAllObjects(objectArray[i], false);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Struct) {
                    this.handleStructInArray((Struct)objectArray[i]);
                    continue;
                }
                this.data.append("\n\t\t" + ObjectHelper.getObjectValue(objectArray[i]));
            }
        }
    }

    protected void addAttributes(AttrList attrList) {
        if (attrList == null) {
            this.data.append(" ");
        } else {
            int n = attrList.size();
            Object[] objectArray = null;
            Object object = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.data.append("\n " + attrList.getName(i) + " ");
                try {
                    object = attrList.getValue(i);
                }
                catch (MoNotFoundException moNotFoundException) {
                    object = new ManagedObjectDeleted();
                    MessageLog.info(this.getClass(), (String)"The CORBA AuditTrailLog could not store the correct LDN because the MO in question has already been deleted.");
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.traceError(this.getClass(), (String)"AttrList Exception", (Throwable)moAccessException);
                }
                if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                    n2 = objectArray.length;
                    this.data.append(" Array " + ObjectHelper.getObjectByType(objectArray) + " " + Integer.toString(n2));
                    this.handleContainedArray(objectArray);
                    continue;
                }
                this.handleAllObjects(object, false);
            }
        }
    }

    private void handleArray(Object[] objectArray) {
        if (objectArray.length > 0) {
            this.data.append("\n\tArray " + ObjectHelper.getObjectByType(objectArray[0]) + " " + Integer.toString(objectArray.length));
            String[] stringArray = ObjectHelper.getSequenceObjectValue(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.data.append("\n\t\t" + stringArray[i]);
            }
        } else {
            this.handleEmptyArray(objectArray);
        }
    }

    private void handleEmptyArray(Object object) {
        if (this.cmdName.equals("ACTION")) {
            this.data.append("\n ");
        }
        if (object instanceof int[]) {
            this.data.append(" \tArray Integer 0");
        } else if (object instanceof float[]) {
            this.data.append(" \tArray Float 0");
        } else if (object instanceof boolean[]) {
            this.data.append(" \tArray Boolean 0");
        } else if (object instanceof long[]) {
            this.data.append(" \tArray Long 0");
        } else {
            this.data.append(" \tArray " + ObjectHelper.getObjectByType(object) + " 0");
        }
    }

    private void handleObject(Object object, boolean bl) {
        if (this.cmdName.equals("ACTION") && !bl) {
            this.data.append("\n ");
        }
        if (object instanceof int[]) {
            this.data.append(" Array Integer " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof float[]) {
            this.data.append(" Array Float " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof boolean[]) {
            this.data.append(" Array Boolean " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof long[]) {
            this.data.append(" Array Long " + ObjectHelper.getObjectValue(object));
        } else {
            this.data.append(ObjectHelper.getObjectByType(object) + " " + ObjectHelper.getObjectValue(object));
        }
    }

    private void handleStruct(Struct struct, boolean bl) {
        if (this.cmdName.equals("ACTION") && !bl) {
            this.data.append("\n\t" + ObjectHelper.getObjectByType(struct));
        } else {
            this.data.append(" " + ObjectHelper.getObjectByType(struct));
        }
        this.handleStructInArray(struct);
    }

    private void handleStructInArray(Struct struct) {
        int n;
        String[] stringArray = struct.getNames();
        Object[] objectArray = new Object[struct.size()];
        for (n = 0; n < objectArray.length; ++n) {
            try {
                objectArray[n] = struct.getValue(stringArray[n]);
                continue;
            }
            catch (MoNotFoundException moNotFoundException) {
                objectArray[n] = new ManagedObjectDeleted();
                MessageLog.info(this.getClass(), (String)"The CORBA AuditTrailLog could not store the correct LDN because the MO in question has already been deleted.");
                continue;
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"Struct exception", (Throwable)moAccessException);
            }
        }
        this.data.append("\n\tnrOfElements " + Integer.toString(struct.size()));
        try {
            for (n = 0; n < struct.size(); ++n) {
                this.data.append("\n\t\t" + stringArray[n] + " ");
                this.handleAllObjects(objectArray[n], true);
            }
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Struct exception", (Throwable)exception);
        }
    }

    private void handleAllObjects(Object object, boolean bl) {
        if (object instanceof Struct) {
            this.handleStruct((Struct)object, bl);
        } else if (object instanceof Object[]) {
            this.handleArray((Object[])object);
        } else {
            this.handleObject(object, bl);
        }
    }

    private String removeSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            int n;
            int n2;
            if ((n2 = stringBuffer.indexOf("<")) != -1) {
                stringBuffer = stringBuffer.replace(n2, n2 + 1, "&lt;");
            }
            if ((n = stringBuffer.indexOf(">")) == -1) continue;
            stringBuffer = stringBuffer.replace(n, n + 1, "&gt;");
        } while (stringBuffer.indexOf("<") != -1 || stringBuffer.indexOf(">") != -1);
        return stringBuffer.toString();
    }

    static class ManagedObjectDeleted {
        ManagedObjectDeleted() {
        }
    }
}

