/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.commandlog;

import se.ericsson.cello.commandlog.CMD;
import se.ericsson.cello.genericlog.Log;
import se.ericsson.cello.genericlog.LogAlreadyExistsException;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.genericlog.LogMgr;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.BlockingQueue;

class CmdFileMgr
implements Runnable {
    private BlockingQueue myQueue = null;
    private Thread thread = null;
    Log auditTrailLog = null;
    private static CmdFileMgr instance = new CmdFileMgr();
    private static final int JAVA_HEAP_BREAKPOINT = 10000000;
    private static final int MAX_QUEUE_SIZE = 6000;
    private static final int MIN_QUEUE_SIZE = 1000;
    private static final int LOG_SIZE = 307200;
    private static final int RETRY_INTERVAL = 2000;
    private static final int MAX_NO_OF_RETRIES = 20;
    private static final long SYSTEM_PARAMETER = 3L;
    private static final String LOG_NAME = "CORBA_AUDITTRAIL_LOG";
    private static final String SUB_DIR = "audit_trail";
    private static final String ADDITIONAL_INFO = "Audit Trail Log for MIB modifying CORBA operations";
    static final long AUDIT_BASE_EVENT_ID = 37L;
    static final long CREATE_EVENT_ID = 38L;
    static final long DELETE_EVENT_ID = 39L;
    static final long ACTION_EVENT_ID = 40L;
    static final long SET_EVENT_ID = 41L;

    static CmdFileMgr instance() {
        return instance;
    }

    public void run() {
        CMD cMD = null;
        try {
            while (true) {
                cMD = (CMD)this.myQueue.dequeue();
                long l = this.getEventId(cMD);
                if (this.auditTrailLog == null) {
                    this.waitUntilLogIsCreated();
                }
                if (this.auditTrailLog == null) continue;
                this.writeRecord(l, cMD.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)interruptedException);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
        }
    }

    private void waitUntilLogIsCreated() throws InterruptedException {
        int n = 0;
        while (!this.createLog() && n < 20) {
            Thread.sleep(2000L);
            if (++n != 1 && n % 5 != 0) continue;
            MessageLog.info(this.getClass(), (String)"Failed to create/find AuditTrail Log, retrying...");
        }
        if (this.auditTrailLog == null && n == 20) {
            MessageLog.traceError(this.getClass(), (String)"Failed to create/find the Audit Trail Log despite retrying for 40000 sec.");
        }
    }

    public long getEventId(CMD cMD) {
        long l = 37L;
        if (cMD.getCMDName().equalsIgnoreCase("CREATE")) {
            l = 38L;
        } else if (cMD.getCMDName().equalsIgnoreCase("DELETE")) {
            l = 39L;
        } else if (cMD.getCMDName().equalsIgnoreCase("ACTION")) {
            l = 40L;
        } else if (cMD.getCMDName().equalsIgnoreCase("SET")) {
            l = 41L;
        }
        return l;
    }

    void addDataToFile(Object object) {
        if (!this.myQueue.enqueue(object)) {
            MessageLog.info(this.getClass(), (String)"CORBA Audit Trail queue is full, dropping one message");
        }
    }

    private void writeRecord(long l, String string) {
        int n = 0;
        boolean bl = true;
        if (string.length() >= 60000) {
            MessageLog.trace((int)5, this.getClass(), (String)("Audit trail record too big (" + string.length() + " bytes), logging the first " + 59999 + " bytes"));
            string = string.substring(0, 59999);
        }
        while (bl) {
            ++n;
            try {
                this.auditTrailLog.lsi5WriteRecord(Log.ADD_NO_TIME_STAMP, 0L, l, string);
                bl = false;
            }
            catch (LogInternalErrorException logInternalErrorException) {
                if (n < 20) {
                    if (n == 1 || n % 5 == 0) {
                        MessageLog.info(this.getClass(), (String)("Failed to write to the Audit Trail Log due to " + logInternalErrorException.getMessage() + ", trying again..."));
                    }
                } else {
                    MessageLog.traceError(this.getClass(), (String)"Failed when writing to the Audit Trail log.", (Throwable)logInternalErrorException);
                    bl = false;
                    return;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
                }
                this.createLog();
            }
            catch (Exception exception) {
                bl = false;
                MessageLog.traceError(this.getClass(), (String)"Failed when writing to the Audit Trail Log.", (Throwable)exception);
            }
        }
    }

    private boolean createLog() {
        boolean bl = false;
        try {
            this.auditTrailLog = LogMgr.instance().lsi3CreateLog(LOG_NAME, 307200, LogMgr.GLOBAL_STORAGE, LogMgr.XML_FORMAT, SUB_DIR, LogMgr.PUSHED, LogMgr.NO_INFO_RECORDS, 3L, ADDITIONAL_INFO);
            bl = true;
        }
        catch (LogAlreadyExistsException logAlreadyExistsException) {
            try {
                this.auditTrailLog = LogMgr.instance().findLog(LOG_NAME);
                bl = true;
            }
            catch (LogInternalErrorException logInternalErrorException) {
                MessageLog.info(this.getClass(), (String)("Failed to find the Audit Trail log due to " + logInternalErrorException.getMessage() + ", another try is done later."));
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"Finding the Audit Trail Log failed.", (Throwable)exception);
            }
        }
        catch (LogInternalErrorException logInternalErrorException) {
            MessageLog.info(this.getClass(), (String)("Failed to create the Audit Trail log due to " + logInternalErrorException.getMessage() + ", another try is done later."));
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Creating the Audit Trail Log failed.", (Throwable)exception);
        }
        return bl;
    }

    private int getMaxQueueSize() {
        long l = Runtime.getRuntime().totalMemory();
        if (l < 10000000L) {
            return 1000;
        }
        return 6000;
    }

    private CmdFileMgr() {
        try {
            this.createLog();
            this.myQueue = new BlockingQueue(this.getMaxQueueSize());
            this.thread = new Thread((Runnable)this, "AuditTrailLogWriter");
            this.thread.start();
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Error, AuditTrailLogWriter could not be started: " + exception), null);
        }
    }
}

