/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.csnotification;

import ConfigExtended.NotificationConsumer;
import ConfigExtended.NotificationConsumerHelper;
import ConfigExtended.NotificationProducerPackage.MOTypeAndAttributes;
import ConfigExtended.NotificationProducerPackage.NoTransactionException;
import ConfigExtended.NotificationProducerPackage.NotificationFilter;
import ConfigExtended.NotificationProducerPackage.NotificationFilterExt;
import ConfigExtended.OverflowNotification;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import se.ericsson.cello.csnotification.Consumer;
import se.ericsson.cello.csnotification.Subscription;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class SubscriptionMgr {
    private static int nextSubscriptionId = 0;
    private static Hashtable allSubscriptions = new Hashtable();
    private static Vector persistentSubscriptions = new Vector();
    private static String subscriptionFile;
    private static String oldSubscriptionFile;
    private static int MAX_NO_OF_SUBSCRIPTIONS;
    private static int TRACE_GROUP;
    private static String TARGET_PATH;
    private static String HOST_PATH;
    private static String OLD_FILE_NAME;
    private static String FILE_NAME;

    private static synchronized int startSubscription(NotificationConsumer notificationConsumer, NotificationFilterExt notificationFilterExt, int n, boolean bl) {
        for (int i = 0; i < notificationFilterExt.typesAndAttributes.length; ++i) {
            notificationFilterExt.typesAndAttributes[i].typeOfMO = notificationFilterExt.typesAndAttributes[i].typeOfMO.trim();
            for (int j = 0; j < notificationFilterExt.typesAndAttributes[i].attributes.length; ++j) {
                notificationFilterExt.typesAndAttributes[i].attributes[j] = notificationFilterExt.typesAndAttributes[i].attributes[j].trim();
            }
        }
        Mib mib = MibMgr.instance().getMib();
        notificationFilterExt.baseMO = SubscriptionMgr.removePrefix(notificationFilterExt.baseMO.trim(), mib);
        if (notificationFilterExt.baseMO.equals("")) {
            notificationFilterExt.baseMO = mib.getRootMo().getLocalDistinguishedName();
        }
        if (allSubscriptions.size() >= MAX_NO_OF_SUBSCRIPTIONS) {
            MessageLog.info((Class)SubscriptionMgr.class, (String)"Maximum number of subscriptions reached, deleting oldest subscription.");
            SubscriptionMgr.deleteOldestSubscription();
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Consumer.getNumberOfActiveConsumers() >= MAX_NO_OF_SUBSCRIPTIONS) {
            MessageLog.info((Class)SubscriptionMgr.class, (String)"Maximum CM notification thread limit reached - subscription can not be created.");
            throw new NO_RESOURCES("Maximum CM notification thread limit reached - subscription can not be created.");
        }
        Subscription subscription = new Subscription(notificationConsumer, notificationFilterExt, nextSubscriptionId, n, bl);
        allSubscriptions.put(new Integer(nextSubscriptionId), subscription);
        PersistentSubscription_r2 persistentSubscription_r2 = new PersistentSubscription_r2(CelloOrb.instance().object_to_string(notificationConsumer), nextSubscriptionId, n, notificationFilterExt, bl);
        persistentSubscriptions.addElement(persistentSubscription_r2);
        SubscriptionMgr.storeConsumers();
        ++nextSubscriptionId;
        MessageLog.trace((int)TRACE_GROUP, (Class)SubscriptionMgr.class, (String)("Added CS subscription with id = " + subscription.getId() + ", timeout = " + n + " sec." + " isSDNSupported = " + subscription.getSupportSDN()));
        return subscription.getId();
    }

    public static synchronized int startSubscription(NotificationConsumer notificationConsumer, NotificationFilterExt notificationFilterExt, int n, int n2) {
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
        }
        int n3 = SubscriptionMgr.startSubscription(notificationConsumer, notificationFilterExt, n, bl);
        return n3;
    }

    public static OverflowNotification createOverflowNotification(String string) {
        String string2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(Calendar.getInstance().getTime());
        MessageLog.info((Class)SubscriptionMgr.class, (String)("OverflowNotification: " + string));
        return new OverflowNotification(string2 + ";" + string);
    }

    public static boolean isSubscriptionActive(int n) {
        Subscription subscription = SubscriptionMgr.lookup(n);
        if (subscription != null) {
            subscription.restartTimer();
            return true;
        }
        return false;
    }

    public static void excludeTx(int n, Coordinator coordinator) throws NoTransactionException {
        Subscription subscription = SubscriptionMgr.lookup(n);
        if (subscription != null) {
            subscription.excludeTx(coordinator);
        }
    }

    public static synchronized void restoreSubscriptions() {
        try {
            String string = null;
            allSubscriptions = null;
            persistentSubscriptions = null;
            allSubscriptions = new Hashtable();
            persistentSubscriptions = new Vector();
            if (System.getProperty("SIM") == null) {
                string = TARGET_PATH;
            } else {
                string = new File(HOST_PATH).isDirectory() ? HOST_PATH : System.getProperty("user.dir");
                if (!string.endsWith(System.getProperty("file.separator"))) {
                    string = string + System.getProperty("file.separator");
                }
            }
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            oldSubscriptionFile = string + OLD_FILE_NAME;
            subscriptionFile = string + FILE_NAME;
            if (new File(oldSubscriptionFile).exists()) {
                SubscriptionMgr.restoreConsumers(oldSubscriptionFile, true);
            } else if (new File(subscriptionFile).exists()) {
                SubscriptionMgr.restoreConsumers(subscriptionFile, false);
            }
        }
        catch (IOException iOException) {
            new File(subscriptionFile).delete();
            MessageLog.info((Class)SubscriptionMgr.class, (String)("Subscription file is deleted due to " + iOException.toString() + ". No subscriptions are recovered since the subscription file is corrupt"));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)SubscriptionMgr.class, (String)"Error during recovery of CM subscriptions.", (Throwable)exception);
        }
    }

    public static NotificationFilterExt convertToNewFilter(NotificationFilter notificationFilter) {
        MOTypeAndAttributes[] mOTypeAndAttributesArray = new MOTypeAndAttributes[notificationFilter.types.length];
        for (int i = 0; i < notificationFilter.types.length; ++i) {
            mOTypeAndAttributesArray[i] = new MOTypeAndAttributes(notificationFilter.types[i], new String[0]);
        }
        NotificationFilterExt notificationFilterExt = new NotificationFilterExt(mOTypeAndAttributesArray, notificationFilter.topologyEvents, notificationFilter.avcEvents, notificationFilter.baseMO, notificationFilter.scope);
        return notificationFilterExt;
    }

    private static Subscription lookup(int n) {
        return (Subscription)allSubscriptions.get(new Integer(n));
    }

    public static synchronized void terminateSubscription(int n) {
        Subscription subscription = SubscriptionMgr.lookup(n);
        if (subscription != null) {
            SubscriptionMgr.terminateSubscription(subscription);
        }
    }

    static synchronized void terminateSubscription(Subscription subscription) {
        MessageLog.trace((int)TRACE_GROUP, (Class)SubscriptionMgr.class, (String)("Removed CS subscription with id = " + subscription.getId()));
        subscription.close();
        allSubscriptions.remove(new Integer(subscription.getId()));
        while (persistentSubscriptions.removeElement(new PersistentSubscription_r2(null, subscription.getId(), 0, null, false))) {
        }
        SubscriptionMgr.storeConsumers();
    }

    static Enumeration getAllSubscriptions() {
        Hashtable hashtable = (Hashtable)allSubscriptions.clone();
        return hashtable.elements();
    }

    private SubscriptionMgr() {
    }

    private static synchronized void storeConsumers() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(subscriptionFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(persistentSubscriptions);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            MessageLog.info((Class)SubscriptionMgr.class, (String)("A subscription is not stored due to " + iOException.toString() + ".  The file system is temporarily unavailable."));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)SubscriptionMgr.class, (String)("Error when writing " + subscriptionFile), (Throwable)exception);
        }
    }

    public static synchronized void restoreConsumers(String string, boolean bl) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        ObjectInputStream objectInputStream;
        Object object4;
        boolean bl2 = false;
        boolean bl3 = false;
        persistentSubscriptions.removeAllElements();
        if (bl) {
            object4 = new FileInputStream(string);
            objectInputStream = new ObjectInputStream((InputStream)object4);
            vector = (Vector)objectInputStream.readObject();
            ((FileInputStream)object4).close();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (object2 != null) {
                    object = (PersistentSubscription)object2;
                    PersistentSubscription_r2 persistentSubscription_r2 = new PersistentSubscription_r2(((PersistentSubscription)object).getIor(), ((PersistentSubscription)object).getSubId(), ((PersistentSubscription)object).getTimeTick(), SubscriptionMgr.convertToNewFilter(((PersistentSubscription)object).getFilter()), false);
                    persistentSubscriptions.addElement(persistentSubscription_r2);
                    continue;
                }
                MessageLog.info((Class)(class$se$ericsson$cello$csnotification$SubscriptionMgr == null ? SubscriptionMgr.class$("se.ericsson.cello.csnotification.SubscriptionMgr") : class$se$ericsson$cello$csnotification$SubscriptionMgr), (String)"Encountered null object in subscription file, removing it.");
            }
            new File(string).delete();
            SubscriptionMgr.storeConsumers();
        } else {
            object4 = new FileInputStream(string);
            objectInputStream = new ObjectInputStream((InputStream)object4);
            vector = (Vector)objectInputStream.readObject();
            ((FileInputStream)object4).close();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (object2 != null) {
                    persistentSubscriptions.addElement(object2);
                    continue;
                }
                bl2 = true;
                MessageLog.info((Class)(class$se$ericsson$cello$csnotification$SubscriptionMgr == null ? SubscriptionMgr.class$("se.ericsson.cello.csnotification.SubscriptionMgr") : class$se$ericsson$cello$csnotification$SubscriptionMgr), (String)"Encountered null object in subscription file, removing it.");
            }
            if (bl2) {
                new File(string).delete();
                SubscriptionMgr.storeConsumers();
            }
        }
        if (persistentSubscriptions.size() > MAX_NO_OF_SUBSCRIPTIONS) {
            persistentSubscriptions.clear();
            SubscriptionMgr.storeConsumers();
            MessageLog.info((Class)SubscriptionMgr.class, (String)"Subscription file contained too many subscriptions, clearing it.");
        } else {
            object4 = persistentSubscriptions.elements();
            boolean bl4 = false;
            while (!bl4 && object4.hasMoreElements()) {
                object3 = (PersistentSubscription_r2)object4.nextElement();
                if (SubscriptionMgr.lookup(((PersistentSubscription_r2)object3).getSubId()) != null) {
                    SubscriptionMgr.deleteAllSubscriptions();
                    bl4 = true;
                    MessageLog.info((Class)(class$se$ericsson$cello$csnotification$SubscriptionMgr == null ? SubscriptionMgr.class$("se.ericsson.cello.csnotification.SubscriptionMgr") : class$se$ericsson$cello$csnotification$SubscriptionMgr), (String)"Found multiple subscriptions using the same id, deleting all subscriptions.");
                    continue;
                }
                try {
                    object2 = NotificationConsumerHelper.narrow(CelloOrb.instance().string_to_object(((PersistentSubscription_r2)object3).getIor()));
                    object = new Subscription((NotificationConsumer)object2, ((PersistentSubscription_r2)object3).getFilter(), ((PersistentSubscription_r2)object3).getSubId(), ((PersistentSubscription_r2)object3).getTimeTick(), ((PersistentSubscription_r2)object3).isSDNSupported());
                    allSubscriptions.put(new Integer(((PersistentSubscription_r2)object3).getSubId()), object);
                    if (((PersistentSubscription_r2)object3).getSubId() < nextSubscriptionId) continue;
                    nextSubscriptionId = ((PersistentSubscription_r2)object3).getSubId() + 1;
                }
                catch (SystemException systemException) {
                    bl3 = true;
                    MessageLog.info((Class)(class$se$ericsson$cello$csnotification$SubscriptionMgr == null ? SubscriptionMgr.class$("se.ericsson.cello.csnotification.SubscriptionMgr") : class$se$ericsson$cello$csnotification$SubscriptionMgr), (String)("Failed to recover subscription due to: " + (Object)((Object)systemException)));
                }
            }
            if (bl3) {
                SubscriptionMgr.storeConsumers();
            }
        }
    }

    private static synchronized void deleteAllSubscriptions() {
        Enumeration enumeration = allSubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            SubscriptionMgr.terminateSubscription((Subscription)enumeration.nextElement());
        }
    }

    private static synchronized void deleteOldestSubscription() {
        TreeSet treeSet = new TreeSet(allSubscriptions.keySet());
        SubscriptionMgr.terminateSubscription((Subscription)allSubscriptions.get(treeSet.first()));
    }

    private static String removePrefix(String string, Mib mib) {
        String string2 = MibMgr.instance().getMib().getMibPrefix();
        String string3 = string2.equals("") ? string : (string.indexOf(string2) == 0 ? string.substring(string2.length() + 1) : string);
        return string3;
    }

    public static String getSubscriptionInfo(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        ORB oRB = org.jacorb.orb.ORB.init((String[])null, null);
        PersistentSubscription_r2 persistentSubscription_r2 = (PersistentSubscription_r2)object;
        stringBuffer.append("Sub ID: ").append(persistentSubscription_r2.subId).append("\n");
        stringBuffer.append("Time tick: ").append(persistentSubscription_r2.timetick).append("\n");
        stringBuffer.append("Filter:\n");
        stringBuffer.append("  Base MO = ").append(((PersistentSubscription_r2)persistentSubscription_r2).filter.baseMO).append("\n");
        stringBuffer.append("  Scope   = ").append(((PersistentSubscription_r2)persistentSubscription_r2).filter.scope).append("\n");
        stringBuffer.append("  Toplogy = ").append(((PersistentSubscription_r2)persistentSubscription_r2).filter.topologyEvents).append("\n");
        stringBuffer.append("  AVC     = ").append(((PersistentSubscription_r2)persistentSubscription_r2).filter.avcEvents).append("\n");
        stringBuffer.append("  isSDNSupported     = ").append(persistentSubscription_r2.SDNSupported).append("\n");
        stringBuffer.append("  Data: \n");
        MOTypeAndAttributes[] mOTypeAndAttributesArray = ((PersistentSubscription_r2)persistentSubscription_r2).filter.typesAndAttributes;
        for (int i = 0; i < mOTypeAndAttributesArray.length; ++i) {
            stringBuffer.append("    MO Type    = ").append(mOTypeAndAttributesArray[i].typeOfMO).append("\n");
            stringBuffer.append("    Attributes = ");
            for (int j = 0; j < mOTypeAndAttributesArray[i].attributes.length; ++j) {
                stringBuffer.append(mOTypeAndAttributesArray[i].attributes[j]).append(" ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SubscriptionMgr.getIORInfo(oRB, persistentSubscription_r2.ior));
        return new String(stringBuffer);
    }

    private static StringBuffer getIORInfo(ORB oRB, String string) {
        ProfileBase profileBase;
        ParsedIOR parsedIOR = new ParsedIOR((org.jacorb.orb.ORB)oRB, string);
        List list = parsedIOR.getProfiles();
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && list.size() != 0 && (profileBase = (ProfileBase)list.get(0)) instanceof IIOPProfile) {
            IIOPProfile iIOPProfile = (IIOPProfile)profileBase;
            stringBuffer.append("Contents of IOR:").append("\n");
            stringBuffer.append("\tIIOPProfileTemplate = ").append("\n");
            stringBuffer.append("\t\tmajor version = " + profileBase.version().major).append("\n");
            stringBuffer.append("\t\tminor version = " + profileBase.version().minor).append("\n");
            stringBuffer.append("\t\thost name = " + ((IIOPAddress)iIOPProfile.getAddress()).getOriginalHost()).append("\n");
            stringBuffer.append("\t\tport number = " + ((IIOPAddress)iIOPProfile.getAddress()).getPort()).append("\n");
        }
        return stringBuffer;
    }

    static {
        MAX_NO_OF_SUBSCRIPTIONS = 25;
        TRACE_GROUP = 5;
        TARGET_PATH = "/c/configuration/";
        HOST_PATH = "/host/tmp";
        OLD_FILE_NAME = "cssubscr.dat";
        FILE_NAME = "cssubscr_r2.dat";
    }

    private static class PersistentSubscription_r2
    implements Serializable {
        private String ior;
        private int subId;
        private int timetick;
        private NotificationFilterExt filter;
        private boolean SDNSupported = false;
        static final long serialVersionUID = 1L;

        PersistentSubscription_r2(String string, int n, int n2, NotificationFilterExt notificationFilterExt, boolean bl) {
            this.ior = string;
            this.subId = n;
            this.timetick = n2;
            this.filter = notificationFilterExt;
            this.SDNSupported = bl;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            return ((PersistentSubscription_r2)object).getSubId() == this.subId;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        String getIor() {
            return this.ior;
        }

        int getSubId() {
            return this.subId;
        }

        int getTimeTick() {
            return this.timetick;
        }

        NotificationFilterExt getFilter() {
            return this.filter;
        }

        boolean isSDNSupported() {
            return this.SDNSupported;
        }
    }

    private static class PersistentSubscription
    implements Serializable {
        private String ior;
        private int subId;
        private int timetick;
        private NotificationFilter filter;
        static final long serialVersionUID = 1L;

        PersistentSubscription(String string, int n, int n2, NotificationFilter notificationFilter) {
            this.ior = string;
            this.subId = n;
            this.timetick = n2;
            this.filter = notificationFilter;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            return ((PersistentSubscription)object).getSubId() == this.subId;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        String getIor() {
            return this.ior;
        }

        int getSubId() {
            return this.subId;
        }

        int getTimeTick() {
            return this.timetick;
        }

        NotificationFilter getFilter() {
            return this.filter;
        }
    }
}

