/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotification;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotificationSetTypeHelper;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmDuplicatedException;
import se.ericsson.cello.faultmanagement.AlarmEventLogHelper;
import se.ericsson.cello.faultmanagement.AlarmIRP_1Impl;
import se.ericsson.cello.faultmanagement.AlarmInterceptor;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.faultmanagement.AlarmService;
import se.ericsson.cello.faultmanagement.Alarmable;
import se.ericsson.cello.faultmanagement.SeverityConfiguration;
import se.ericsson.cello.faultmanagement.TogglingController;
import se.ericsson.cello.faultmanagement.UpdatableAlarm;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.notification.Filter;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.XmlHelper;

public final class Alarm
implements UpdatableAlarm {
    private Alarmable myAlarmable;
    static final int TRACE_GROUP = 2;
    private static AlarmInterceptor myAlarmInterceptor;
    private static long nrOfAlarms;
    private static final int SIZE_OF_PRIMARY_ALARM = 13;
    private static final int SIZE_OF_SECONDARY_ALARM = 14;
    private String managedObjectClass = "";
    private String ldn = "";
    private int notificationId;
    private CorrelatedNotification[] correlatedNotifications;
    private UtcT eventTime;
    private String eventType = "";
    private short probableCause;
    private short perceivedSeverity;
    private short tempPerceivedSeverity;
    private String specificProblem = "";
    String additionalText = "";
    private String updateAdditionalText = "";
    private AdditionalInfo[] additionalInfoList;
    private AdditionalInfo[] updateAdditionalInfoList;
    private String alarmId = "";
    private UtcT ackTime;
    private String ackUserId = "";
    private short ackState = (short)2;
    private int eventId = 0;
    private boolean secondaryAlarm;
    private static Hashtable alarmList;
    private static Hashtable eventIdList;
    private static Vector activeAlarms;
    private static Vector filteredAlarms;
    static final String RDN_SEPARATOR = ",";
    private boolean isActive;
    private boolean changeOfSeverityInProgress;
    private boolean changeOfAdditionalInfo;
    private static boolean isSilentFmMode;
    private String receivedEventTime = "";
    static boolean filterPeriod;
    private static final int CONVERT_MS_TO_100NS = 10000;
    private static final boolean NO_SECONDARY_ALARM = false;
    private static final int UNSPECIFIED_EVENTID = 0;
    private static final int ALARM_LOG_SIZE = 3000000;
    private static final String ALARM_LOG = "ALARM_LOG";
    private static final String ALARM_LOG_PATH = "alarm_event";
    private static final String SEPARATOR = ";";
    private static final String EMPTY_STRING = "";
    private static final int MILLISEC = 1000;
    private static final int SEC = 60;
    private static AlarmEventLogHelper logHelper;

    public static Alarm create(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdditionalInfo[] additionalInfoArray, int[] nArray, boolean bl) throws AlarmDuplicatedException {
        Alarm alarm = Alarm.createAlarm(string, string2, string3, string4, string5, string6, string7, string8, additionalInfoArray, nArray, bl, true);
        return alarm;
    }

    public static Alarm create(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdditionalInfo[] additionalInfoArray) throws AlarmDuplicatedException {
        int[] nArray = new int[]{0};
        Alarm alarm = Alarm.createAlarm(string, string2, string3, string4, string5, string6, string7, string8, additionalInfoArray, nArray, false, true);
        return alarm;
    }

    public void clear() {
        this.clear(true);
    }

    public static void setSilentFmMode(boolean bl) {
        if (!isSilentFmMode && bl) {
            AlarmManager.getReporter().reportEvent(99, MibMgr.instance().getMib().getRootMo(), EMPTY_STRING, EMPTY_STRING, null);
            isSilentFmMode = bl;
        }
        if (isSilentFmMode && !bl) {
            isSilentFmMode = bl;
            AlarmManager.getReporter().reportEvent(100, MibMgr.instance().getMib().getRootMo(), EMPTY_STRING, EMPTY_STRING, null);
            AlarmIRP_1Impl.instance().notifyAlarmListRebuilt();
        }
    }

    public static boolean getSilentFmMode() {
        return isSilentFmMode;
    }

    public void setPerceivedSeverity(String string) {
        this.setPerceivedSeverity(string, true);
    }

    public void setAdditionalText(String string) {
        this.setAdditionalText(string, true);
    }

    public void setAdditionalTextByTogglingController(String string) {
        this.additionalText = string;
    }

    public void setAdditionalInfo(AdditionalInfo[] additionalInfoArray) {
        if (!TogglingController.getInstance().isAlarmSuppressedAtChange(this)) {
            this.updateAdditionalInfoList = new AdditionalInfo[additionalInfoArray.length];
            this.updateAdditionalInfoList = additionalInfoArray;
            this.changeOfAdditionalInfo = true;
            if (myAlarmInterceptor == null) {
                this.processChanged();
            } else {
                myAlarmInterceptor.changedAlarm(this.getAlarmable());
            }
        }
    }

    static Alarm lookup(String string) {
        int n = string.lastIndexOf(95);
        return (Alarm)alarmList.get(string.substring(n + 1));
    }

    static void createAlarmLog() {
        try {
            logHelper.lookupLogRef();
        }
        catch (LogInternalErrorException logInternalErrorException) {
            MessageLog.info((Class)Alarm.class, (String)("Failed to create/find the alarm log due to " + logInternalErrorException.getMessage() + ", another try is done later. "));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)Alarm.class, (String)"Creating/finding the alarm log failed.", (Throwable)exception);
        }
    }

    static Enumeration lookupAll() {
        return ((Hashtable)alarmList.clone()).elements();
    }

    static Enumeration getFilteredAlarms() {
        return ((Vector)filteredAlarms.clone()).elements();
    }

    static void removeActiveAlarm(Alarm alarm) {
        activeAlarms.removeElement(Alarm.createDuplicateId(alarm.ldn, alarm.specificProblem));
    }

    static Enumeration lookupAll(Filter filter) {
        if (filter == null) {
            return alarmList.elements();
        }
        Vector<Alarm> vector = new Vector<Alarm>();
        Hashtable hashtable = (Hashtable)alarmList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Alarm alarm = (Alarm)enumeration.nextElement();
            if (filter.match(alarm.getPerceivedSeverity(), alarm.getSpecificProblem(), alarm.getLDN())) continue;
            vector.addElement(alarm);
        }
        return vector.elements();
    }

    static boolean isSeverityInvalid(short s) {
        return s != 1 && s != 2 && s != 3 && s != 4 && s != 5 && s != 6;
    }

    static StructuredEvent[] getAlarmListAsStructuredEvents() {
        return Alarm.getAlarmListAsStructuredEvents(null);
    }

    static StructuredEvent[] getAlarmListAsStructuredEvents(Filter filter) {
        Vector<StructuredEvent> vector = new Vector<StructuredEvent>();
        Hashtable hashtable = (Hashtable)alarmList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            StructuredEvent structuredEvent = Alarm.createStructuredEvent((Alarm)enumeration.nextElement(), "x1", filter);
            if (structuredEvent == null) continue;
            vector.addElement(structuredEvent);
        }
        StructuredEvent[] structuredEventArray = new StructuredEvent[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            structuredEventArray[i] = (StructuredEvent)vector.elementAt(i);
        }
        return structuredEventArray;
    }

    static StructuredEvent createStructuredEvent(Alarm alarm, String string) {
        return Alarm.createStructuredEvent(alarm, string, null);
    }

    static StructuredEvent createStructuredEvent(Alarm alarm, String string, Filter filter) {
        Any any;
        EventHeader eventHeader;
        Object object;
        if (filter != null && filter.match(alarm.getPerceivedSeverity(), alarm.getSpecificProblem(), alarm.getLDN())) {
            return null;
        }
        AdditionalInfo[] additionalInfoArray = alarm.getAdditionalInfoList();
        int n = 0;
        StructuredEvent structuredEvent = new StructuredEvent();
        structuredEvent.filterable_data = additionalInfoArray != null ? (alarm.secondaryAlarm ? new Property[14 + additionalInfoArray.length] : new Property[13 + additionalInfoArray.length]) : (alarm.secondaryAlarm ? new Property[14] : new Property[13]);
        Any any2 = CelloOrb.instance().create_any();
        any2.insert_string(alarm.getManagedObjectClass());
        structuredEvent.filterable_data[n++] = new Property("e", any2);
        Any any3 = CelloOrb.instance().create_any();
        any3.insert_string(alarm.getManagedObjectInstance());
        structuredEvent.filterable_data[n++] = new Property("f", any3);
        Any any4 = CelloOrb.instance().create_any();
        any4.insert_long(alarm.getNotificationId());
        structuredEvent.filterable_data[n++] = new Property("a", any4);
        Any any5 = CelloOrb.instance().create_any();
        UtcTHelper.insert(any5, alarm.getEventTime());
        structuredEvent.filterable_data[n++] = new Property("c", any5);
        Any any6 = CelloOrb.instance().create_any();
        any6.insert_string(alarm.getSystemDN());
        structuredEvent.filterable_data[n++] = new Property("d", any6);
        Any any7 = CelloOrb.instance().create_any();
        any7.insert_short(alarm.getProbableCause());
        structuredEvent.filterable_data[n++] = new Property("g", any7);
        Any any8 = CelloOrb.instance().create_any();
        any8.insert_short(alarm.getPerceivedSeverity());
        structuredEvent.filterable_data[n++] = new Property("h", any8);
        Any any9 = CelloOrb.instance().create_any();
        any9.insert_string(alarm.getSpecificProblem());
        structuredEvent.filterable_data[n++] = new Property("i", any9);
        Any any10 = CelloOrb.instance().create_any();
        any10.insert_string(alarm.getAdditionalText());
        structuredEvent.filterable_data[n++] = new Property("j", any10);
        Any any11 = CelloOrb.instance().create_any();
        any11.insert_string(alarm.getAlarmId());
        structuredEvent.filterable_data[n++] = new Property("k", any11);
        Any any12 = CelloOrb.instance().create_any();
        UtcTHelper.insert(any12, alarm.getAckTime());
        structuredEvent.filterable_data[n++] = new Property("m", any12);
        Any any13 = CelloOrb.instance().create_any();
        any13.insert_string(alarm.getAckUserId());
        structuredEvent.filterable_data[n++] = new Property("l", any13);
        Any any14 = CelloOrb.instance().create_any();
        any14.insert_short(alarm.getAckState());
        structuredEvent.filterable_data[n++] = new Property("o", any14);
        if (alarm.secondaryAlarm) {
            object = CelloOrb.instance().create_any();
            CorrelatedNotificationSetTypeHelper.insert((Any)object, alarm.getCorrelatedNotifications());
            structuredEvent.filterable_data[n++] = new Property("b", (Any)object);
        }
        if (additionalInfoArray != null) {
            object = new Any[additionalInfoArray.length];
            for (int i = 0; i < additionalInfoArray.length; ++i) {
                object[i] = CelloOrb.instance().create_any();
                object[i].insert_string(additionalInfoArray[i].getValue());
                structuredEvent.filterable_data[n++] = new Property(additionalInfoArray[i].getName(), object[i]);
            }
        }
        object = new EventType("1f1", alarm.getEventType());
        FixedEventHeader fixedEventHeader = new FixedEventHeader((EventType)object, string);
        structuredEvent.header = eventHeader = new EventHeader(fixedEventHeader, new Property[0]);
        structuredEvent.remainder_of_body = any = CelloOrb.instance().create_any();
        return structuredEvent;
    }

    static void setAckStatus(Alarm alarm, String string, String string2, short s) {
        UtcT utcT;
        long l = 0L;
        short s2 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        short s3 = (short)(gregorianCalendar.get(15) / 60000);
        if (s == 2) {
            alarm.setAckUserId(EMPTY_STRING);
            utcT = new UtcT(l, 0, s2, s3);
        } else {
            alarm.setAckUserId(string);
            l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
            utcT = new UtcT(l, 0, s2, s3);
        }
        alarm.setAckTime(utcT);
        alarm.setAckState(s);
        if (!isSilentFmMode) {
            StructuredEvent structuredEvent = Alarm.createStructuredEvent(alarm, "x3");
            AlarmIRP_1Impl.instance().notifyAlarm(structuredEvent, alarm.getPerceivedSeverity(), alarm.getSpecificProblem(), alarm.getManagedObjectInstance());
        }
        alarm.logAlarm("x3");
    }

    private void logAlarm(String string) {
        int n;
        AdditionalInfo[] additionalInfoArray = this.getAdditionalInfoList();
        CorrelatedNotification[] correlatedNotificationArray = this.getCorrelatedNotifications();
        StringBuffer stringBuffer = new StringBuffer("1f1");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getEventType());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getManagedObjectClass());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getManagedObjectInstance());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getNotificationId());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.eventTime.time);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getSystemDN());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getProbableCause());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getPerceivedSeverity());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getSpecificProblem());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getCorrelatedNotifications().length);
        stringBuffer.append(SEPARATOR);
        if (correlatedNotificationArray != null) {
            for (n = 0; n < correlatedNotificationArray.length; ++n) {
                stringBuffer.append(correlatedNotificationArray[n].source);
                stringBuffer.append(SEPARATOR);
                stringBuffer.append(correlatedNotificationArray[n].notifIDSet[0]);
                stringBuffer.append(SEPARATOR);
            }
        }
        stringBuffer.append(this.getAdditionalText());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getAlarmId());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getAckUserId());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.ackTime.time);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getAckState());
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.eventTime.tdf);
        stringBuffer.append(SEPARATOR);
        if (additionalInfoArray != null) {
            stringBuffer.append(additionalInfoArray.length);
            stringBuffer.append(SEPARATOR);
            for (n = 0; n < additionalInfoArray.length; ++n) {
                stringBuffer.append(additionalInfoArray[n].getName());
                stringBuffer.append(SEPARATOR);
                stringBuffer.append(XmlHelper.encodeXml(additionalInfoArray[n].getValue()));
                stringBuffer.append(SEPARATOR);
            }
        } else {
            stringBuffer.append("0");
            stringBuffer.append(SEPARATOR);
        }
        logHelper.enqueue(stringBuffer.toString());
    }

    private Alarm(String string, String string2, int n, CorrelatedNotification[] correlatedNotificationArray, String string3, String string4, short s, short s2, String string5, String string6, AdditionalInfo[] additionalInfoArray, String string7, int n2, boolean bl) {
        if (string3 != null && string3.length() != 0) {
            this.receivedEventTime = string3;
        }
        this.managedObjectClass = string;
        this.ldn = string2;
        this.correlatedNotifications = correlatedNotificationArray;
        this.notificationId = n;
        this.eventType = string4;
        this.probableCause = s;
        this.tempPerceivedSeverity = this.perceivedSeverity = this.checkAndReplaceSeverityConfiguration(s2, string5);
        this.specificProblem = string5;
        this.additionalText = string6;
        this.updateAdditionalText = string6;
        this.eventId = n2;
        this.secondaryAlarm = bl;
        if (additionalInfoArray != null) {
            this.additionalInfoList = new AdditionalInfo[additionalInfoArray.length];
            this.additionalInfoList = additionalInfoArray;
            this.updateAdditionalInfoList = new AdditionalInfo[additionalInfoArray.length];
            this.updateAdditionalInfoList = additionalInfoArray;
        }
        this.alarmId = string7;
    }

    public String getAlarmId() {
        return this.getSystemDN() + "_" + this.alarmId;
    }

    public String getSystemDN() {
        return MibMgr.instance().getMib().getMibPrefix();
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public short getAckState() {
        return this.ackState;
    }

    public short getPerceivedSeverity() {
        return this.perceivedSeverity;
    }

    public String getManagedObjectClass() {
        return this.managedObjectClass;
    }

    public String getManagedObjectInstance() {
        String string = MibMgr.instance().getMib().getMibPrefix();
        if (string.length() == 0) {
            return this.ldn;
        }
        return string + RDN_SEPARATOR + this.ldn;
    }

    public UtcT getEventTime() {
        return this.eventTime;
    }

    public String getEventType() {
        return this.eventType;
    }

    public short getProbableCause() {
        return this.probableCause;
    }

    public String getSpecificProblem() {
        return this.specificProblem;
    }

    public String getAckUserId() {
        return this.ackUserId;
    }

    public UtcT getAckTime() {
        return this.ackTime;
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public AdditionalInfo[] getAdditionalInfoList() {
        return this.additionalInfoList;
    }

    public CorrelatedNotification[] getCorrelatedNotifications() {
        return this.correlatedNotifications;
    }

    String getLDN() {
        return this.ldn;
    }

    private boolean isSeverityMoreUrgent(short s) {
        boolean bl = false;
        if (s == 1 && this.perceivedSeverity != 1) {
            bl = true;
        }
        if (s == 5 && (this.perceivedSeverity == 4 || this.perceivedSeverity == 3 || this.perceivedSeverity == 2)) {
            bl = true;
        }
        if (s == 4 && (this.perceivedSeverity == 3 || this.perceivedSeverity == 2)) {
            bl = true;
        }
        if (s == 3 && this.perceivedSeverity == 2) {
            bl = true;
        }
        return bl;
    }

    private static String removeMibPrefix(String string) {
        String string2 = MibMgr.instance().getMib().getRootMo().getLocalDistinguishedName();
        String string3 = string;
        int n = string.indexOf(string2);
        if (n != -1) {
            string3 = string.substring(n);
        } else {
            MessageLog.traceError((Class)Alarm.class, (String)("removeMibPrefix: Could not remove MIB prefix from: " + string));
        }
        return string3;
    }

    private static AdditionalInfo[] checkadditionalInfoList(AdditionalInfo[] additionalInfoArray, String string) {
        if (additionalInfoArray == null) {
            return additionalInfoArray;
        }
        LinkedList<AdditionalInfo> linkedList = new LinkedList<AdditionalInfo>();
        AdditionalInfo[] additionalInfoArray2 = null;
        for (int i = 0; i < additionalInfoArray.length; ++i) {
            if (additionalInfoArray[i] != null) {
                linkedList.add(additionalInfoArray[i]);
                continue;
            }
            MessageLog.info((Class)(class$se$ericsson$cello$faultmanagement$Alarm == null ? Alarm.class$("se.ericsson.cello.faultmanagement.Alarm") : class$se$ericsson$cello$faultmanagement$Alarm), (String)("checkadditionalInfoList:Null element from MO type " + string));
        }
        additionalInfoArray2 = new AdditionalInfo[linkedList.size()];
        linkedList.toArray(additionalInfoArray2);
        return additionalInfoArray2;
    }

    private static String checkAndReplaceNullString(String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        return string;
    }

    private short checkAndReplaceSeverityConfiguration(short s, String string) {
        short s2 = SeverityConfiguration.instance().getSeverity(string);
        if (s2 != 0) {
            return s2;
        }
        return s;
    }

    private synchronized Alarmable getAlarmable() {
        if (this.myAlarmable == null) {
            this.myAlarmable = new AlarmableImpl();
        }
        return this.myAlarmable;
    }

    private static synchronized Alarm createAlarm(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdditionalInfo[] additionalInfoArray, int[] nArray, boolean bl, boolean bl2) throws AlarmDuplicatedException {
        Object object;
        short s;
        short s2;
        CorrelatedNotification[] correlatedNotificationArray = new CorrelatedNotification[]{};
        string = Alarm.checkAndReplaceNullString(string);
        string2 = Alarm.checkAndReplaceNullString(string2);
        string3 = Alarm.checkAndReplaceNullString(string3);
        string4 = Alarm.checkAndReplaceNullString(string4);
        string5 = Alarm.checkAndReplaceNullString(string5);
        string6 = Alarm.checkAndReplaceNullString(string6);
        string7 = Alarm.checkAndReplaceNullString(string7);
        string8 = Alarm.checkAndReplaceNullString(string8);
        additionalInfoArray = Alarm.checkadditionalInfoList(additionalInfoArray, string);
        String string9 = Alarm.removeMibPrefix(string2);
        try {
            s2 = Short.parseShort(string5);
            s = Short.parseShort(string6);
        }
        catch (NumberFormatException numberFormatException) {
            MessageLog.traceError((Class)Alarm.class, (String)"Invalid parameters in Alarm", (Throwable)numberFormatException);
            return null;
        }
        if (string6 == "6") {
            MessageLog.traceError((Class)Alarm.class, (String)"Invalid parameters in Alarm, severity cleared");
            return null;
        }
        if (myAlarmInterceptor == null && activeAlarms.contains(string9 + string7)) {
            throw new AlarmDuplicatedException();
        }
        string8 = string8.replace(';', ':');
        String string10 = new Long(++nrOfAlarms).toString();
        int n = NotificationIRPImpl.instance().getNotificationId();
        if (bl && nArray != null && nArray.length != 0) {
            object = new Vector();
            for (int i = 0; i < nArray.length; ++i) {
                Alarm alarm = (Alarm)eventIdList.get(new Integer(nArray[i]));
                if (alarm == null) continue;
                int[] nArray2 = new int[]{alarm.getNotificationId()};
                CorrelatedNotification correlatedNotification = new CorrelatedNotification(alarm.getManagedObjectInstance(), nArray2);
                ((Vector)object).addElement(correlatedNotification);
            }
            correlatedNotificationArray = new CorrelatedNotification[((Vector)object).size()];
            Enumeration enumeration = ((Vector)object).elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                correlatedNotificationArray[n2++] = (CorrelatedNotification)enumeration.nextElement();
            }
        }
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{0};
        }
        object = new Alarm(string, string9, n, correlatedNotificationArray, string4, string3, s2, s, string7, string8, additionalInfoArray, string10, nArray[0], bl);
        if (!bl && nArray[0] != 0) {
            eventIdList.put(new Integer(nArray[0]), object);
        }
        if (filterPeriod) {
            activeAlarms.addElement(Alarm.createDuplicateId(string9, string7));
            filteredAlarms.add(object);
            return object;
        }
        if (TogglingController.getInstance().isAlarmSuppressedAtCreate((Alarm)object)) {
            activeAlarms.addElement(Alarm.createDuplicateId(string9, string7));
            return object;
        }
        if (myAlarmInterceptor == null) {
            super.processNew();
        } else if (bl2) {
            MessageLog.trace((int)2, object.getClass(), (String)("New alarm, id = " + ((Alarm)object).getAlarmId() + ", SpecificProblem = " + ((Alarm)object).getSpecificProblem() + ", ManagedObjectInstance = " + ((Alarm)object).getManagedObjectInstance() + "Alarm sent to interceptor"));
            myAlarmInterceptor.newAlarm(super.getAlarmable());
        }
        return object;
    }

    public synchronized void activateAlarmAfterEndOfToggling() {
        try {
            if (myAlarmInterceptor == null) {
                this.processNew();
            } else {
                MessageLog.trace((int)2, this.getClass(), (String)("New alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance() + ", Alarm sent to interceptor after end of toggling"));
                myAlarmInterceptor.newAlarm(this.getAlarmable());
            }
        }
        catch (AlarmDuplicatedException alarmDuplicatedException) {
            // empty catch block
        }
    }

    public synchronized void activateAlarmAfterEndOfFilterPeriod() {
        try {
            if (filteredAlarms.contains(this)) {
                filteredAlarms.remove(this);
                if (myAlarmInterceptor == null) {
                    this.processNew();
                } else {
                    MessageLog.trace((int)2, this.getClass(), (String)("New alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance() + ", Alarm sent to interceptor after end of filter period"));
                    myAlarmInterceptor.newAlarm(this.getAlarmable());
                }
            }
        }
        catch (AlarmDuplicatedException alarmDuplicatedException) {
            // empty catch block
        }
    }

    public static Alarmable createNoInterceptorCallback(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdditionalInfo[] additionalInfoArray, int[] nArray, boolean bl) throws AlarmDuplicatedException {
        Alarm alarm = Alarm.createAlarm(string, string2, string3, string4, string5, string6, string7, string8, additionalInfoArray, nArray, bl, false);
        return alarm.getAlarmable();
    }

    public static Alarmable createNoInterceptorCallback(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, AdditionalInfo[] additionalInfoArray) throws AlarmDuplicatedException {
        int[] nArray = new int[]{0};
        Alarm alarm = Alarm.createAlarm(string, string2, string3, string4, string5, string6, string7, string8, additionalInfoArray, nArray, false, false);
        return alarm.getAlarmable();
    }

    public Alarmable clearNoInterceptorCallback() {
        this.clear(false);
        return this.getAlarmable();
    }

    private synchronized void clear(boolean bl) {
        activeAlarms.removeElement(Alarm.createDuplicateId(this.ldn, this.specificProblem));
        if (filterPeriod || filteredAlarms.contains(this)) {
            filteredAlarms.remove(this);
            return;
        }
        if (!this.secondaryAlarm && this.eventId != 0) {
            eventIdList.remove(new Integer(this.eventId));
        }
        if (!TogglingController.getInstance().isAlarmSuppressedAtClear(this)) {
            if (myAlarmInterceptor == null) {
                this.processCleared();
            } else if (bl) {
                MessageLog.trace((int)2, this.getClass(), (String)("Cleared alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance() + ", Cleared sent to interceptor"));
                myAlarmInterceptor.clearedAlarm(this.getAlarmable());
            }
        }
    }

    public Alarmable setPerceivedSeverityNoInterceptorCallback(String string) {
        this.setPerceivedSeverity(string, false);
        return this.getAlarmable();
    }

    private void setPerceivedSeverity(String string, boolean bl) {
        if (!TogglingController.getInstance().isAlarmSuppressedAtChange(this)) {
            if (Alarm.isSeverityInvalid(Short.parseShort(string = Alarm.checkAndReplaceNullString(string)))) {
                throw new IllegalArgumentException();
            }
            this.tempPerceivedSeverity = Short.parseShort(string);
            this.changeOfSeverityInProgress = true;
            if (myAlarmInterceptor == null) {
                this.processChanged();
            } else if (bl) {
                myAlarmInterceptor.changedAlarm(this.getAlarmable());
            }
        }
    }

    public Alarmable setAdditionalTextNoInterceptorCallback(String string) {
        this.setAdditionalText(string, false);
        return this.getAlarmable();
    }

    private void setAdditionalText(String string, boolean bl) {
        if (!TogglingController.getInstance().isAlarmSuppressedAtChange(this)) {
            this.updateAdditionalText = string = Alarm.checkAndReplaceNullString(string);
            if (myAlarmInterceptor == null) {
                this.processChanged();
            } else if (bl) {
                myAlarmInterceptor.changedAlarm(this.getAlarmable());
            }
        }
    }

    public static void registerAlarmInterceptor(AlarmInterceptor alarmInterceptor) {
        myAlarmInterceptor = alarmInterceptor;
    }

    public static void deregisterAlarmInterceptor() {
        myAlarmInterceptor = null;
    }

    private Alarm processNew() throws AlarmDuplicatedException {
        GregorianCalendar gregorianCalendar;
        MessageLog.trace((int)2, this.getClass(), (String)("New alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance() + ", receivedEventTime = " + this.receivedEventTime));
        MessageLog.trace((int)2, this.getClass(), (String)("Using system parameter 50, FilterAlarmTimer = " + AlarmService.getFilterTime() + "s"));
        if (activeAlarms.contains(this.ldn + this.specificProblem)) {
            throw new AlarmDuplicatedException();
        }
        short s = 0;
        if (this.receivedEventTime != null && this.receivedEventTime.length() != 0) {
            try {
                int n = Integer.parseInt(this.receivedEventTime.substring(0, 4));
                int n2 = Integer.parseInt(this.receivedEventTime.substring(4, 6));
                int n3 = Integer.parseInt(this.receivedEventTime.substring(6, 8));
                int n4 = Integer.parseInt(this.receivedEventTime.substring(8, 10));
                int n5 = Integer.parseInt(this.receivedEventTime.substring(10, 12));
                int n6 = Integer.parseInt(this.receivedEventTime.substring(12, 14));
                gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
            }
            catch (NumberFormatException numberFormatException) {
                MessageLog.traceError((Class)Alarm.class, (String)"Invalid Event Time parameters in Alarm", (Throwable)numberFormatException);
                gregorianCalendar = new GregorianCalendar();
            }
        } else {
            gregorianCalendar = new GregorianCalendar();
        }
        short s2 = (short)(gregorianCalendar.get(15) / 60000);
        long l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
        this.eventTime = new UtcT(l, 0, s, s2);
        this.ackTime = new UtcT(0L, 0, s, s2);
        alarmList.put(this.alarmId, this);
        activeAlarms.addElement(Alarm.createDuplicateId(this.ldn, this.specificProblem));
        if (!isSilentFmMode) {
            StructuredEvent structuredEvent = Alarm.createStructuredEvent(this, "x1");
            AlarmIRP_1Impl.instance().notifyAlarm(structuredEvent, this.perceivedSeverity, this.specificProblem, this.ldn);
        }
        this.logAlarm("x1");
        this.isActive = true;
        return this;
    }

    private Alarm processCleared() {
        MessageLog.trace((int)2, this.getClass(), (String)("Cleared alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance()));
        long l = 0L;
        short s = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        short s2 = (short)(gregorianCalendar.get(15) / 60000);
        if (this.isActive) {
            l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
            this.eventTime = new UtcT(l, 0, s, s2);
            this.perceivedSeverity = (short)6;
            alarmList.remove(this.alarmId);
            this.isActive = false;
            if (!isSilentFmMode) {
                StructuredEvent structuredEvent = Alarm.createStructuredEvent(this, "x4");
                AlarmIRP_1Impl.instance().notifyAlarm(structuredEvent, this.perceivedSeverity, this.specificProblem, this.ldn);
            }
            this.logAlarm("x4");
        }
        return this;
    }

    private Alarm processChanged() {
        MessageLog.trace((int)2, this.getClass(), (String)("Changed alarm, id = " + this.getAlarmId() + ", SpecificProblem = " + this.getSpecificProblem() + ", ManagedObjectInstance = " + this.getManagedObjectInstance()));
        long l = 0L;
        short s = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        short s2 = (short)(gregorianCalendar.get(15) / 60000);
        if (this.isActive) {
            if (this.changeOfSeverityInProgress) {
                short s3 = this.perceivedSeverity;
                this.changeOfSeverityInProgress = false;
                this.perceivedSeverity = this.tempPerceivedSeverity;
            } else if (this.changeOfAdditionalInfo) {
                this.changeOfAdditionalInfo = false;
                this.additionalInfoList = new AdditionalInfo[this.updateAdditionalInfoList.length];
                this.additionalInfoList = this.updateAdditionalInfoList;
            } else {
                this.additionalText = this.updateAdditionalText;
            }
            l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
            this.eventTime = new UtcT(l, 0, s, s2);
            if (!isSilentFmMode) {
                StructuredEvent structuredEvent = Alarm.createStructuredEvent(this, "x2");
                AlarmIRP_1Impl.instance().notifyAlarm(structuredEvent, this.perceivedSeverity, this.specificProblem, this.ldn);
            }
            this.logAlarm("x2");
        }
        return this;
    }

    private void setAckUserId(String string) {
        this.ackUserId = string;
    }

    private void setAckState(short s) {
        this.ackState = s;
    }

    private void setAckTime(UtcT utcT) {
        this.ackTime = utcT;
    }

    static String createDuplicateId(String string, String string2) {
        return string + string2;
    }

    static void setFilterPeriod(boolean bl) {
        filterPeriod = bl;
    }

    static {
        alarmList = new Hashtable();
        eventIdList = new Hashtable();
        activeAlarms = new Vector();
        filteredAlarms = new Vector();
        isSilentFmMode = false;
        filterPeriod = true;
        logHelper = new AlarmEventLogHelper(ALARM_LOG, 3000000, ALARM_LOG_PATH);
    }

    class AlarmableImpl
    implements Alarmable {
        private boolean processNewHasBeenCalled = false;
        private boolean processClearedHasBeenCalled = false;

        AlarmableImpl() {
        }

        public UtcT getAckTime() {
            return Alarm.this.getAckTime();
        }

        public short getAckState() {
            return Alarm.this.getAckState();
        }

        public String getAckUserId() {
            return Alarm.this.getAckUserId();
        }

        public AdditionalInfo[] getAdditionalInfoList() {
            return Alarm.this.getAdditionalInfoList();
        }

        public String getAdditionalText() {
            return Alarm.this.updateAdditionalText;
        }

        public String getAlarmId() {
            return Alarm.this.getAlarmId();
        }

        public CorrelatedNotification[] getCorrelatedNotifications() {
            return Alarm.this.getCorrelatedNotifications();
        }

        public UtcT getEventTime() {
            return Alarm.this.getEventTime();
        }

        public String getEventType() {
            return Alarm.this.getEventType();
        }

        public String getManagedObjectClass() {
            return Alarm.this.getManagedObjectClass();
        }

        public String getManagedObjectInstance() {
            return Alarm.this.getManagedObjectInstance();
        }

        public int getNotificationId() {
            return Alarm.this.getNotificationId();
        }

        public short getPerceivedSeverity() {
            return Alarm.this.tempPerceivedSeverity;
        }

        public short getProbableCause() {
            return Alarm.this.getProbableCause();
        }

        public String getSpecificProblem() {
            return Alarm.this.getSpecificProblem();
        }

        public String getSystemDN() {
            return Alarm.this.getSystemDN();
        }

        public synchronized Alarm processCleared() {
            if (this.processClearedHasBeenCalled) {
                return Alarm.this;
            }
            this.processClearedHasBeenCalled = true;
            return Alarm.this.processCleared();
        }

        public synchronized Alarm processNew() throws AlarmDuplicatedException {
            if (this.processNewHasBeenCalled) {
                return Alarm.this;
            }
            this.processNewHasBeenCalled = true;
            return Alarm.this.processNew();
        }

        public synchronized Alarm processChanged() {
            return Alarm.this.processChanged();
        }
    }
}

