/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.transaction.Coordinator;

public class IntegerAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = -4197439496890601005L;
    private transient int myBackup;
    private int myValue;
    private transient boolean myIsTransactionActive = false;

    public IntegerAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = 0;
    }

    public IntegerAttribute(String string, boolean bl, int n) {
        super(string, bl);
        this.myValue = n;
    }

    public IntegerAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        this.myValue = Integer.parseInt(string2.substring(2));
    }

    public synchronized int getValue(Coordinator coordinator) {
        if (coordinator == null) {
            if (this.myIsTransactionActive) {
                return this.myBackup;
            }
            return this.myValue;
        }
        return this.myValue;
    }

    public synchronized void setValue(int n) {
        this.myValue = n;
    }

    public synchronized void setValue(Integer n) {
        this.myValue = n;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator coordinator) {
        return new Integer(this.getValue(coordinator));
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return new Integer(this.myBackup);
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        String string = "";
        string = this.getNotificationType() != 0 ? "T" : "F";
        return "^i" + string + this.myValue;
    }
}

