/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.transaction.Coordinator;

public class LongAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = -671952936463016200L;
    private transient long myBackup;
    private long myValue;
    private transient boolean myIsTransactionActive = false;

    public LongAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = 0L;
    }

    public LongAttribute(String string, boolean bl, long l) {
        super(string, bl);
        this.myValue = l;
    }

    public LongAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        this.myValue = Long.parseLong(string2.substring(2));
    }

    public synchronized long getValue(Coordinator coordinator) {
        if (coordinator == null && this.myIsTransactionActive) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(long l) {
        this.myValue = l;
    }

    public synchronized void setValue(Long l) {
        this.myValue = l;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator coordinator) {
        return new Long(this.getValue(coordinator));
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return new Long(this.myBackup);
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        String string = "";
        string = this.getNotificationType() != 0 ? "T" : "F";
        return "^l" + string + this.myValue;
    }
}

