/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.csnotification.NotificationReporter;
import se.ericsson.cello.moframework.AVCNotificationSender;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.Notifier;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.internal.NotificationCollector;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class NotificationSender
implements Notifier {
    private static NotificationSender theOneAndOnly;
    private static Map notificationMapCollector;

    public static NotificationSender instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new NotificationSender();
        }
        return theOneAndOnly;
    }

    public static Notifier getNotifier() {
        return NotificationSender.instance();
    }

    public static AVCNotificationSender getAVCNotificationSender() {
        return NotificationSender.instance();
    }

    public void pushAVC(ManagedObject managedObject, String[] stringArray, Object[] objectArray) {
        if (managedObject != null) {
            MessageLog.trace((int)5, this.getClass(), (String)("Reporting " + stringArray.length + " changed attributes without any transaction for " + managedObject.getLocalDistinguishedName()));
            NotificationReporter.pushAVC(managedObject.getLocalDistinguishedName(), MibMgr.instance().getMib().getMibPrefix(), managedObject.getType(), managedObject.getId(), stringArray, objectArray, null);
        }
    }

    public synchronized void pushAVC(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        if (coordinator == null) {
            this.pushAVC(managedObject, stringArray, objectArray);
        } else {
            NotificationCollector notificationCollector = (NotificationCollector)notificationMapCollector.get(coordinator);
            if (notificationCollector == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("Creating new NotificationCollector for tx " + coordinator.getTransactionID()));
                notificationCollector = new NotificationCollector(coordinator, this);
                notificationMapCollector.put(coordinator, notificationCollector);
            } else {
                MessageLog.trace((int)5, this.getClass(), (String)("Found existing NotificationCollector for tx " + coordinator.getTransactionID()));
            }
            notificationCollector.collect(managedObject, stringArray, objectArray);
        }
    }

    public synchronized void pushSequenceDeltaNotification(ManagedObject managedObject, String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray, Coordinator coordinator) {
        if (coordinator == null) {
            this.pushSequenceDeltaNotification(managedObject, stringArray, sequenceDiffInfoArray);
        } else {
            NotificationCollector notificationCollector = (NotificationCollector)notificationMapCollector.get(coordinator);
            if (notificationCollector == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("Creating new AVCCollector for tx " + coordinator.getTransactionID()));
                notificationCollector = new NotificationCollector(coordinator, this);
                notificationMapCollector.put(coordinator, notificationCollector);
            } else {
                MessageLog.trace((int)5, this.getClass(), (String)("Found existing AVCCollector for tx " + coordinator.getTransactionID()));
            }
            notificationCollector.collect(managedObject, stringArray, sequenceDiffInfoArray);
        }
    }

    public void pushSequenceDeltaNotification(ManagedObject managedObject, String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray) {
        if (managedObject != null) {
            NotificationReporter.pushSequenceDeltaNotification(managedObject.getLocalDistinguishedName(), MibMgr.instance().getMib().getMibPrefix(), managedObject.getType(), managedObject.getId(), stringArray, sequenceDiffInfoArray, null);
        }
    }

    public boolean isTransactionCollected(Coordinator coordinator) {
        return notificationMapCollector.containsKey(coordinator);
    }

    public void deregisterCollector(Coordinator coordinator) {
        notificationMapCollector.remove(coordinator);
    }

    public void registerCollector(Coordinator coordinator) {
        if (!this.isTransactionCollected(coordinator)) {
            NotificationCollector notificationCollector = new NotificationCollector(coordinator, this);
            notificationMapCollector.put(coordinator, notificationCollector);
        }
    }

    private NotificationSender() {
    }

    static {
        notificationMapCollector = new HashMap();
    }
}

