/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.internal;

import java.util.Vector;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.internal.DbObjectTable;
import se.ericsson.cello.moframework.internal.MoppletNameStorage;
import se.ericsson.cello.moframework.internal.MoppletRunner;
import se.ericsson.cello.moframework.internal.RealDbObjectTable;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class MoppletManager
implements MoppletNameStorage {
    private int primaryKeyCounter = 0;
    private DbObjectTable table;
    private static final String MOPPLET_TABLE_NAME = "mopplet";
    private static final String CMA_BOOTSTRAPPER = "se.ericsson.cello.CmaBootStrapper";

    public MoppletManager(DbObjectTable dbObjectTable) {
        this.table = dbObjectTable;
    }

    public MoppletManager() throws DbAccessException {
        this(new RealDbObjectTable(MOPPLET_TABLE_NAME));
    }

    public MoppletNameStorage getStorage() {
        return this;
    }

    public void add(String string, Coordinator coordinator) throws DbAccessException {
        if (string != null) {
            this.table.createRow(this.generatePrimaryKey(), string, coordinator);
        }
    }

    public void clear(Coordinator coordinator) throws DbAccessException {
        int[] nArray = this.table.getPrimaryKeys();
        for (int i = 0; i < nArray.length; ++i) {
            this.table.deleteRow(nArray[i], coordinator);
        }
    }

    public synchronized String[] getMoppletNames() throws DbAccessException {
        int[] nArray = this.table.getPrimaryKeys();
        Vector<String> vector = new Vector<String>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.table.getRow(nArray[i]);
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public MoppletRunner getMoppletRunner() throws DbAccessException {
        String[] stringArray = this.getMoppletNames();
        MoppletRunner moppletRunner = new MoppletRunner();
        this.addMopplet(CMA_BOOTSTRAPPER, moppletRunner);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addMopplet(stringArray[i], moppletRunner);
        }
        return moppletRunner;
    }

    private void addMopplet(String string, MoppletRunner moppletRunner) {
        try {
            Mopplet mopplet = (Mopplet)Class.forName(string).newInstance();
            moppletRunner.add(mopplet);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Problem instantiating mopplet " + string), (Throwable)exception);
        }
    }

    private synchronized int generatePrimaryKey() throws DbAccessException {
        if (this.primaryKeyCounter == 0) {
            int[] nArray = this.table.getPrimaryKeys();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= this.primaryKeyCounter) continue;
                this.primaryKeyCounter = nArray[i];
            }
        }
        return ++this.primaryKeyCounter;
    }
}

