/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.CounterBasedScanner;
import se.ericsson.cello.pms.generic.FilterInfo;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidFilterException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.InvalidTriggeringObjectException;
import se.ericsson.cello.pms.generic.Measurement;
import se.ericsson.cello.pms.generic.MonitoringTaskAccess;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.ObservedClass;
import se.ericsson.cello.pms.generic.ObservedObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.Persistent;
import se.ericsson.cello.pms.generic.PmDataConsumer;
import se.ericsson.cello.pms.generic.PmStorage;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.pms.generic.ScannerInterrupterImpl;
import se.ericsson.cello.pms.generic.ScannerPersistence;
import se.ericsson.cello.pms.generic.ScannerRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

class MonitoringTask
implements MonitoringTaskAccess,
Measurement,
Persistent {
    private PmsContext pmsContext;
    private GranularityPeriod granularityPeriod;
    private GranularityPeriod reportingPeriod;
    private ScannerId scannerId;
    private Vector scanners = new Vector();
    private MonitoringTaskInfo taskInfo;
    private PmDataConsumer consumer;

    public ObservationClass[] getObservationClassList() {
        return this.taskInfo.getObservationClassList();
    }

    public ObservationObject[] getObservationObjectList() {
        return this.taskInfo.getObservationObjectList();
    }

    MonitoringTask(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, int n, int n2, String string, PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator, PmsContext pmsContext) throws InvalidGranularityPeriodException, OverloadException, GranularityPeriodNotSupportedException, GranularityAndAttributeActivationException, NumberOfCountersExceededException, ParameterNotAcceptedException, InactiveTransactionException {
        this.pmsContext = pmsContext;
        this.reportingPeriod = this.granularityPeriod = GranularityPeriod.convertFromSeconds(n);
        this.scannerId = new ScannerId();
        this.taskInfo = new MonitoringTaskInfo(this.scannerId, string, performanceMonitoringState, observationClassArray, observationObjectArray, this.granularityPeriod, this.reportingPeriod);
        coordinator.registerResource((Resource)new CreateTx(this));
        this.createScanners(observationClassArray, observationObjectArray, string, performanceMonitoringState, coordinator);
        ScannerPersistence.instance().insert(this.scannerId.intValue(), this, coordinator);
    }

    MonitoringTask(MonitoringTaskInfo monitoringTaskInfo, boolean bl, Coordinator coordinator, PmsContext pmsContext) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException, InactiveTransactionException {
        this.pmsContext = pmsContext;
        this.taskInfo = monitoringTaskInfo;
        this.scannerId = this.taskInfo.getId();
        this.granularityPeriod = this.taskInfo.getGranularityPeriod();
        this.reportingPeriod = this.taskInfo.getReportingPeriod();
        coordinator.registerResource((Resource)new CreateTx(this));
        this.createScanners(this.taskInfo.getObservationClassList(), this.taskInfo.getObservationObjectList(), this.taskInfo.getName(), this.taskInfo.getState(), coordinator);
        if (bl) {
            this.update(coordinator);
        }
    }

    private void update(Coordinator coordinator) throws OverloadException {
        ScannerPersistence.instance().update(this.getScannerId().intValue(), this, coordinator);
    }

    public void update() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                this.tryUpdate(3);
            }

            private void tryUpdate(int n) {
                try {
                    Control control = TransactionServiceImpl.instance().getTransactionFactory().create(10000);
                    MonitoringTask.this.update(control.getCoordinator());
                    control.getTerminator().commit();
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    MessageLog.traceError(this.getClass(), (String)"Transaction error when trying to update scanner record in database", (Throwable)transactionRolledBackException);
                }
                catch (OverloadException overloadException) {
                    if (--n <= 0) {
                        MessageLog.traceError(this.getClass(), (String)"Unable to update scanner record in database due to overload", (Throwable)overloadException);
                    }
                    MessageLog.info(this.getClass(), (String)("Overload when trying to update scanner record, making " + n + " more attempt" + (n == 1 ? "" : "s")));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.tryUpdate(n);
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"Unable to commit transaction when updating scanner record in database", (Throwable)inactiveTransactionException);
                }
            }
        });
        thread.start();
    }

    public void setState(PerformanceMonitoringState performanceMonitoringState) {
    }

    public void delete() throws InvalidPerformanceMonitoringTypeException {
    }

    public void setFilter(FilterInfo filterInfo) throws InvalidPerformanceMonitoringTypeException, InvalidObservationObjectListException, InvalidFilterException, InvalidTriggeringObjectException {
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public FilterInfo lookupFilter() throws InvalidPerformanceMonitoringTypeException {
        throw new InvalidPerformanceMonitoringTypeException();
    }

    public MonitoringTaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public ScannerId getScannerId() {
        return this.scannerId;
    }

    void delete(Coordinator coordinator) throws InactiveTransactionException {
        coordinator.registerResource((Resource)new DeleteTx(this));
        ScannerPersistence.instance().remove(this.scannerId.intValue(), coordinator);
        for (int i = 0; i < this.scanners.size(); ++i) {
            BasicScanner basicScanner = (BasicScanner)this.scanners.get(i);
            basicScanner.delete(coordinator);
        }
    }

    synchronized void setMonitoringState(PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException {
        if (performanceMonitoringState.value() == 0 && this.taskInfo.getState().value() == 1) {
            coordinator.registerResource((Resource)new ResumeTx(this));
            this.taskInfo.setState(PerformanceMonitoringState.ACTIVE);
            this.update(coordinator);
            for (int i = 0; i < this.scanners.size(); ++i) {
                ((BasicScanner)this.scanners.get(i)).setScannerState(performanceMonitoringState, coordinator);
            }
        } else if (performanceMonitoringState.value() == 1 && this.taskInfo.getState().value() == 0) {
            coordinator.registerResource((Resource)new SuspendTx(this));
            this.taskInfo.setState(PerformanceMonitoringState.SUSPENDED);
            this.update(coordinator);
            for (int i = 0; i < this.scanners.size(); ++i) {
                try {
                    ((BasicScanner)this.scanners.get(i)).setScannerState(PerformanceMonitoringState.SUSPENDED, coordinator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (performanceMonitoringState.value() == 1 && this.taskInfo.isSystemSuspended()) {
            this.taskInfo.setSystemSuspended(false);
            this.update(coordinator);
        } else {
            return;
        }
    }

    void systemSuspend(Coordinator coordinator) throws InactiveTransactionException, OverloadException, GranularityAndAttributeActivationException {
        if (this.taskInfo.getState() == PerformanceMonitoringState.ACTIVE) {
            this.taskInfo.setSystemSuspended(true);
            this.setMonitoringState(PerformanceMonitoringState.SUSPENDED, coordinator);
        }
    }

    void systemResume(Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException {
        if (this.taskInfo.isSystemSuspended()) {
            this.taskInfo.setSystemSuspended(false);
            this.setMonitoringState(PerformanceMonitoringState.ACTIVE, coordinator);
        }
    }

    private void createScanners(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, String string, PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException, InactiveTransactionException {
        this.consumer = PmDataConsumer.getInstance(this.granularityPeriod, PmStorage.storageHandler(this.granularityPeriod, this.pmsContext), ScannerInterrupterImpl.interrupter(this.granularityPeriod));
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.extractObservationClass(observationClassArray, hashtable, vector);
        Hashtable hashtable2 = new Hashtable();
        Vector vector2 = new Vector();
        this.extractObservationObject(observationObjectArray, hashtable2, vector2);
        if (vector2.size() != 0 || vector.size() != 0) {
            Object[] objectArray = new ObservedClass[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = new ObservedObject[vector2.size()];
            vector2.copyInto(objectArray2);
            CounterBasedScanner counterBasedScanner = new CounterBasedScanner((ObservedClass[])objectArray, (ObservedObject[])objectArray2, this.granularityPeriod, performanceMonitoringState, this.consumer.getCallbackObject(), string, coordinator, ScannerInterrupterImpl.interrupter(this.granularityPeriod), this);
            if (this.scanners == null) {
                this.scanners = new Vector();
            }
            this.scanners.addElement(counterBasedScanner);
        }
        this.createBasicScanner(hashtable, hashtable2, performanceMonitoringState, string, coordinator);
    }

    private void extractObservationClass(ObservationClass[] observationClassArray, Hashtable hashtable, Vector vector) {
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            String[] stringArray = observationClassArray[i].class_attribute_list;
            if (ObjectRepository.instance().containsMoType(string)) {
                BasicScannerFactory basicScannerFactory = ObjectRepository.instance().getFactory(string);
                this.addObservationClass(hashtable, basicScannerFactory, observationClassArray[i]);
                continue;
            }
            vector.addElement(new ObservedClass(observationClassArray[i]));
        }
    }

    private void extractObservationObject(ObservationObject[] observationObjectArray, Hashtable hashtable, Vector vector) {
        block0: for (int i = 0; i < observationObjectArray.length; ++i) {
            String[] stringArray = observationObjectArray[i].instance_attribute_list;
            for (int j = 0; j < observationObjectArray[i].instance_list.length; ++j) {
                String string = observationObjectArray[i].instance_list[j];
                String string2 = null;
                ManagedObject managedObject = MoRepository.instance().lookup(string);
                string2 = managedObject != null ? managedObject.getType() : this.extractMoType(string);
                if (string2 == null) continue;
                if (ObjectRepository.instance().containsMoType(string2)) {
                    BasicScannerFactory basicScannerFactory = ObjectRepository.instance().getFactory(string2);
                    this.addObservationObject(hashtable, basicScannerFactory, observationObjectArray[i]);
                    continue block0;
                }
                vector.addElement(new ObservedObject(observationObjectArray[i], string));
            }
        }
    }

    private String extractMoType(String string) {
        String string2 = null;
        int n = string.lastIndexOf(",");
        int n2 = string.lastIndexOf("=");
        if (n != -1 && n2 != -1) {
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    private void createBasicScanner(Hashtable hashtable, Hashtable hashtable2, PerformanceMonitoringState performanceMonitoringState, String string, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        Object object2;
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (BasicScannerFactory)enumeration.nextElement();
            if (hashtable2.containsKey(object2)) {
                vector = (Vector)hashtable2.get(object2);
                hashtable2.remove(object2);
            }
            objectArray2 = new ObservationObject[vector.size()];
            vector.copyInto(objectArray2);
            vector.clear();
            vector = (Vector)hashtable.get(object2);
            objectArray = new ObservationClass[vector.size()];
            vector.copyInto(objectArray);
            vector.clear();
            hashtable.remove(object2);
            object = object2.create((ObservationClass[])objectArray, (ObservationObject[])objectArray2, this.granularityPeriod, performanceMonitoringState, this.consumer.getCallbackObject(), string, coordinator);
            if (this.scanners == null) {
                this.scanners = new Vector();
            }
            this.scanners.addElement(object);
        }
        object2 = hashtable2.keys();
        while (object2.hasMoreElements()) {
            objectArray2 = (Object[])object2.nextElement();
            vector = (Vector)hashtable2.get(objectArray2);
            hashtable2.remove(objectArray2);
            objectArray = new ObservationObject[vector.size()];
            vector.copyInto(objectArray);
            vector.clear();
            object = new ObservationClass[vector.size()];
            vector.copyInto((Object[])object);
            BasicScanner basicScanner = objectArray2.create((ObservationClass[])object, (ObservationObject[])objectArray, this.granularityPeriod, performanceMonitoringState, this.consumer.getCallbackObject(), string, coordinator);
            if (this.scanners == null) {
                this.scanners = new Vector();
            }
            this.scanners.addElement(basicScanner);
        }
    }

    private void addObservationClass(Hashtable hashtable, BasicScannerFactory basicScannerFactory, ObservationClass observationClass) {
        Vector vector = new Vector();
        if (hashtable.containsKey(basicScannerFactory)) {
            vector = (Vector)hashtable.get(basicScannerFactory);
        }
        vector.addElement(observationClass);
        hashtable.put(basicScannerFactory, vector);
    }

    private void addObservationObject(Hashtable hashtable, BasicScannerFactory basicScannerFactory, ObservationObject observationObject) {
        Vector vector = new Vector();
        if (hashtable.containsKey(basicScannerFactory)) {
            vector = (Vector)hashtable.get(basicScannerFactory);
        }
        vector.addElement(observationObject);
        hashtable.put(basicScannerFactory, vector);
    }

    private class SuspendTx
    implements Resource {
        private MonitoringTask txTask;

        SuspendTx(MonitoringTask monitoringTask2) {
            this.txTask = monitoringTask2;
        }

        public void commit() {
            for (int i = 0; i < MonitoringTask.this.scanners.size(); ++i) {
                MonitoringTask.this.consumer.free((BasicScanner)MonitoringTask.this.scanners.get(i));
            }
            MonitoringTask.this.pmsContext.removeMeasurement(this.txTask);
            this.txTask = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            MonitoringTask.this.taskInfo.setState(PerformanceMonitoringState.ACTIVE);
            this.txTask = null;
        }
    }

    private class ResumeTx
    implements Resource {
        private MonitoringTask txTask;

        ResumeTx(MonitoringTask monitoringTask2) {
            this.txTask = monitoringTask2;
        }

        public void commit() {
            for (int i = 0; i < MonitoringTask.this.scanners.size(); ++i) {
                MonitoringTask.this.consumer.reserve((BasicScanner)MonitoringTask.this.scanners.get(i));
            }
            MonitoringTask.this.pmsContext.addMeasurement(this.txTask);
            this.txTask = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            MonitoringTask.this.taskInfo.setState(PerformanceMonitoringState.SUSPENDED);
            this.txTask = null;
        }
    }

    private class DeleteTx
    implements Resource {
        private MonitoringTask txTask;

        DeleteTx(MonitoringTask monitoringTask2) {
            this.txTask = monitoringTask2;
        }

        public void commit() {
            if (MonitoringTask.this.taskInfo.getState().value() == 0) {
                for (int i = 0; i < MonitoringTask.this.scanners.size(); ++i) {
                    MonitoringTask.this.consumer.free((BasicScanner)MonitoringTask.this.scanners.get(i));
                }
            }
            MonitoringTask.this.pmsContext.removeMeasurement(this.txTask);
            ScannerRepository.instance().deregister(MonitoringTask.this.scannerId);
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }

    private class CreateTx
    implements Resource {
        private MonitoringTask txTask;

        CreateTx(MonitoringTask monitoringTask2) {
            this.txTask = monitoringTask2;
        }

        public void commit() {
            if (MonitoringTask.this.taskInfo.getState().value() == 0) {
                for (int i = 0; i < MonitoringTask.this.scanners.size(); ++i) {
                    MonitoringTask.this.consumer.reserve((BasicScanner)MonitoringTask.this.scanners.get(i));
                }
                MonitoringTask.this.pmsContext.addMeasurement(this.txTask);
            }
            ScannerRepository.instance().register(this.txTask, MonitoringTask.this.scannerId);
            this.txTask = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }
}

