/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.pms.generic.PmAttributeSettingListener;
import se.ericsson.cello.support.debug.MessageLog;

public class PmAttributeSettingListenerMgr {
    private static PmAttributeSettingListenerMgr instance;
    private List myListeners = new ArrayList();
    private static final int TRACEGROUP = 8;

    private PmAttributeSettingListenerMgr() {
    }

    public static PmAttributeSettingListenerMgr getInstance() {
        if (instance == null) {
            instance = new PmAttributeSettingListenerMgr();
        }
        return instance;
    }

    public void setPerformanceDataPath(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setPerformanceDataPath(): " + string));
        Iterator iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            PmAttributeSettingListener pmAttributeSettingListener = (PmAttributeSettingListener)iterator.next();
            pmAttributeSettingListener.performanceDataPathChanged(string);
        }
    }

    public void setMaxNoOfPmFiles(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMaxNoOfPmFiles(): " + n));
        Iterator iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            PmAttributeSettingListener pmAttributeSettingListener = (PmAttributeSettingListener)iterator.next();
            pmAttributeSettingListener.maxNoOfPmFilesChanged(n);
        }
    }

    public void deregisterListener(PmAttributeSettingListener pmAttributeSettingListener) {
        this.myListeners.remove(pmAttributeSettingListener);
    }

    public void registerListener(PmAttributeSettingListener pmAttributeSettingListener) {
        if (!this.myListeners.contains(pmAttributeSettingListener)) {
            this.myListeners.add(pmAttributeSettingListener);
        }
    }
}

