/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import se.ericsson.cello.pms.generic.ActiveCounterCalculator;
import se.ericsson.cello.pms.generic.CounterCalculator;
import se.ericsson.cello.pms.generic.LoadControl;
import se.ericsson.cello.pms.generic.Measurement;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.PmAttributeSettingImpl;
import se.ericsson.cello.pms.generic.PmLoadControlImpl;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.ne.PmAttributeSetting;

class PmsContextImpl
implements PmsContext {
    private ActiveCounterCalculator activeCounterCalculator = new ActiveCounterCalculator(this);
    private PmLoadControlImpl pmLoadControlImpl = new PmLoadControlImpl(this);
    private PmAttributeSetting pmAttributeSetting = new PmAttributeSettingImpl(this);
    private boolean isSystemSuspended;

    PmsContextImpl() {
        new PmsPortalImpl(this.pmLoadControlImpl);
        LoadControl.instance().setPmLoadControlImpl(this.pmLoadControlImpl);
    }

    public void addMeasurement(Measurement measurement) {
        this.pmLoadControlImpl.addObservations(measurement.getObservationClassList(), measurement.getObservationObjectList());
        this.activeCounterCalculator.addMeasurement(measurement);
    }

    public void removeMeasurement(Measurement measurement) {
        this.pmLoadControlImpl.removeObservations(measurement.getObservationClassList(), measurement.getObservationObjectList());
        this.activeCounterCalculator.removeMeasurement(measurement);
    }

    public int getMaxNoOfMonitors() {
        return this.pmAttributeSetting.getMaxNoOfMonitors();
    }

    public void registerCounterCalculator(String[] stringArray, CounterCalculator counterCalculator) {
        this.activeCounterCalculator.registerCounterCalculator(stringArray, counterCalculator);
    }

    public void deregisterCounterCalculator(CounterCalculator counterCalculator) {
        this.activeCounterCalculator.deregisterCounterCalculator(counterCalculator);
    }

    public boolean acceptCounterActivation(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        return this.activeCounterCalculator.acceptActivation(observationClassArray, observationObjectArray);
    }

    public boolean isMaxNoOfCountersExceeded() {
        return this.activeCounterCalculator.isMaxLimitExceeded();
    }

    public int getNoOfActiveCounters() {
        return this.activeCounterCalculator.getNoOfActiveCounters();
    }

    public int getNoOfCountersForObservations(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        return this.activeCounterCalculator.getNoOfCountersForObservations(observationClassArray, observationObjectArray);
    }

    public int getMaxNoOfCounters() {
        return this.pmAttributeSetting.getMaxNoOfCounters();
    }

    public boolean isMaxNoOfCountersChanged() {
        return this.pmAttributeSetting.isMaxNoOfCtrValueCahnged();
    }

    public void setMaxNoOfCountersChanged(boolean bl) {
        this.pmAttributeSetting.setMaxNoOfCountersChanged(bl);
    }

    public void setAlarmThresholdChanged(boolean bl) {
        this.pmAttributeSetting.setAlarmThresholdChanged(bl);
    }

    public boolean isAlarmThresholdChanged() {
        return this.pmAttributeSetting.isAlarmThresholdChanged();
    }

    public void setAlarmCeasingLevelChanged(boolean bl) {
        this.pmAttributeSetting.setAlarmCeasingLevelChanged(bl);
    }

    public boolean isAlarmCeasingLevelChanged() {
        return this.pmAttributeSetting.isAlarmCeasingLevelChanged();
    }

    public int getWarningAlarmThreshold() {
        return this.pmAttributeSetting.getWarningAlarmThreshold();
    }

    public int getWarningAlarmCeasingLevel() {
        return this.pmAttributeSetting.getWarningAlarmCeasingLevel();
    }

    public int getMinorAlarmCeasingLevel() {
        return this.pmAttributeSetting.getMinorAlarmCeasingLevel();
    }

    public void reloadMonitors(String string) {
        MonitoringTaskMgr.instance().reloadTasks(string);
    }

    public String getPerformanceDataPath() {
        return this.pmAttributeSetting.getPerformanceDataPath();
    }

    public int getMaxNoOfPmFiles() {
        return this.pmAttributeSetting.getMaxNoOfPmFiles();
    }

    public void createMinorAlarm() {
        this.pmLoadControlImpl.createMinorAlarm();
    }

    public void checkLoad() {
        this.pmLoadControlImpl.checkLoad();
    }

    public void setSystemSuspended(boolean bl) {
        this.isSystemSuspended = bl;
    }

    public boolean isSystemSuspended() {
        return this.isSystemSuspended;
    }
}

