/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Iterator;
import se.ericsson.cello.pms.ne.PmAttributeSetting;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

class TransactionHelper {
    private static final int MAX_NO_OF_RETRIES = 10;
    private static final int RETRY_INTERVAL = 2000;
    private static final int TX_TIMEOUT = 60;
    private static final String PM_ATTRIBUTE_SETTING = "se.ericsson.cello.pms.ne.PmAttributeSetting";

    TransactionHelper() {
    }

    static Control create() {
        int n = 0;
        boolean bl = true;
        while (bl) {
            try {
                int n2 = TransactionHelper.getTimeout();
                Control control = TransactionServiceImpl.instance().getTransactionFactory().create(n2);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, (Class)TransactionHelper.class, (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = " + n2));
                return control;
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                if (n < 10) {
                    if (n == 0) {
                        MessageLog.info((Class)(class$se$ericsson$cello$pms$generic$TransactionHelper == null ? TransactionHelper.class$("se.ericsson.cello.pms.generic.TransactionHelper") : class$se$ericsson$cello$pms$generic$TransactionHelper), (String)("Create transaction not possible due to " + (Object)((Object)transactionRolledBackException) + ", retrying."));
                    }
                    ++n;
                    TransactionHelper.sleep();
                    continue;
                }
                MessageLog.traceError((Class)(class$se$ericsson$cello$pms$generic$TransactionHelper == null ? TransactionHelper.class$("se.ericsson.cello.pms.generic.TransactionHelper") : class$se$ericsson$cello$pms$generic$TransactionHelper), (String)"Create transaction failed after retrying.");
                bl = false;
            }
        }
        throw new RuntimeException("Failed to create a transaction.");
    }

    static void commit(Control control) {
        try {
            if (control != null) {
                control.getTerminator().commit();
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError((Class)TransactionHelper.class, (String)"commit failed - rollback", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError((Class)TransactionHelper.class, (String)"commit failed - inactive", (Throwable)inactiveTransactionException);
        }
    }

    static void rollback(Control control) {
        try {
            if (control != null) {
                Status status = control.getCoordinator().getStatus();
                if (status == Status.NO_TRANSACTION) {
                    MessageLog.trace((int)5, (Class)TransactionHelper.class, (String)("Transaction " + control.getCoordinator().getTransactionID() + " has already been rolled back"));
                    return;
                }
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info((Class)TransactionHelper.class, (String)"rollback failed - inactive");
        }
    }

    static void registerResource(Coordinator coordinator, Resource resource) {
        try {
            coordinator.registerResource(resource);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError((Class)TransactionHelper.class, (String)"register resource failed - inactive", (Throwable)inactiveTransactionException);
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            MessageLog.info((Class)TransactionHelper.class, (String)"Thread interrupted.");
        }
    }

    private static int getTimeout() {
        Iterator iterator;
        try {
            iterator = ServiceLocatorFacade.getRepository().getServices(Class.forName(PM_ATTRIBUTE_SETTING));
        }
        catch (Exception exception) {
            return 60;
        }
        if (iterator.hasNext()) {
            return ((PmAttributeSetting)iterator.next()).getTransactionTimeout();
        }
        return 60;
    }
}

