/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import java.util.Vector;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.productinventory.CustomerProductInfoData;
import se.ericsson.cello.productinventory.FirmwareProductData;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.LicenseProductData;
import se.ericsson.cello.productinventory.NodeProductData;
import se.ericsson.cello.productinventory.SoftwareProductData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class ProductRepository {
    private static ProductRepository uniqueInstance = new ProductRepository();
    private Vector nodeList = new Vector();
    private Vector cpiList = new Vector();
    private Vector fwList = new Vector();
    private Vector swList = new Vector();
    private Vector hwList = new Vector();
    private Vector upList = new Vector();
    private Vector licenseList = new Vector();

    public static ProductRepository instance() {
        return uniqueInstance;
    }

    public synchronized void registerNode(NodeProductData nodeProductData) {
        if (!this.nodeList.contains(nodeProductData)) {
            this.nodeList.addElement(nodeProductData);
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerNode: Product with name " + nodeProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerNode: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerNode(NodeProductData nodeProductData, Coordinator coordinator) {
        if (!this.nodeList.contains(nodeProductData)) {
            if (coordinator != null) {
                new TxResource(nodeProductData, true, coordinator);
            } else {
                this.nodeList.addElement(nodeProductData);
            }
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerNode: Product with name " + nodeProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerNode: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerCpi(CustomerProductInfoData customerProductInfoData) {
        if (!this.cpiList.contains(customerProductInfoData)) {
            this.cpiList.addElement(customerProductInfoData);
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerCpi: Product with name " + customerProductInfoData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerCpi: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerCpi(CustomerProductInfoData customerProductInfoData, Coordinator coordinator) {
        if (!this.cpiList.contains(customerProductInfoData)) {
            if (coordinator != null) {
                new TxResource(customerProductInfoData, true, coordinator);
            } else {
                this.cpiList.addElement(customerProductInfoData);
            }
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerCpi: Product with name " + customerProductInfoData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerCpi: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void deregisterCpi(CustomerProductInfoData customerProductInfoData) {
        this.cpiList.removeElement(customerProductInfoData);
    }

    public synchronized void deregisterCpi(CustomerProductInfoData customerProductInfoData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(customerProductInfoData, false, coordinator);
        } else {
            this.cpiList.removeElement(customerProductInfoData);
        }
    }

    public synchronized void registerFw(FirmwareProductData firmwareProductData) {
        if (!this.fwList.contains(firmwareProductData)) {
            this.fwList.addElement(firmwareProductData);
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerFw: Product with name " + firmwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerFw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerFw(FirmwareProductData firmwareProductData, Coordinator coordinator) {
        if (!this.fwList.contains(firmwareProductData)) {
            if (coordinator != null) {
                new TxResource(firmwareProductData, true, coordinator);
            } else {
                this.fwList.addElement(firmwareProductData);
            }
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerFw: Product with name " + firmwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerFw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void deregisterFw(FirmwareProductData firmwareProductData) {
        this.fwList.removeElement(firmwareProductData);
    }

    public synchronized void deregisterFw(FirmwareProductData firmwareProductData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(firmwareProductData, false, coordinator);
        } else {
            this.fwList.removeElement(firmwareProductData);
        }
    }

    public synchronized void registerSw(SoftwareProductData softwareProductData) {
        if (!this.swList.contains(softwareProductData)) {
            this.swList.addElement(softwareProductData);
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerSw: Product with name " + softwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerSw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerSw(SoftwareProductData softwareProductData, Coordinator coordinator) {
        if (!this.swList.contains(softwareProductData)) {
            if (coordinator != null) {
                new TxResource(softwareProductData, true, coordinator);
            } else {
                this.swList.addElement(softwareProductData);
            }
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerSw: Product with name " + softwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerSw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void deregisterSw(SoftwareProductData softwareProductData) {
        this.swList.removeElement(softwareProductData);
    }

    public synchronized void deregisterSw(SoftwareProductData softwareProductData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(softwareProductData, false, coordinator);
        } else {
            this.swList.removeElement(softwareProductData);
        }
    }

    public synchronized void registerHw(HardwareProductData hardwareProductData) {
        if (!this.hwList.contains(hardwareProductData)) {
            this.hwList.addElement(hardwareProductData);
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerHw: Product with name " + hardwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerHw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void registerHw(HardwareProductData hardwareProductData, Coordinator coordinator) {
        if (!this.hwList.contains(hardwareProductData)) {
            if (coordinator != null) {
                new TxResource(hardwareProductData, true, coordinator);
            } else {
                this.hwList.addElement(hardwareProductData);
            }
        } else {
            try {
                MessageLog.traceError((Class)ProductRepository.class, (String)("registerHw: Product with name " + hardwareProductData.getProductName(null) + " already registered"));
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError((Class)ProductRepository.class, (String)"registerHw: ", (Throwable)moAccessException);
            }
        }
    }

    public synchronized void deregisterHw(HardwareProductData hardwareProductData) {
        this.hwList.removeElement(hardwareProductData);
    }

    public synchronized void deregisterHw(HardwareProductData hardwareProductData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(hardwareProductData, false, coordinator);
        } else {
            this.hwList.removeElement(hardwareProductData);
        }
    }

    public synchronized void registerUp(UpgradePackageProductData upgradePackageProductData) {
        if (!this.upList.contains(upgradePackageProductData)) {
            this.upList.addElement(upgradePackageProductData);
        } else {
            MessageLog.traceError((Class)ProductRepository.class, (String)"registerUp: Product already registered");
        }
    }

    public synchronized void registerUp(UpgradePackageProductData upgradePackageProductData, Coordinator coordinator) {
        if (!this.upList.contains(upgradePackageProductData)) {
            if (coordinator != null) {
                new TxResource(upgradePackageProductData, true, coordinator);
            } else {
                this.upList.addElement(upgradePackageProductData);
            }
        } else {
            MessageLog.traceError((Class)ProductRepository.class, (String)"registerUp: Product with name already registered");
        }
    }

    public synchronized void deregisterUp(UpgradePackageProductData upgradePackageProductData) {
        this.upList.removeElement(upgradePackageProductData);
    }

    public synchronized void deregisterUp(UpgradePackageProductData upgradePackageProductData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(upgradePackageProductData, false, coordinator);
        } else {
            this.upList.removeElement(upgradePackageProductData);
        }
    }

    public synchronized void registerLicense(LicenseProductData licenseProductData) {
        if (!this.licenseList.contains(licenseProductData)) {
            this.licenseList.addElement(licenseProductData);
        } else {
            MessageLog.traceError((Class)ProductRepository.class, (String)"registerLicense: Product already registered");
        }
    }

    public synchronized void registerLicense(LicenseProductData licenseProductData, Coordinator coordinator) {
        if (!this.licenseList.contains(licenseProductData)) {
            if (coordinator != null) {
                new TxResource(licenseProductData, true, coordinator);
            } else {
                this.licenseList.addElement(licenseProductData);
            }
        } else {
            MessageLog.traceError((Class)ProductRepository.class, (String)"registerLicense: Product with name already registered");
        }
    }

    public synchronized void deregisterLicense(LicenseProductData licenseProductData) {
        this.licenseList.removeElement(licenseProductData);
    }

    public synchronized void deregisterLicense(LicenseProductData licenseProductData, Coordinator coordinator) {
        if (coordinator != null) {
            new TxResource(licenseProductData, false, coordinator);
        } else {
            this.licenseList.removeElement(licenseProductData);
        }
    }

    synchronized Vector getAllRegisteredNode() {
        return this.nodeList;
    }

    synchronized Vector getAllRegisteredCpi() {
        return this.cpiList;
    }

    synchronized Vector getAllRegisteredFw() {
        return this.fwList;
    }

    synchronized Vector getAllRegisteredSw() {
        return this.swList;
    }

    synchronized Vector getAllRegisteredHw() {
        return this.hwList;
    }

    synchronized Vector getAllRegisteredUp() {
        return this.upList;
    }

    synchronized Vector getAllRegisteredLicense() {
        return this.licenseList;
    }

    private ProductRepository() {
    }

    private static class TxResource
    implements Resource {
        private Object pidObject;
        private boolean toBeRegistered = true;

        TxResource(Object object, boolean bl, Coordinator coordinator) {
            this.pidObject = object;
            this.toBeRegistered = bl;
            try {
                coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$ProductRepository == null ? (class$se$ericsson$cello$productinventory$ProductRepository = ProductRepository.class$("se.ericsson.cello.productinventory.ProductRepository")) : class$se$ericsson$cello$productinventory$ProductRepository), (String)"TxResource - Constructor", (Throwable)inactiveTransactionException);
            }
        }

        public void commit() {
            if (this.pidObject instanceof NodeProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerNode((NodeProductData)this.pidObject);
                } else {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$ProductRepository == null ? (class$se$ericsson$cello$productinventory$ProductRepository = ProductRepository.class$("se.ericsson.cello.productinventory.ProductRepository")) : class$se$ericsson$cello$productinventory$ProductRepository), (String)"TxResourse.commit: Tried to deregister node");
                }
            } else if (this.pidObject instanceof CustomerProductInfoData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerCpi((CustomerProductInfoData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterCpi((CustomerProductInfoData)this.pidObject);
                }
            } else if (this.pidObject instanceof FirmwareProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerFw((FirmwareProductData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterFw((FirmwareProductData)this.pidObject);
                }
            } else if (this.pidObject instanceof SoftwareProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerSw((SoftwareProductData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterSw((SoftwareProductData)this.pidObject);
                }
            } else if (this.pidObject instanceof HardwareProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerHw((HardwareProductData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterHw((HardwareProductData)this.pidObject);
                }
            } else if (this.pidObject instanceof UpgradePackageProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerUp((UpgradePackageProductData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterUp((UpgradePackageProductData)this.pidObject);
                }
            } else if (this.pidObject instanceof LicenseProductData) {
                if (this.toBeRegistered) {
                    ProductRepository.instance().registerLicense((LicenseProductData)this.pidObject);
                } else {
                    ProductRepository.instance().deregisterLicense((LicenseProductData)this.pidObject);
                }
            } else {
                MessageLog.traceError((Class)(class$se$ericsson$cello$productinventory$ProductRepository == null ? (class$se$ericsson$cello$productinventory$ProductRepository = ProductRepository.class$("se.ericsson.cello.productinventory.ProductRepository")) : class$se$ericsson$cello$productinventory$ProductRepository), (String)"TxResource.commit: Not a valid PID object");
            }
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }
}

