/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.recovery;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.mopersistence.MoCompressedLDNStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.recovery.MoTypeLookup;
import se.ericsson.cello.recovery.ModataR2ToR3Converter;
import se.ericsson.cello.recovery.ProgressIndicator;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class MoRecoveryHandler {
    private static final int RETRIEVE_CHUNK_SIZE = 100;
    private static MoRecoveryHandler theOneAndOnly = new MoRecoveryHandler();

    public static MoRecoveryHandler instance() {
        return theOneAndOnly;
    }

    public boolean recoverMos(Vector vector) {
        MoData moData = null;
        MoFactory moFactory = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            moData = (MoData)enumeration.nextElement();
            moFactory = MoFactoryMgr.instance().lookup(moData.getMoTypeName());
            if (moFactory != null) {
                try {
                    moFactory.recoverMo(moData);
                }
                catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$recovery$MoRecoveryHandler == null ? MoRecoveryHandler.class$("se.ericsson.cello.recovery.MoRecoveryHandler") : class$se$ericsson$cello$recovery$MoRecoveryHandler), (String)("Mo allready registerred! " + moData + moNameAlreadyTakenException.toString()), (Throwable)moNameAlreadyTakenException);
                }
            } else {
                MessageLog.traceError((Class)(class$se$ericsson$cello$recovery$MoRecoveryHandler == null ? MoRecoveryHandler.class$("se.ericsson.cello.recovery.MoRecoveryHandler") : class$se$ericsson$cello$recovery$MoRecoveryHandler), (String)("Mo factory not found!" + moData.getMoTypeName()), null);
            }
            ProgressIndicator.instance().incRecoveredMOs();
        }
        MoTypeLookup.instance().clean();
        AttributeLookupFactory.instance().clean();
        return MoRepository.instance().resolveAllNodes();
    }

    public Vector retrieveAllMoData() {
        MoCompressedLDNStorage moCompressedLDNStorage = null;
        int[] nArray = null;
        int n = 0;
        String[] stringArray = null;
        MoData moData = null;
        Vector<MoData> vector = null;
        try {
            this.convertToR3DbFormat();
            MoTypeLookup.instance();
            moCompressedLDNStorage = MoCompressedLDNStorage.instance();
            moCompressedLDNStorage.connectToDatabase();
            nArray = moCompressedLDNStorage.retrieveAllPrimaryKeys();
            Assert.cppAssert((Object)nArray, (String)"MorecoveryHandler.retrieveAllMoData primaryKeys");
            ProgressIndicator.instance().setTotalMOs(nArray.length);
            vector = new Vector<MoData>(nArray.length);
            for (int i = 0; i < nArray.length; i += 100) {
                n = i + 100 > nArray.length ? nArray.length - 1 : i + 100 - 1;
                stringArray = moCompressedLDNStorage.retrieveRows(nArray[i], nArray[n]);
                for (int j = 0; j < stringArray.length; ++j) {
                    moData = new MoData(stringArray[j]);
                    vector.addElement(moData);
                    ProgressIndicator.instance().incRetrievedMOs();
                }
            }
            moCompressedLDNStorage.disconnectFromDatabase();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.cppAssert((boolean)false, (String)("MoRecoveryHandler retrieveAllMoData() exception :" + illegalArgumentException));
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoRecoveryHandler retrieveAllMoData() exception :" + (Object)((Object)dbAccessException)));
        }
        return vector;
    }

    private void convertToR3DbFormat() {
        boolean bl = false;
        try {
            bl = DbStringWrapper.tableExists((String)"modata_r2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            MessageLog.info(this.getClass(), (String)"Starting conversion of modata_r2 -> modata_r3");
            String[] stringArray = this.retrieveModataR2data();
            try {
                DbStringWrapper dbStringWrapper = new DbStringWrapper("modata_r2");
                Control control = MoRecoveryHandler.startTransaction();
                dbStringWrapper.deleteTable(control.getCoordinator().getTransactionID());
                control.getTerminator().commit();
                MessageLog.info(this.getClass(), (String)("Number of mo:s to convert: " + stringArray.length));
                if (stringArray != null) {
                    ModataR2ToR3Converter modataR2ToR3Converter = new ModataR2ToR3Converter(stringArray);
                    MessageLog.info(this.getClass(), (String)"Preparing attribute table");
                    modataR2ToR3Converter.prepare();
                    MessageLog.info(this.getClass(), (String)"Starting conversion");
                    modataR2ToR3Converter.convert();
                    MessageLog.info(this.getClass(), (String)"Store data in new tables");
                    modataR2ToR3Converter.store();
                }
                MessageLog.info(this.getClass(), (String)"Conversion finished");
            }
            catch (DbAccessException dbAccessException) {
                Assert.cppAssert((boolean)false, (String)(MoRecoveryHandler.class.getName() + ": " + (Object)((Object)dbAccessException)));
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Assert.cppAssert((boolean)false, (String)(MoRecoveryHandler.class.getName() + ": " + (Object)((Object)transactionRolledBackException)));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Assert.cppAssert((boolean)false, (String)(MoRecoveryHandler.class.getName() + ": " + (Object)((Object)inactiveTransactionException)));
            }
        }
    }

    private String[] retrieveModataR2data() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        try {
            DbStringWrapper dbStringWrapper = new DbStringWrapper("modata_r2");
            dbStringWrapper.connectToDatabase();
            int[] nArray = dbStringWrapper.retrieveAllPrimaryKeys();
            for (int i = 0; i < nArray.length; i += 100) {
                n = i + 100 > nArray.length ? nArray.length - 1 : i + 100 - 1;
                String[] stringArray = dbStringWrapper.retrieveRows(nArray[i], nArray[n]);
                for (int j = 0; j < stringArray.length; ++j) {
                    arrayList.add(stringArray[j]);
                }
            }
            dbStringWrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoRecoveryHandler retrieveAllMoData() exception :" + (Object)((Object)dbAccessException)));
        }
        return arrayList.toArray(new String[0]);
    }

    static Control startTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        int n = 600;
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(n);
        Coordinator coordinator = control.getCoordinator();
        MessageLog.trace((int)5, (Class)MoRecoveryHandler.class, (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = " + n));
        return control;
    }
}

