/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import se.ericsson.cello.support.corba.CipherHelper;
import se.ericsson.cello.support.corba.IORUpdater;
import se.ericsson.cello.support.corba.IpAddressHelper;
import se.ericsson.cello.support.corba.NameServer;
import se.ericsson.cello.support.corba.RequestItem;
import se.ericsson.cello.support.corba.RequestItemHandler;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.security.corba.Current;
import se.ericsson.security.corba.ORBInit;

public class CelloOrb {
    private ORB orb;
    private POA poa;
    private POA rootPoa;
    private boolean securityActivated = false;
    private Current current = null;
    private static CelloOrb instance = new CelloOrb();
    private IpAddressHelper ipAddressHelper = IpAddressHelper.instance();
    private String ipv6Address;
    public static final int SERVICES_PORT = 56834;
    private static final String HOST_PATH = "/host/security";
    private static final String TARGET_PATH = "/c/security";
    private static final String SECURITY_MODE_FILE = "/corbasecurity";
    private static final String SECURITY_ON_MSG = "CorbaSecurity=ON";
    private static final String SECURITY_OFF_MSG = "CorbaSecurity=OFF";
    private static final String ORB_PROP_FILE = "/orb.prp";

    public static synchronized CelloOrb instance() {
        return instance;
    }

    public void connect(Servant servant) {
        try {
            this.rootPoa.activate_object(servant);
        }
        catch (WrongPolicy wrongPolicy) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)wrongPolicy);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)servantAlreadyActive);
        }
    }

    public void connect(String string, Servant servant) {
        try {
            this.poa.activate_object_with_id(string.getBytes(), servant);
        }
        catch (WrongPolicy wrongPolicy) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)wrongPolicy);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)objectAlreadyActive);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)servantAlreadyActive);
        }
    }

    public void disconnect(Servant servant) {
        try {
            byte[] byArray = null;
            try {
                byArray = this.poa.servant_to_id(servant);
                this.poa.deactivate_object(byArray);
            }
            catch (ServantNotActive servantNotActive) {
                byArray = this.rootPoa.servant_to_id(servant);
                this.rootPoa.deactivate_object(byArray);
            }
        }
        catch (ObjectNotActive objectNotActive) {
            MessageLog.info(this.getClass(), (String)("disconnect: " + objectNotActive.getMessage()));
        }
        catch (SystemException systemException) {
            MessageLog.info(this.getClass(), (String)("disconnect: " + systemException.getMessage()));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"disconnect", (Throwable)exception);
        }
    }

    public void disconnect(Object object) {
        try {
            byte[] byArray = null;
            try {
                byArray = this.poa.reference_to_id(object);
                this.poa.deactivate_object(byArray);
            }
            catch (WrongAdapter wrongAdapter) {
                byArray = this.rootPoa.reference_to_id(object);
                this.rootPoa.deactivate_object(byArray);
            }
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"disconnect", (Throwable)exception);
        }
    }

    public synchronized POA getRootPOA() {
        return this.rootPoa;
    }

    public synchronized POA getPOA() {
        return this.poa;
    }

    public Object servant_to_reference(Servant servant) {
        Object object = null;
        try {
            try {
                object = this.poa.servant_to_reference(servant);
            }
            catch (ServantNotActive servantNotActive) {
                object = this.rootPoa.servant_to_reference(servant);
            }
        }
        catch (WrongPolicy wrongPolicy) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)wrongPolicy);
        }
        catch (ServantNotActive servantNotActive) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)servantNotActive);
        }
        return object;
    }

    public Object addressDependentServantToReference(Servant servant) {
        Object object = this.servant_to_reference(servant);
        RequestItem requestItem = RequestItemHandler.instance().lookupItem(Thread.currentThread().getName());
        if (requestItem != null && IpAddressHelper.isIPv6(requestItem.getAddress()) && this.ipAddressHelper.getIpv6Address() != null) {
            String string = IORUpdater.updateIor(this.orb.object_to_string(object), (org.jacorb.orb.ORB)this.orb, this.ipAddressHelper.getIpv6Address(), 0);
            object = this.orb.string_to_object(string);
        }
        return object;
    }

    public Servant reference_to_servant(Object object) {
        Servant servant = null;
        try {
            try {
                servant = this.poa.reference_to_servant(object);
            }
            catch (ObjectNotActive objectNotActive) {
                servant = this.rootPoa.reference_to_servant(object);
            }
            catch (WrongAdapter wrongAdapter) {
                servant = this.rootPoa.reference_to_servant(object);
            }
        }
        catch (ObjectNotActive objectNotActive) {
            MessageLog.info(this.getClass(), (String)("-- " + objectNotActive.toString()));
        }
        catch (WrongAdapter wrongAdapter) {
            MessageLog.info(this.getClass(), (String)("-- " + wrongAdapter.toString()));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"--", (Throwable)exception);
        }
        return servant;
    }

    public synchronized Object string_to_object(String string) {
        return this.orb.string_to_object(string);
    }

    public synchronized String object_to_string(Object object) {
        return this.orb.object_to_string(object);
    }

    public synchronized Any create_any() {
        return this.orb.create_any();
    }

    public synchronized NamingContext getRootNamingContext() {
        return NameServer.instance().getRootNamingContext(this.orb);
    }

    public synchronized void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        NameServer.instance().rebind(nameComponentArray, object, this.orb);
    }

    public synchronized ORB getOrb() {
        return this.orb;
    }

    public void stopNameServer() {
        NameServer.instance().stop();
    }

    public synchronized void startNameServer() {
        NameServer.instance().start(this.orb);
    }

    public synchronized void start() {
        Policy[] policyArray;
        File file = new File(this.pathPrefix() + ORB_PROP_FILE);
        if (file.exists()) {
            System.setProperty("se.ericsson.security.PropertyFileLocation", this.pathPrefix() + ORB_PROP_FILE);
        }
        System.setProperty("se.ericsson.security.nodeCredentials", this.pathPrefix() + "/nodecredentials.p12");
        System.setProperty("se.ericsson.security.hostCredentials", this.pathPrefix() + "/host.p12");
        System.setProperty("se.ericsson.security.authorizationinterceptor", "true");
        System.setProperty("se.ericsson.security.corba.networklistener", "true");
        System.setProperty("se.ericsson.security.corba.is_server", "true");
        ORBInit.setCorbaSecurityState(null);
        Properties properties = ORBInit.getOrbProperties();
        properties.setProperty("jacorb.use_imr", "off");
        properties.setProperty("jacorb.implname", "StandardImplName");
        properties.setProperty("jacorb.orb.objectKeyMap.NameService", "NameServiceME/NameServer-POA/_root");
        int n = 56834;
        if (System.getProperty("SIM", "false").equalsIgnoreCase("true") || System.getProperty("JAVASIM", "false").equalsIgnoreCase("true")) {
            n = this.getSimPort();
            MessageLog.info((Class)CelloOrb.class, (String)("Running on SimCello or JavaSim. OAPort was set to " + n));
        }
        properties.setProperty("OAPort", System.getProperty("OAPort", Integer.toString(n)));
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
            properties.setProperty("jacorb.ior_proxy_host", this.ipAddressHelper.getIpv4Address());
            properties.setProperty("jacorb.ior_proxy_port", System.getProperty("OAPort", Integer.toString(n)));
        }
        properties.setProperty("jacorb.poa.thread_pool_min", "5");
        properties.setProperty("jacorb.poa.thread_pool_max", "20");
        properties.setProperty("jacorb.poa.thread_pool_shared", "on");
        properties.setProperty("jacorb.poa.thread_priority", "5");
        properties.setProperty("jacorb.connection.client.max_idle_receptor_threads", "4");
        properties.setProperty("jacorb.connection.client.max_receptor_threads", "30");
        properties.setProperty("jacorb.connection.server.max_idle_receptor_threads", "3");
        properties.setProperty("jacorb.connection.server.max_receptor_threads", "30");
        properties.setProperty("jacorb.connection.server.timeout", "3600000");
        properties.setProperty("jacorb.connection.max_server_connections", "30");
        properties.setProperty("jacorb.connection.client.idle_timeout", "600000");
        properties.setProperty("jacorb.connection.wait_for_idle_interval", "500");
        properties.setProperty("jacorb.connection.server.shutdown_timeout", "60000");
        properties.setProperty("jacorb.connection.client.pending_reply_timeout", "600000");
        properties.setProperty("jacorb.maxMessageBufferSize", "10000000");
        properties.setProperty("jacorb.buffermanager.factory", "org.jacorb.orb.MultipleBufferManagerFactory");
        properties.setProperty("jacorb.connection.client.timeout_ignores_pending_messages", "on");
        properties.setProperty("jacorb.connection.client.ungraceful_shutdown", "true");
        properties.setProperty("jacorb.disableServiceContextNegotiation", "on");
        properties.setProperty("jacorb.connection.selection_strategy_class", "org.jacorb.orb.giop.LRUSelectionStrategyImpl");
        properties.setProperty("jacorb.connection.statistics_provider_class", "org.jacorb.orb.giop.LRUStatisticsProviderImpl");
        properties.setProperty("jacorb.cachePoaNames", "on");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.dummy_suffix1", "se.ericsson.cello.support.corba.AccessControlEnablerImpl");
        properties.setProperty("jacorb.net.tcp_listener", "se.ericsson.security.corba.NetworkListener");
        properties.setProperty("jacorb.security.ssl.ssl_listener", "se.ericsson.security.corba.NetworkListener");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.dummy_suffix2", "se.ericsson.cello.support.corba.SecurityLoggerImpl");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.dummy_suffix3", "se.ericsson.cello.support.corba.TraceErrorLogAdapterImpl");
        properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.dummy_suffix4", "se.ericsson.cello.support.corba.NodeCredPasswordFetcherImpl");
        if (!System.getProperty("os.name").startsWith("Linux")) {
            policyArray = properties.getProperty("jacorb.security.ssl.server.cipher_suites");
            MessageLog.info((Class)CelloOrb.class, (String)("supportedCiphers: " + (String)policyArray));
            String string = CipherHelper.instance().getEnabledCiphers((String)policyArray);
            MessageLog.info((Class)CelloOrb.class, (String)("enabledCiphers: " + string));
            if (string.equals("DEFAULT") || string.equals("")) {
                MessageLog.info((Class)CelloOrb.class, (String)"supportedCiphers are used.");
            } else {
                properties.setProperty("jacorb.security.ssl.server.cipher_suites", string);
                properties.setProperty("jacorb.security.ssl.client.cipher_suites", string);
                MessageLog.info((Class)CelloOrb.class, (String)"New cipher suite configuration set");
            }
            CipherHelper.instance().sendIpomCsucjiTlsSubscribeReq((String)policyArray);
        }
        this.ipv6Address = this.ipAddressHelper.getIpv6Address();
        if (this.ipv6Address != null && this.ipAddressHelper.getIpv4Address() != null) {
            properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.RemoteAddressInterceptor", "se.ericsson.cello.support.corba.RemoteAddressInterceptor");
        }
        this.traceOrbProperties(properties);
        this.orb = null;
        this.poa = null;
        this.rootPoa = null;
        this.current = null;
        this.securityActivated = false;
        this.orb = ORB.init((String[])null, (Properties)properties);
        try {
            this.rootPoa = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            policyArray = new Policy[]{this.rootPoa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.rootPoa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            this.poa = this.rootPoa.create_POA("persistent_poa", this.rootPoa.the_POAManager(), policyArray);
            this.rootPoa.the_POAManager().activate();
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"Should not happen?!", (Throwable)invalidName);
        }
        catch (InvalidPolicy invalidPolicy) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"Should not happen?!", (Throwable)invalidPolicy);
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"Should not happen?!", (Throwable)adapterAlreadyExists);
        }
        catch (AdapterInactive adapterInactive) {
            MessageLog.traceError((Class)CelloOrb.class, (String)"Should not happen?!", (Throwable)adapterInactive);
        }
        catch (Exception exception) {
            if (this.orb != null) {
                MessageLog.trace((int)5, (Class)CelloOrb.class, (String)"POA activation failed, shutting down ORB to release threads");
                this.orb.shutdown(true);
            }
            throw new RuntimeException(exception);
        }
        try {
            this.current = (Current)this.orb.resolve_initial_references("OMSecSecurityCurrent");
            this.securityActivated = true;
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            this.securityActivated = false;
        }
        policyArray = this.getSecurityModeFile();
        this.ensureDirectory((File)policyArray);
        if (policyArray.exists()) {
            policyArray.delete();
        }
        if (this.writeFile((File)policyArray, this.getSecModeMsg(this.securityActivated))) {
            MessageLog.info(this.getClass(), (String)("Security mode written to file " + policyArray));
        }
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    public synchronized Current getCurrent() {
        return this.current;
    }

    public synchronized boolean securityActivated() {
        return this.securityActivated;
    }

    private String getSecModeMsg(boolean bl) {
        if (bl) {
            return SECURITY_ON_MSG;
        }
        return SECURITY_OFF_MSG;
    }

    private boolean writeFile(File file, String string) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            MessageLog.traceError(this.getClass(), (String)"writeFile()", (Throwable)iOException);
            return false;
        }
    }

    private File getSecurityModeFile() {
        return new File(this.pathPrefix() + SECURITY_MODE_FILE);
    }

    private String pathPrefix() {
        if (System.getProperty("SIM") == null && System.getProperty("JAVASIM") == null) {
            return TARGET_PATH;
        }
        return System.getProperty("oms.javasim.security.dir", HOST_PATH);
    }

    private void ensureDirectory(File file) {
        String string;
        String string2 = file.getName();
        if (!string2.equals(string = file.getPath())) {
            File file2 = new File(string.substring(0, string.length() - string2.length()));
            file2.mkdirs();
        }
    }

    private void traceOrbProperties(Properties properties) {
        TreeMap<java.lang.Object, java.lang.Object> treeMap = new TreeMap<java.lang.Object, java.lang.Object>(properties);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Listing ORB properties set by OMS\n");
        stringBuffer.append("---------------------------------\n");
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append(" = ");
            stringBuffer.append(entry.getValue()).append("\n");
        }
        stringBuffer.append("----------------------\n");
        MessageLog.trace((int)5, this.getClass(), (String)stringBuffer.toString());
        treeMap.clear();
    }

    private int getSimPort() {
        int n = 56834;
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            n = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException iOException) {
            MessageLog.info((Class)CelloOrb.class, (String)"It was not possible to create a OAPort, trying default port number.");
        }
        return n;
    }

    private CelloOrb() {
    }
}

