/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.ExchangeTerminalIpMo;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sync.PacketTimeSyncRefMo;
import se.ericsson.cello.sync.PacketTimeSyncRefMoGen;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.SynchronizationMoImpl;
import se.ericsson.cello.sync.TimingUnitMo;
import se.ericsson.cello.transaction.Coordinator;

public class PacketTimeSyncRefMoImpl
extends PacketTimeSyncRefMoGen
implements SyncReservable {
    private boolean isServerAddrIpv4 = false;
    private boolean isServerAddrIpv6 = false;

    public PacketTimeSyncRefMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public PacketTimeSyncRefMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("transportLayerRef");
        Coordinator coordinator = setRequestContext.getCoordinator();
        int n = this.findTuFroID(managedObject);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("timTuFroId", n));
        String string = (String)setRequestContext.getAttributeFromRequest("serverAddress");
        if (string == null) {
            string = "";
        }
        this.checkServerAddress(string, managedObject, coordinator);
        Integer n2 = (Integer)setRequestContext.getAttributeFromRequest("ptpProfile");
        int n3 = n2 == null ? 5 : n2;
        this.checkPtpProfile(n3, managedObject);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("PacketTimeSyncRef");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("transportLayerRef")) {
                if (object instanceof ManagedObject) {
                    ManagedObject managedObject = (ManagedObject)object;
                    this.validateTransportLayerRef(managedObject, (SetRequestContext)setRequestContextImpl);
                    ManagedObject managedObject2 = this.getTransportLayerRef(coordinator);
                    this.updateReservedMos(managedObject2, managedObject, coordinator, string);
                    ((ReferenceAttribute)this.data.getAttribute("transportLayerRef")).setValue(managedObject);
                    int n = 0;
                    if (managedObject != null && managedObject instanceof FroInfo) {
                        n = ((FroInfo)managedObject).getFroId(coordinator);
                    }
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("transportLayerRef", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("transportLayerRef", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("asymmetryCompensation")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateAsymmetryCompensation(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("asymmetryCompensation", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("asymmetryCompensation", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("administrativeState")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateAdministrativeState(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("administrativeState", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("ptpDomain")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePtpDomain(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ptpDomain", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ptpDomain", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("pBit")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePBit(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("pBit", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("pBit", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("ptpProfile")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePtpProfile(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ptpProfile", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ptpProfile", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("ptpMulticastAddress")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePtpMulticastAddress(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ptpMulticastAddress", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ptpMulticastAddress", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("ptpPathTimeError")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePtpPathTimeError(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ptpPathTimeError", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ptpPathTimeError", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("dscp")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateDscp(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("dscp", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("dscp", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("serverAddress")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    if (string3.equals("")) {
                        throw new OperationNotAllowedException("ServerAddress must not be set to an empty string", "PacketTimeSyncRef");
                    }
                    this.validateServerAddress(string3, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("serverAddress", string3));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("serverAddress", "PacketTimeSyncRef");
            }
            if (string.equalsIgnoreCase("ptpPacketSel2WayTE")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validatePtpPacketSel2WayTE(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ptpPacketSel2WayTE", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("ptpPacketSel2WayTE", "PacketTimeSyncRef");
            }
            throw new NoSuchAttributeException(string, "PacketTimeSyncRef");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        Object object;
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("ptpProfile")) {
            int n = (Integer)setRequestContext.getAttributeFromRequest("ptpProfile");
            object = setRequestContext.isIncludedInRequest("transportLayerRef") ? (ManagedObject)setRequestContext.getAttributeFromRequest("transportLayerRef") : this.getTransportLayerRef(coordinator);
            this.checkPtpProfile(n, (ManagedObject)object);
        }
        if (setRequestContext.isIncludedInRequest("serverAddress")) {
            ManagedObject managedObject = setRequestContext.isIncludedInRequest("transportLayerRef") ? (ManagedObject)setRequestContext.getAttributeFromRequest("transportLayerRef") : this.getTransportLayerRef(coordinator);
            object = (String)setRequestContext.getAttributeFromRequest("serverAddress");
            this.checkServerAddress((String)object, managedObject, coordinator);
        }
        if (setRequestContext.isIncludedInRequest("transportLayerRef")) {
            ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("transportLayerRef");
            if (setRequestContext.isIncludedInRequest("serverAddress")) {
                return;
            }
            object = this.getServerAddress(coordinator);
            this.checkServerAddress((String)object, managedObject, coordinator);
        }
    }

    protected void validatePtpDomain(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validatePtpDomain(n, setRequestContext);
        Coordinator coordinator = setRequestContext.getCoordinator();
        MoIterator moIterator = MoRepository.instance().lookupType("PacketTimeSyncRef");
        while (moIterator != null && moIterator.hasMoreElements()) {
            PacketTimeSyncRefMo packetTimeSyncRefMo = (PacketTimeSyncRefMo)moIterator.nextElement();
            if (packetTimeSyncRefMo == this || n != packetTimeSyncRefMo.getPtpDomain(coordinator)) continue;
            throw new ConfigurationMismatchException("PtpDomain has to be a unique number among the configured packetTimeSyncRef ");
        }
    }

    protected void validateTransportLayerRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTransportLayerRef(managedObject, setRequestContext);
        if (!(managedObject instanceof GigaBitEthernetMo) && !(managedObject instanceof IpAccessHostEtMo)) {
            throw new ValueOutOfRangeException("transportLayerRef", "PacketTimeSyncRef");
        }
        MoIterator moIterator = MoRepository.instance().lookupType("Synchronization");
        ManagedObject[] managedObjectArray = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            SynchronizationMoImpl synchronizationMoImpl = (SynchronizationMoImpl)moIterator.nextMo();
            if (synchronizationMoImpl == null) continue;
            managedObjectArray = synchronizationMoImpl.getAssistingReference(null);
        }
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (managedObjectArray[i] == null || !managedObjectArray[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName()) || managedObject instanceof IpAccessHostEtMo) continue;
                throw new OperationNotAllowedException("If PacketTimeSyncRef MO instance is added as assistingRefernce list in Synchronization MO. Then transportLayerRef must have reference to an IpAccessHostEt Mo.", "PacketTimeSyncRef");
            }
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("refType", managedObject.getRelativeDistinguishedName()));
    }

    protected void validateServerAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateServerAddress(string, setRequestContext);
        if (!string.equals("")) {
            IpAddressValidation.validateHostName((String)string, (String)"PacketTimeSyncRef", (String)"serverAddress");
        }
        if (Ipv6AddressValidation.isIpv6((String)string)) {
            this.isServerAddrIpv6 = true;
            if (Ipv6AddressValidation.isUnspecifiedIpv6((String)string) || Ipv6AddressValidation.isLoopBackIpv6Address((String)string) || Ipv6AddressValidation.isMultiCastIpv6Address((String)string)) {
                throw new OperationNotAllowedException("ServerAddress must not be LoopBack,Unspecified or Multicast Ipv6 address", "PacketTimeSyncRef");
            }
        } else {
            this.isServerAddrIpv6 = false;
        }
        if (Ipv4AddressValidation.isIpv4((String)string)) {
            this.isServerAddrIpv4 = true;
            if (Ipv4AddressValidation.isDefault((String)string) || Ipv4AddressValidation.isLoopBackIpAddress((String)string) || Ipv4AddressValidation.isMultiCastIpAddress((String)string)) {
                throw new OperationNotAllowedException("ServerAddress must not be LoopBack,Unspecified or Multicast Ipv4 address", "PacketTimeSyncRef");
            }
        } else {
            this.isServerAddrIpv4 = false;
        }
    }

    protected Object handleGetPtpQualityLevel(GetRequestContext getRequestContext) throws MoAccessException {
        StructParameter structParameter = (StructParameter)getRequestContext.getParameter("parentDs");
        if (structParameter == null) {
            throw new FroRequestFailedException("PacketTimeSyncRef", "Missing parameter from FRO: parentDs", "getAttributes", -1);
        }
        return new Integer(((SignedIntParameter)structParameter.get("parentDs_grandmasterClockClass")).getValue());
    }

    protected void handleSetPtpQualityLevel(int n, SetRequestContext setRequestContext) throws MoAccessException {
    }

    private void checkServerAddress(String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof IpAccessHostEtMo) {
            if (string.equals("")) {
                return;
            }
            if (!this.isServerAddrIpv6 && !this.isServerAddrIpv4) {
                return;
            }
            String string2 = ((IpAccessHostEtMo)managedObject).getIpAddress(coordinator);
            if (!(string2 == null || Ipv6AddressValidation.isIpv6((String)string2) && Ipv6AddressValidation.isIpv6((String)string) || Ipv4AddressValidation.isIpv4((String)string2) && Ipv4AddressValidation.isIpv4((String)string))) {
                throw new OperationNotAllowedException("IpAddress version of IpAccessHostEt and PacketTimeSyncRef must be same", "PacketTimeSyncRef");
            }
        }
    }

    private int findTuFroID(ManagedObject managedObject) throws MoAccessException {
        int n = 0;
        if (managedObject instanceof GigaBitEthernetMo) {
            n = this.findFroId(managedObject);
        } else if (managedObject instanceof IpAccessHostEtMo) {
            ManagedObject managedObject2 = ((IpAccessHostEtMo)managedObject).getIpInterfaceMoRef(null);
            if (managedObject2 instanceof IpInterfaceMo) {
                n = this.findFroId(managedObject2.getParent());
            } else if (managedObject2 instanceof Ipv6InterfaceMo) {
                ManagedObject managedObject3 = ((Ipv6InterfaceMo)managedObject2).getEthernetRef(null);
                n = this.findFroId(managedObject3);
            }
        }
        return n;
    }

    private int findFroId(ManagedObject managedObject) throws MoAccessException {
        ExchangeTerminalIpMo exchangeTerminalIpMo = (ExchangeTerminalIpMo)managedObject.getParent();
        PlugInUnitMo plugInUnitMo = null;
        plugInUnitMo = exchangeTerminalIpMo.getParent() instanceof PiuDeviceMo ? (PlugInUnitMo)exchangeTerminalIpMo.getParent().getParent() : (PlugInUnitMo)exchangeTerminalIpMo.getParent();
        MoIterator moIterator = plugInUnitMo.getChildren();
        ManagedObject managedObject2 = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (managedObject2 instanceof TimingUnitMo) {
                    return ((FroInfo)managedObject2).getFroId(null);
                }
                if (!(managedObject2 instanceof CbuMo)) continue;
                MoIterator moIterator2 = managedObject2.getChildren();
                while (moIterator2.hasMoreElements()) {
                    ManagedObject managedObject3 = moIterator2.nextMo();
                    if (!(managedObject3 instanceof TimingUnitMo)) continue;
                    return ((FroInfo)managedObject3).getFroId(null);
                }
            }
        }
        return 0;
    }

    private void checkPtpProfile(int n, ManagedObject managedObject) throws MoAccessException {
        if (n == 5) {
            return;
        }
        MoIterator moIterator = MoRepository.instance().lookupType("Synchronization");
        ManagedObject[] managedObjectArray = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            SynchronizationMoImpl synchronizationMoImpl = (SynchronizationMoImpl)moIterator.nextMo();
            if (synchronizationMoImpl == null) continue;
            managedObjectArray = synchronizationMoImpl.getAssistingReference(null);
        }
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (managedObjectArray[i] == null || !managedObjectArray[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                if (n != 4) {
                    throw new OperationNotAllowedException("If PacketTimeSyncRef MO instance is added as assistingRefernce list in Synchronization MO. Then PtpProfile value should be 4 or DEFAULT.", "PacketTimeSyncRef");
                }
                if (managedObject instanceof IpAccessHostEtMo) continue;
                throw new OperationNotAllowedException("If PacketTimeSyncRef MO instance is added as assistingRefernce list in Synchronization MO. Then transportLayerRef must have reference to an IpAccessHostEt Mo.", "PacketTimeSyncRef");
            }
        }
        if (n == 4) {
            if (managedObject instanceof GigaBitEthernetMo) {
                throw new OperationNotAllowedException("If PtpProfile value is " + n + " then  TransportLayerRef attribute must refer to IpAccessHostEt MO", "PacketTimeSyncRef");
            }
        } else if (managedObject instanceof IpAccessHostEtMo) {
            throw new OperationNotAllowedException("PtpProfile value should be 4 or 5 if PacketTimeSyncRef Mo refers to IpAccessHostEt MO", "PacketTimeSyncRef");
        }
    }
}

