/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.AbstractProfileSelector;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;
import org.omg.RTCORBA.Protocol;

public class SpecificProfileSelector
extends AbstractProfileSelector {
    private final Protocol[] protocols;
    private final String prefix = "[JAC824] SpecificProfileSelector[" + this.hashCode() + "]: ";

    public SpecificProfileSelector(Protocol[] protocols) {
        this.protocols = protocols;
    }

    public Profile selectProfile(List profiles, ClientConnectionManager ccm, Map cookie) {
        String spsVal;
        boolean spsShow;
        boolean stShow;
        String stVal = System.getProperty("ShowProfileStackTrace");
        boolean bl = stShow = stVal != null && stVal.equals("1");
        if (stShow) {
            Exception st = new Exception("selectProfile stack trace");
            System.err.println(this.prefix + "stack trace for selectProfile call:");
            st.printStackTrace();
        }
        boolean bl2 = spsShow = (spsVal = System.getProperty("ShowProfileSelection")) != null && spsVal.equals("1");
        if (spsShow) {
            int i2;
            System.out.println(this.prefix + "profile count = " + profiles.size());
            for (i2 = 0; i2 < profiles.size(); ++i2) {
                Profile p2 = (Profile)profiles.get(i2);
                System.out.println("   tag: " + p2.tag() + ", GIOP version " + p2.version().major + "." + p2.version().minor);
            }
            System.out.println(this.prefix + "protocol count = " + this.protocols.length);
            for (i2 = 0; i2 < this.protocols.length; ++i2) {
                System.out.println("   type: " + Integer.toString(this.protocols[i2].protocol_type, 16));
            }
        }
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            Profile profile = (Profile)iter.next();
            int profileTag = profile.tag();
            if (spsShow) {
                System.out.println(this.prefix + "processing profile " + profile.toString() + ", tag = " + profileTag);
            }
            for (int i3 = 0; i3 < this.protocols.length; ++i3) {
                int tagToMatch = this.protocols[i3].protocol_type;
                if (spsShow) {
                    System.out.println(this.prefix + "comparing against protocol " + this.protocols[i3].toString() + ", type = " + tagToMatch);
                }
                if (profileTag == tagToMatch) {
                    if (spsShow) {
                        System.out.println(this.prefix + "tag/type match, returning this profile");
                    }
                    return profile;
                }
                if (profileTag != 0 || !(profile instanceof IIOPProfile)) continue;
                IIOPProfile iiopProfile = (IIOPProfile)profile;
                if (spsShow) {
                    String sslPresent = iiopProfile.getSSL() == null ? "not present" : "present";
                    System.out.println(this.prefix + "checking for SSL special case; getSSL = " + sslPresent);
                }
                if (tagToMatch == 1245904896 && iiopProfile.getSSL() != null) {
                    if (spsShow) {
                        System.out.println(this.prefix + "special case 1 triggered: returning this profile");
                    }
                    return profile;
                }
                if (tagToMatch != 1245904897 || iiopProfile.getSSL() != null && (iiopProfile.getSSL().target_requires & 1) == 0) continue;
                if (spsShow) {
                    System.out.println(this.prefix + "special case 2 triggered: returning this profile");
                }
                return profile;
            }
        }
        if (spsShow) {
            System.out.println(this.prefix + "out of loop: returning null");
        }
        return null;
    }
}

