/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.handler.IMRRequestHandler;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.GOA;
import org.jacorb.poa.POA;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private final ORB orb;
    private final POA rootPOA;
    private Logger logger = null;
    private boolean require_ssl = false;
    private boolean disableSvcNegotiation;

    public ServerRequestListener(ORB orb, POA rootPOA) {
        this.orb = orb;
        this.rootPOA = rootPOA;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        org.jacorb.config.Configuration configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = configuration.getNamedLogger("jacorb.giop.server.listener");
        this.disableSvcNegotiation = configuration.getAttributeAsBoolean("jacorb.disableServiceContextNegotiation", false);
        boolean supportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        if (supportSSL) {
            int required = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16, 16);
            this.require_ssl = supportSSL && (required & 0x60) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReceived(byte[] request, GIOPConnection connection) {
        ServerRequest server_request;
        RequestInputStream inputStream;
        boolean sendJacSvcReply;
        block43: {
            block41: {
                block42: {
                    sendJacSvcReply = false;
                    inputStream = new RequestInputStream((org.omg.CORBA.ORB)this.orb, connection, request);
                    if (this.require_ssl && !connection.isSSL()) {
                        ReplyOutputStream out = new ReplyOutputStream(this.orb, inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
                        this.logger.debug("About to reject request because connection is not SSL.");
                        SystemExceptionHelper.write(out, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
                        try {
                            connection.sendReply(out);
                        }
                        catch (IOException e2) {
                            this.logger.warn("IOException", e2);
                        }
                        finally {
                            out.close();
                        }
                        return;
                    }
                    if (Messages.responseExpected(inputStream.req_hdr.response_flags)) {
                        connection.incPendingMessages();
                    }
                    if (connection.isTCSNegotiated()) break block41;
                    if (inputStream.getGIOPMinor() != 0) break block42;
                    connection.markTCSNegotiated();
                    break block43;
                }
                CodeSetContext ctx = null;
                ServiceContext[] contexts = inputStream.req_hdr.service_context;
                for (int i2 = 0; i2 < contexts.length; ++i2) {
                    if (contexts[i2].context_id == 1) {
                        CDRInputStream is = new CDRInputStream(contexts[i2].context_data);
                        try {
                            is.openEncapsulatedArray();
                            ctx = CodeSetContextHelper.read(is);
                            continue;
                        }
                        finally {
                            is.close();
                        }
                    }
                    if (this.disableSvcNegotiation || contexts[i2].context_id != 1245904912) continue;
                    if (contexts[i2].context_data.length > 0) {
                        sendJacSvcReply = true;
                        continue;
                    }
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Received a JacORB context key negotiation with an incompatible version of the key system. Disabling key system.");
                }
                if (ctx == null) break block43;
                connection.setCodeSets(ctx.char_data, ctx.wchar_data);
                connection.markTCSNegotiated();
                if (!this.logger.isDebugEnabled()) break block43;
                this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(ctx.char_data) + " as TCS and " + CodeSet.csName(ctx.wchar_data) + " as TCSW");
                break block43;
            }
            if (!this.disableSvcNegotiation) {
                for (int i3 = 0; i3 < inputStream.req_hdr.service_context.length; ++i3) {
                    if (inputStream.req_hdr.service_context[i3].context_id != 1245904912) continue;
                    if (inputStream.req_hdr.service_context[i3].context_data.length > 0) {
                        sendJacSvcReply = true;
                        continue;
                    }
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Received a JacORB context key negotiation with an incompatible version of the key system. Disabling key system.");
                }
            }
        }
        inputStream.setCodeSet(connection.getTCS(), connection.getTCSW());
        inputStream.updateMutatorConnection(connection);
        try {
            try {
                server_request = new ServerRequest(this.orb, inputStream, connection);
            }
            catch (INTERNAL e3) {
                this.logger.debug("Unable to create ServerRequest throwing marshal for client to resend with full object key.", e3);
                ReplyOutputStream out = new ReplyOutputStream(this.orb, inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
                try {
                    SystemExceptionHelper.write(out, new MARSHAL("Could not find object key " + e3, 1245904912, CompletionStatus.COMPLETED_MAYBE));
                    connection.sendReply(out);
                }
                catch (IOException ie) {
                    this.logger.debug("unable to sendReply", ie);
                }
                finally {
                    out.close();
                }
                return;
            }
            if (sendJacSvcReply) {
                server_request.sendServiceCtxReply();
            }
        }
        catch (POAInternalError pie) {
            this.logger.warn("Received a request with a non-jacorb object key", pie);
            if (inputStream.isLocateRequest()) {
                LocateReplyOutputStream out = new LocateReplyOutputStream(this.orb, inputStream.req_hdr.request_id, 0, inputStream.getGIOPMinor());
                try {
                    connection.sendReply(out);
                }
                catch (IOException e4) {
                    this.logger.warn("IOException", e4);
                }
                finally {
                    out.close();
                }
            } else {
                ReplyOutputStream out = new ReplyOutputStream(this.orb, inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
                try {
                    SystemExceptionHelper.write(out, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                    connection.sendReply(out);
                }
                catch (IOException e5) {
                    this.logger.warn("unexpected exception during requestReceived", e5);
                }
                finally {
                    out.close();
                }
            }
            return;
        }
        this.deliverRequest(server_request);
    }

    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.requestReceived(request, connection);
    }

    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
    }

    private void deliverRequest(ServerRequest request) {
        block15: {
            POA tmp_poa = this.rootPOA;
            TagGroupTaggedComponent tagGroup = request.getTagGroup();
            if (tagGroup != null) {
                ((GOA)this.rootPOA).processGroupRequest(tagGroup, request);
                return;
            }
            try {
                String res;
                String refImplName = "";
                String orbImplName = this.orb.getImplName();
                String orbServerId = this.orb.getServerIdString();
                try {
                    refImplName = POAUtil.extractImplName(request.objectKey());
                }
                catch (POAInternalError pie) {
                    this.logger.debug("serverRequestListener: reference generated by foreign POA");
                }
                if (!orbImplName.equals(refImplName) && !orbServerId.equals(refImplName)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("serverRequestListener: impl_name mismatch (refImplName: " + refImplName + " and orbServerId " + orbServerId + " and orbImplName " + orbImplName);
                    }
                    throw new WrongAdapter();
                }
                List scopes = request.getScopes();
                for (int i2 = 0; i2 < scopes.size() && (res = (String)scopes.get(i2)).length() != 0; ++i2) {
                    try {
                        tmp_poa = tmp_poa._getChildPOA(res);
                        continue;
                    }
                    catch (ParentIsHolding p2) {
                        String[] rest_of_name = new String[scopes.size() - i2];
                        for (int j2 = 0; j2 < rest_of_name.length; ++j2) {
                            rest_of_name[j2] = (String)scopes.get(j2 + i2);
                        }
                        request.setRemainingPOAName(rest_of_name);
                        break;
                    }
                }
                if (tmp_poa == null) {
                    throw new INTERNAL("Request POA null!");
                }
                tmp_poa._invoke(request);
            }
            catch (Exception ex) {
                if (this.orb.isIMR()) {
                    this.logger.debug("let IMRRequestHandler handle failed request", ex);
                    IMRRequestHandler irh = new IMRRequestHandler(this.orb);
                    irh.handle_request(request);
                }
                if (ex instanceof WrongAdapter) {
                    request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                    request.reply();
                }
                if (ex instanceof SystemException) {
                    request.setSystemException((SystemException)ex);
                    request.reply();
                }
                request.setSystemException(new UNKNOWN(ex.toString()));
                request.reply();
                if (!this.logger.isDebugEnabled()) break block15;
                this.logger.debug("Unexpected exception", ex);
            }
        }
    }
}

