/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.miop.MIOPListener;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.poa.AGM;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.PortableGroup.NotAGroupObject;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class GOA
extends POA
implements org.omg.PortableGroup.GOA {
    private AGM agm;
    private Map portTable;
    private MIOPListener listener = null;
    private Logger logger;

    public GOA(ORB orb, String name, POA parent, POAManager manager, Policy[] policies) {
        super(orb, name, parent, manager, policies);
        Factories f2 = orb.getTransportManager().getFactories(3);
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.poa");
        if (f2 != null) {
            this.listener = (MIOPListener)f2.create_listener(null, 0, (short)0);
            this.agm = new AGM();
            this.portTable = new HashMap();
        }
    }

    public void disassociate_reference_with_id(Object ref, byte[] oid) throws NotAGroupObject {
        MIOPProfile profile = this.getMIOPProfile(ref);
        this.removeGroupMember(profile, oid);
    }

    public void associate_reference_with_id(Object ref, byte[] oid) throws NotAGroupObject {
        MIOPProfile profile = this.getMIOPProfile(ref);
        this.addGroupMember(profile, oid);
    }

    public byte[] create_id_for_reference(Object ref) throws NotAGroupObject {
        MIOPProfile profile = this.getMIOPProfile(ref);
        byte[] oid = this.generateObjectId();
        this.addGroupMember(profile, oid);
        return oid;
    }

    public byte[][] reference_to_ids(Object ref) throws NotAGroupObject {
        return this.agm.getMembersFromGroup(this.getMIOPProfile(ref).getTagGroup());
    }

    public void processGroupRequest(TagGroupTaggedComponent tagGroup, ServerRequest request) {
        byte[][] members = this.agm.getMembersFromGroup(tagGroup);
        if (members.length > 0) {
            ORB orb = this.getORB();
            byte[] buffer = request.getInputStream().getBufferCopy();
            for (int i2 = 0; i2 < members.length; ++i2) {
                ServerRequest requestClone = new ServerRequest(orb, new RequestInputStream((org.omg.CORBA.ORB)orb, request.getConnection(), buffer), request.getConnection());
                try {
                    byte[] oid = members[i2];
                    Object member = this.id_to_reference(oid);
                    Delegate delegate = (Delegate)((ObjectImpl)member)._get_delegate();
                    requestClone.setObjectKey(delegate.getObjectKey());
                    this._invoke(requestClone);
                    continue;
                }
                catch (WrongAdapter ex) {
                    this.logger.error("Caught exception processing group request", ex);
                    continue;
                }
                catch (ObjectNotActive ex) {
                    this.logger.error("Caught exception processing group request", ex);
                    continue;
                }
                catch (WrongPolicy ex) {
                    this.logger.error("Caught exception processing group request", ex);
                    continue;
                }
                catch (SystemException ex) {
                    this.logger.error("Caught SystemException processing group request", ex);
                    continue;
                }
                catch (RuntimeException ex) {
                    this.logger.error("Caught unknown exception processing group request", ex);
                }
            }
        }
        org.omg.PortableServer.POA[] children = this.the_children();
        for (int i3 = 0; i3 < children.length; ++i3) {
            ((GOA)children[i3]).processGroupRequest(tagGroup, request);
        }
    }

    private MIOPProfile getMIOPProfile(Object ref) throws NotAGroupObject {
        Delegate delegate = (Delegate)((ObjectImpl)ref)._get_delegate();
        Profile profile = delegate.getParsedIOR().getEffectiveProfile();
        if (profile instanceof MIOPProfile) {
            return (MIOPProfile)profile;
        }
        throw new NotAGroupObject(ref.toString());
    }

    private final void addGroupMember(MIOPProfile profile, byte[] oid) {
        int nMembers = this.agm.addToGroup(profile.getTagGroup(), oid);
        if (nMembers == 1 && !this.listener.haveGroupConnection(profile.getUIPMCProfile().the_port)) {
            this.listener.addGroupConnection(profile);
        }
        this.portTable.put(oid, profile);
    }

    private final void removeGroupMember(MIOPProfile profile, byte[] oid) {
        if (this.agm.removeFromGroup(profile.getTagGroup(), oid) == 0) {
            this.listener.removeGroupConnection(profile.getUIPMCProfile().the_port);
        }
        this.portTable.remove(oid);
    }

    void clearGroupRegistration(byte[] oid) {
        if (this.agm != null) {
            ArrayList groupsKeys = this.agm.getGroupsWithMember(oid);
            for (int i2 = 0; i2 < groupsKeys.size(); ++i2) {
                if (this.agm.removeFromGroup(((AGM.TGTCWrapper)groupsKeys.get((int)i2)).tcgtc, oid) != 0) continue;
                this.listener.removeGroupConnection(((MIOPProfile)this.portTable.get((java.lang.Object)oid)).getUIPMCProfile().the_port);
            }
        }
    }
}

