/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAManagerMonitor;
import org.jacorb.poa.POAManagerMonitorLightImpl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer._POAManagerLocalBase;

public class POAManager
extends _POAManagerLocalBase {
    public State state = State.HOLDING;
    private final ORB orb;
    private final List poas = new ArrayList();
    private POAManagerMonitor monitor;
    protected boolean poaCreationFailed;

    protected POAManager(ORB _orb) {
        this.orb = _orb;
        this.monitor = new POAManagerMonitorLightImpl();
        try {
            this.monitor.configure(this.orb.getConfiguration());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.monitor.init(this);
        this.monitor.openMonitor();
        this.monitor.printMessage("ready");
    }

    public synchronized void activate() throws AdapterInactive {
        this.checkCreation();
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 1: {
                break;
            }
            default: {
                this.state = State.ACTIVE;
                this.monitor.setToActive();
                POA[] poaArray = this.poas.toArray(new POA[this.poas.size()]);
                for (int i2 = 0; i2 < poaArray.length; ++i2) {
                    try {
                        poaArray[i2].changeToActive();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public synchronized void deactivate(boolean etherealize_objects, boolean wait_for_completion) throws AdapterInactive {
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
        }
        this.state = State.INACTIVE;
        this.monitor.setToInactive(wait_for_completion, etherealize_objects);
        boolean etherealize = etherealize_objects;
        POA[] poaArray = this.poas.toArray(new POA[this.poas.size()]);
        for (int i2 = poaArray.length - 1; i2 >= 0; --i2) {
            try {
                poaArray[i2].changeToInactive(wait_for_completion, etherealize);
                continue;
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
    }

    public synchronized void discard_requests(boolean wait_for_completion) throws AdapterInactive {
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 2: {
                break;
            }
            default: {
                this.state = State.DISCARDING;
                this.monitor.setToDiscarding(wait_for_completion);
                POA[] poaArray = this.poas.toArray(new POA[this.poas.size()]);
                for (int i2 = poaArray.length - 1; i2 >= 0; --i2) {
                    try {
                        poaArray[i2].changeToDiscarding(wait_for_completion);
                        continue;
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public State get_state() {
        return this.state;
    }

    protected synchronized POA getRegisteredPOA(String name) {
        Iterator en = this.poas.iterator();
        while (en.hasNext()) {
            POA result = (POA)en.next();
            if (!name.equals(result._getQualifiedName())) continue;
            return result;
        }
        throw new INTERNAL("POA not registered: RootPOA/" + name);
    }

    public synchronized void hold_requests(boolean wait_for_completion) throws AdapterInactive {
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 0: {
                break;
            }
            default: {
                this.state = State.HOLDING;
                this.monitor.setToHolding(wait_for_completion);
                POA[] poaArray = this.poas.toArray(new POA[this.poas.size()]);
                for (int i2 = poaArray.length - 1; i2 >= 0; --i2) {
                    try {
                        poaArray[i2].changeToHolding(wait_for_completion);
                        continue;
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected synchronized void registerPOA(POA poa) {
        if (!this.poas.contains(poa)) {
            this.poas.add(poa);
            this.monitor.addPOA(poa._getQualifiedName());
        }
    }

    protected void setMonitor(POAManagerMonitor _monitor) {
        this.monitor = _monitor;
    }

    protected synchronized void unregisterPOA(POA poa) {
        this.poas.remove(poa);
        this.monitor.removePOA(poa._getQualifiedName());
    }

    private void checkCreation() {
        if (this.poaCreationFailed) {
            throw new INTERNAL("POA Creation failed; unable to deactive");
        }
    }
}

