/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.poa.RPPoolManager;

public class RPPoolManagerFactory {
    private final ORB orb;
    private final Logger logger;
    private final Configuration configuration;
    private final int threadPoolMin;
    private final int threadPoolMax;
    private final FactoryDelegate delegate;

    public RPPoolManagerFactory(ORB orb) throws ConfigurationException {
        this.orb = orb;
        this.configuration = orb.getConfiguration();
        this.logger = this.configuration.getNamedLogger("jacorb.poa.controller");
        this.threadPoolMin = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_min", 5);
        if (this.threadPoolMin < 1) {
            throw new ConfigurationException("jacorb.poa.thread_pool_min must be >= 1");
        }
        this.threadPoolMax = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
        if (this.threadPoolMax < this.threadPoolMin) {
            throw new ConfigurationException("jacorb.poa.thread_pool_max must be >= " + this.threadPoolMin + "(jacorb.poa.thread_pool_min)");
        }
        boolean poolsShouldBeShared = this.configuration.getAttributeAsBoolean("jacorb.poa.thread_pool_shared", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RequestProcessorPoolFactory settings: thread_pool_min=" + this.threadPoolMin + " thread_pool_max=" + this.threadPoolMax + " thread_pool_shared=" + poolsShouldBeShared);
        }
        this.delegate = poolsShouldBeShared ? new SharedPoolFactory() : new DefaultPoolFactory();
    }

    public void destroy(boolean waitForCompletion) {
        this.delegate.destroy(waitForCompletion);
    }

    public RPPoolManager newRPPoolManager(boolean isSingleThreaded) {
        if (isSingleThreaded) {
            return new RPPoolManager(this.orb.getPOACurrent(), 1, 1, this.logger, this.configuration){

                void destroy() {
                    this.destroy(true);
                }

                protected void warnPoolIsEmpty() {
                }
            };
        }
        return this.delegate.newRPPoolManager();
    }

    private class DefaultPoolFactory
    implements FactoryDelegate {
        private DefaultPoolFactory() {
        }

        public RPPoolManager newRPPoolManager() {
            return new RPPoolManager(this, RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){
                private final /* synthetic */ DefaultPoolFactory this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2, x3, x4);
                }

                void destroy() {
                    this.destroy(true);
                }
            };
        }

        public void destroy(boolean waitForCompletion) {
        }
    }

    private class SharedPoolFactory
    implements FactoryDelegate {
        private final RPPoolManager sharedInstance;

        private SharedPoolFactory() {
            this.sharedInstance = new RPPoolManager(this, RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){
                private final /* synthetic */ SharedPoolFactory this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2, x3, x4);
                }

                void destroy() {
                }
            };
        }

        public RPPoolManager newRPPoolManager() {
            return this.sharedInstance;
        }

        public void destroy(boolean waitForCompletion) {
            this.sharedInstance.destroy(waitForCompletion);
        }
    }

    private static interface FactoryDelegate {
        public RPPoolManager newRPPoolManager();

        public void destroy(boolean var1);
    }
}

