/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DEREnumerated
extends DERObject {
    byte[] xb;

    public static DEREnumerated getInstance(Object object) {
        if (object == null || object instanceof DEREnumerated) {
            return (DEREnumerated)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DEREnumerated(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DEREnumerated.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DEREnumerated.getInstance(aSN1TaggedObject.getObject());
    }

    public DEREnumerated(int n) {
        this.xb = BigInteger.valueOf(n).toByteArray();
    }

    public DEREnumerated(BigInteger bigInteger) {
        this.xb = bigInteger.toByteArray();
    }

    public DEREnumerated(byte[] byArray) {
        this.xb = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.xb);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(10, this.xb);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated dEREnumerated = (DEREnumerated)object;
        if (this.xb.length != dEREnumerated.xb.length) {
            return false;
        }
        for (int k = 0; k != this.xb.length; ++k) {
            if (this.xb[k] == dEREnumerated.xb[k]) continue;
            return false;
        }
        return true;
    }
}

