/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DERGeneralizedTime
extends DERObject {
    String wb;

    public static DERGeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralizedTime.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralizedTime(String string) {
        this.wb = string;
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.wb = simpleDateFormat.format(date);
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.wb = new String(cArray);
    }

    public String getTime() {
        if (this.wb.charAt(this.wb.length() - 1) == 'Z') {
            return this.wb.substring(0, this.wb.length() - 1) + "GMT+00:00";
        }
        int n = this.wb.length() - 5;
        char c2 = this.wb.charAt(n);
        if (c2 == '-' || c2 == '+') {
            return this.wb.substring(0, n) + "GMT" + this.wb.substring(n, n + 3) + ":" + this.wb.substring(n + 3);
        }
        n = this.wb.length() - 3;
        c2 = this.wb.charAt(n);
        if (c2 == '-' || c2 == '+') {
            return this.wb.substring(0, n) + "GMT" + this.wb.substring(n) + ":00";
        }
        return this.wb;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.wb);
    }

    private byte[] f() {
        char[] cArray = this.wb.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(24, this.f());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.wb.equals(((DERGeneralizedTime)object).wb);
    }
}

