/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DERUTCTime
extends DERObject {
    String gc;

    public static DERUTCTime getInstance(Object object) {
        if (object == null || object instanceof DERUTCTime) {
            return (DERUTCTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTCTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTCTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTCTime.getInstance(aSN1TaggedObject.getObject());
    }

    public DERUTCTime(String string) {
        this.gc = string;
    }

    public DERUTCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.gc = simpleDateFormat.format(date);
    }

    DERUTCTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.gc = new String(cArray);
    }

    public String getTime() {
        if (this.gc.length() == 11) {
            return this.gc.substring(0, 10) + "00GMT+00:00";
        }
        if (this.gc.length() == 13) {
            return this.gc.substring(0, 12) + "GMT+00:00";
        }
        if (this.gc.length() == 17) {
            return this.gc.substring(0, 12) + "GMT" + this.gc.substring(12, 15) + ":" + this.gc.substring(15, 17);
        }
        return this.gc;
    }

    public String getAdjustedTime() {
        String string = this.getTime();
        if (string.charAt(0) < '5') {
            return "20" + string;
        }
        return "19" + string;
    }

    private byte[] h() {
        char[] cArray = this.gc.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(23, this.h());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERUTCTime)) {
            return false;
        }
        return this.gc.equals(((DERUTCTime)object).gc);
    }
}

