/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERVisibleString
extends DERObject
implements DERString {
    String fb;

    public static DERVisibleString getInstance(Object object) {
        if (object == null || object instanceof DERVisibleString) {
            return (DERVisibleString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERVisibleString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERVisibleString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERVisibleString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERVisibleString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERVisibleString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        this.fb = new String(cArray);
    }

    public DERVisibleString(String string) {
        this.fb = string;
    }

    public String getString() {
        return this.fb;
    }

    public byte[] getOctets() {
        char[] cArray = this.fb.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int k = 0; k != cArray.length; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(26, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERVisibleString)) {
            return false;
        }
        return this.getString().equals(((DERVisibleString)object).getString());
    }
}

