/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.ChannelAdapter;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.PseudoTerminalModes;
import com.maverick.ssh.Shell;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;

public class ShellEnvironment {
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_AIX = 4;
    public static final int OS_DARWIN = 5;
    public static final int OS_FREEBSD = 6;
    public static final int OS_OPENBSD = 7;
    public static final int OS_NETBSD = 8;
    public static final int OS_UNKNOWN = 99;
    static String g = "\r";
    Properties f = new Properties();
    int c = 99;
    String b;
    SshClient d;
    Shell e;

    public ShellEnvironment(int n) {
        this.c = n;
        this.b();
    }

    public ShellEnvironment(String string) {
        string = string.toLowerCase();
        this.c = string.startsWith("sun") || string.startsWith("solaris") ? 3 : (string.startsWith("aix") ? 4 : (string.startsWith("windows") ? 1 : (string.startsWith("darwin") ? 5 : (string.startsWith("freebsd") ? 6 : (string.startsWith("openbsd") ? 7 : (string.startsWith("netbsd") ? 8 : (string.startsWith("linux") ? 2 : 99)))))));
        this.b();
    }

    ShellEnvironment(SshClient sshClient, Shell shell) throws SshException, ChannelOpenException {
        SshSession sshSession = null;
        this.d = sshClient;
        this.e = shell;
        try {
            sshSession = this.c();
            boolean bl = false;
            if (sshSession.executeCommand("set")) {
                bl = this.b(sshSession.getInputStream());
            }
            sshSession.close();
            if (!bl) {
                sshSession = this.c();
                if (sshSession.executeCommand("env")) {
                    bl = this.b(sshSession.getInputStream());
                }
                sshSession.close();
            }
            if (!bl) {
                sshSession = this.c();
                if (sshSession.executeCommand("cmd.exe /C set")) {
                    bl = this.b(sshSession.getInputStream());
                }
                sshSession.close();
            }
            if (((Hashtable)this.f).containsKey("OS") && this.f.getProperty("OS").startsWith("Windows")) {
                if (((Hashtable)this.f).containsKey("OSTYPE") && this.f.getProperty("OSTYPE").equals("cygwin")) {
                    this.c = 2;
                    this.b = this.b + " [" + this.f.getProperty("OSTYPE") + "]";
                } else {
                    this.c = 1;
                    this.b = "Windows";
                    sshSession = this.c();
                    if (sshSession.executeCommand("cmd.exe /C ver")) {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sshSession.getInputStream()));
                        while ((string = bufferedReader.readLine()) != null) {
                            if (string.indexOf("Windows") <= -1) continue;
                            this.b = string;
                            break;
                        }
                        bufferedReader.close();
                    }
                }
                sshSession.close();
            } else {
                sshSession = this.c();
                if (sshSession.executeCommand("uname")) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sshSession.getInputStream()));
                    this.b = bufferedReader.readLine();
                    this.c = this.b.startsWith("Sun") ? 3 : (this.b.startsWith("AIX") ? 4 : (this.b.startsWith("Darwin") ? 5 : (this.b.startsWith("FreeBSD") ? 6 : (this.b.startsWith("OpenBSD") ? 7 : (this.b.startsWith("NetBSD") ? 8 : (this.b.startsWith("Linux") ? 2 : 99))))));
                    bufferedReader.close();
                } else {
                    this.c = 99;
                }
                this.b();
                sshSession.close();
                if (this.c != 99 && ((Hashtable)this.f).containsKey("OSTYPE")) {
                    this.b = this.b + " [" + this.f.getProperty("OSTYPE") + "]";
                }
            }
        }
        catch (IOException iOException) {
            throw new SshException("Error whilst reading remote shell environment", (Throwable)iOException);
        }
        finally {
            if (sshSession != null && !sshSession.isClosed()) {
                sshSession.close();
            }
        }
    }

    private void b() {
        this.b = this.c == 3 ? "Solaris" : (this.c == 4 ? "AIX" : (this.c == 1 ? "Windows" : (this.c == 5 ? "Darwin" : (this.c == 6 ? "FreeBSD" : (this.c == 7 ? "OpenBSD" : (this.c == 8 ? "NetBSD" : (this.c == 2 ? "Linux" : "Unknown")))))));
    }

    public Properties getEnvironmentVariables() {
        return this.f;
    }

    private SshSession c() throws SshException, ChannelOpenException {
        SshSession sshSession = this.d.openSessionChannel();
        if (this.e.isAllocatePseudoTerminal()) {
            PseudoTerminalModes pseudoTerminalModes = new PseudoTerminalModes(this.d);
            pseudoTerminalModes.setTerminalMode(53, false);
            if (!sshSession.requestPseudoTerminal("vt100", 80, 24, 0, 0, pseudoTerminalModes)) {
                throw new SshException("Server failed to allocate a pseudo terminal!", 15);
            }
        }
        sshSession.addChannelEventListener(new ChannelAdapter(){

            public void channelClosed(SshChannel sshChannel) {
            }
        });
        return sshSession;
    }

    private boolean b(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n <= -1) continue;
            ((Hashtable)this.f).put(string.substring(0, n), string.substring(n + 1));
            bl = true;
        }
        inputStream.close();
        bufferedReader.close();
        return bl;
    }

    public int getOSType() {
        return this.c;
    }

    public String getOperatingSystem() {
        return this.b;
    }

    public String getEnvironmentVariable(String string) {
        return this.f.getProperty(string);
    }

    public boolean hasEnvironmentVariable(String string) {
        return ((Hashtable)this.f).containsKey(string);
    }

    public String getEOL() {
        switch (this.c) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "\r";
            }
            case 1: {
                return "\r\n";
            }
        }
        return g;
    }
}

