/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh.components.jce.AbstractKeyExchange;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroupExchangeSha1
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    BigInteger jc;
    BigInteger hc;
    static BigInteger ec = BigInteger.valueOf(1L);
    BigInteger lc = null;
    BigInteger kc = null;
    BigInteger oc = null;
    String fc;
    String ic;
    byte[] mc;
    byte[] qc;
    KeyPairGenerator pc;
    KeyAgreement nc;
    KeyFactory gc;

    public DiffieHellmanGroupExchangeSha1() {
        this("SHA-1");
    }

    protected DiffieHellmanGroupExchangeSha1(String string) {
        super(string);
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1;
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        try {
            Serializable serializable;
            Object object;
            this.fc = string;
            this.ic = string2;
            this.mc = byArray;
            this.qc = byArray2;
            try {
                this.gc = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
                this.pc = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
                this.nc = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
            }
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(30);
            byteArrayWriter.writeInt(1024);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byte[] byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 31) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEX_GEX_GROUP");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEX_GEX_GROUP [id=" + byArray3[0] + "]", 5);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.hc = byteArrayReader.readBigInteger();
            this.jc = byteArrayReader.readBigInteger();
            try {
                object = new DHParameterSpec(this.hc, this.jc);
                this.pc.initialize((AlgorithmParameterSpec)object);
                serializable = this.pc.generateKeyPair();
                this.nc.init(serializable.getPrivate());
                this.lc = ((DHPublicKey)serializable.getPublic()).getY();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SshException("Failed to generate DH value", 16);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new SshException("Failed to generate DH value", 16);
            }
            byteArrayWriter.reset();
            byteArrayWriter.write(32);
            byteArrayWriter.writeBigInteger(this.lc);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 33) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEXDH_GEX_REPLY");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEXDH_GEX_REPLY [id=" + byArray3[0] + "]", 5);
            }
            byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.hostKey = byteArrayReader.readBinaryString();
            this.kc = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
            object = new DHPublicKeySpec(this.kc, this.hc, this.jc);
            serializable = (DHPublicKey)this.gc.generatePublic((KeySpec)object);
            this.nc.doPhase((Key)serializable, true);
            byArray3 = this.nc.generateSecret();
            if ((byArray3[0] & 0x80) == 128) {
                byte[] byArray4 = new byte[byArray3.length + 1];
                System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
                byArray3 = byArray4;
            }
            this.secret = new BigInteger(byArray3);
            this.calculateExchangeHash();
        }
        catch (Exception exception) {
            throw new SshException(exception, 5);
        }
    }

    public String getProvider() {
        if (this.nc != null) {
            return this.nc.getProvider().getName();
        }
        return "";
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        digest.putString(this.fc);
        digest.putString(this.ic);
        digest.putInt(this.mc.length);
        digest.putBytes(this.mc);
        digest.putInt(this.qc.length);
        digest.putBytes(this.qc);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putInt(1024);
        digest.putBigInteger(this.hc);
        digest.putBigInteger(this.jc);
        digest.putBigInteger(this.lc);
        digest.putBigInteger(this.kc);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }
}

