/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.jce.Ssh2RsaPublicKey;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;

public class Ssh1RsaPublicKey
extends Ssh2RsaPublicKey {
    public Ssh1RsaPublicKey(RSAPublicKey rSAPublicKey) {
        super(rSAPublicKey);
    }

    public Ssh1RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        super(bigInteger, bigInteger2);
    }

    public byte[] getEncoded() throws SshException {
        try {
            byte[] byArray = this.getModulus().toByteArray();
            byte[] byArray2 = this.getPublicExponent().toByteArray();
            int n = byArray[0] == 0 ? 1 : 0;
            int n2 = byArray2[0] == 0 ? 1 : 0;
            byte[] byArray3 = new byte[byArray.length + byArray2.length - n - n2];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            System.arraycopy(byArray2, n2, byArray3, byArray.length - n, byArray2.length - n2);
            return byArray3;
        }
        catch (Throwable throwable) {
            throw new SshException("Ssh1RsaPublicKey.getEncoded() caught an exception: " + throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName(), 5);
        }
    }

    public String getAlgorithm() {
        return "rsa1";
    }

    public int getVersion() {
        return 1;
    }
}

