/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshDsaPrivateKey;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.ssh.components.jce.Ssh2DsaPublicKey;
import com.maverick.util.SimpleASNReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;

public class Ssh2DsaPrivateKey
implements SshDsaPrivateKey {
    protected DSAPrivateKey prv;
    private Ssh2DsaPublicKey f;

    public Ssh2DsaPrivateKey(DSAPrivateKey dSAPrivateKey, DSAPublicKey dSAPublicKey) {
        this.prv = dSAPrivateKey;
        this.f = new Ssh2DsaPublicKey(dSAPublicKey);
    }

    public Ssh2DsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) throws SshException {
        try {
            KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            this.prv = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
            this.f = new Ssh2DsaPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger5);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public byte[] sign(byte[] byArray) throws IOException {
        try {
            Signature signature = JCEProvider.getProviderForAlgorithm("SHA1WithDSA") == null ? Signature.getInstance("SHA1WithDSA") : Signature.getInstance("SHA1WithDSA", JCEProvider.getProviderForAlgorithm("SHA1WithDSA"));
            signature.initSign(this.prv);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            byte[] byArray3 = new byte[40];
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            simpleASNReader.getByte();
            simpleASNReader.getLength();
            simpleASNReader.getByte();
            byte[] byArray4 = simpleASNReader.getData();
            simpleASNReader.getByte();
            byte[] byArray5 = simpleASNReader.getData();
            if (byArray4.length >= 20) {
                System.arraycopy(byArray4, byArray4.length - 20, byArray3, 0, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray3, 20 - byArray4.length, byArray4.length);
            }
            if (byArray5.length >= 20) {
                System.arraycopy(byArray5, byArray5.length - 20, byArray3, 20, 20);
            } else {
                System.arraycopy(byArray5, 0, byArray3, 20 + (20 - byArray5.length), byArray5.length);
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new IOException("Failed to sign data! " + exception.getMessage());
        }
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public SshDsaPublicKey getPublicKey() {
        return this.f;
    }

    public BigInteger getX() {
        return this.prv.getX();
    }
}

