/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshRsaPrivateCrtKey;
import com.maverick.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;

public class Ssh2RsaPrivateCrtKey
implements SshRsaPrivateCrtKey {
    protected RSAPrivateCrtKey prv;

    public Ssh2RsaPrivateCrtKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.prv = rSAPrivateCrtKey;
    }

    public Ssh2RsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        this.prv = (RSAPrivateCrtKey)keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
    }

    public BigInteger doPrivate(BigInteger bigInteger) throws SshException {
        try {
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            cipher.init(2, (Key)this.prv, JCEProvider.getSecureRandom());
            return new BigInteger(cipher.doFinal(bigInteger.toByteArray()));
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public BigInteger getCrtCoefficient() {
        return this.prv.getCrtCoefficient();
    }

    public BigInteger getPrimeExponentP() {
        return this.prv.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return this.prv.getPrimeExponentQ();
    }

    public BigInteger getPrimeP() {
        return this.prv.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return this.prv.getPrimeQ();
    }

    public BigInteger getPublicExponent() {
        return this.prv.getPublicExponent();
    }

    public BigInteger getModulus() {
        return this.prv.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.prv.getPrivateExponent();
    }

    public byte[] sign(byte[] byArray) throws IOException {
        try {
            Signature signature = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            signature.initSign(this.prv);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new IOException("Failed to sign data! " + exception.getMessage());
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }
}

