/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.components.SshRsaPrivateKey;
import com.maverick.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;

public class Ssh2RsaPrivateKey
implements SshRsaPrivateKey {
    protected RSAPrivateKey prv;

    public Ssh2RsaPrivateKey(RSAPrivateKey rSAPrivateKey) {
        this.prv = rSAPrivateKey;
    }

    public Ssh2RsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        this.prv = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
    }

    public byte[] sign(byte[] byArray) throws IOException {
        try {
            Signature signature = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            signature.initSign(this.prv);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new IOException("Failed to sign data! " + exception.getMessage());
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public BigInteger getModulus() {
        return this.prv.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.prv.getPrivateExponent();
    }
}

