/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.ssh.components.jce.Ssh2DsaPublicKey;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;

public class SshX509DsaPublicKey
extends Ssh2DsaPublicKey {
    public static final String X509V3_SIGN_DSA = "x509v3-sign-dss";
    X509Certificate b;

    public SshX509DsaPublicKey() {
    }

    public SshX509DsaPublicKey(X509Certificate x509Certificate) {
        super((DSAPublicKey)x509Certificate.getPublicKey());
        this.b = x509Certificate;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_DSA;
    }

    public byte[] getEncoded() throws SshException {
        try {
            return this.b.getEncoded();
        }
        catch (Throwable throwable) {
            throw new SshException("Failed to encoded key data", 5, throwable);
        }
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            CertificateFactory certificateFactory = JCEProvider.getProviderForAlgorithm("X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm("X.509"));
            this.b = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            if (!(this.b.getPublicKey() instanceof DSAPublicKey)) {
                throw new SshException("Certificate public key is not an DSA public key!", 4);
            }
            this.pubkey = (DSAPublicKey)this.b.getPublicKey();
        }
        catch (Throwable throwable) {
            throw new SshException(throwable.getMessage(), 16, throwable);
        }
    }

    public X509Certificate getCertificate() {
        return this.b;
    }
}

