/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.ssh.components.jce.Ssh2RsaPublicKey;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

public class SshX509RsaSha1PublicKey
extends Ssh2RsaPublicKey {
    public static final String X509V3_SIGN_RSA_SHA1 = "x509v3-sign-rsa-sha1";
    X509Certificate d;

    public SshX509RsaSha1PublicKey() {
    }

    public SshX509RsaSha1PublicKey(X509Certificate x509Certificate) {
        super((RSAPublicKey)x509Certificate.getPublicKey());
        this.d = x509Certificate;
    }

    public String getAlgorithm() {
        return X509V3_SIGN_RSA_SHA1;
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBinaryString(this.d.getEncoded());
            return byteArrayWriter.toByteArray();
        }
        catch (Throwable throwable) {
            throw new SshException("Failed to encoded key data", 5, throwable);
        }
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, n, n2);
            String string = byteArrayReader.readString();
            if (!string.equals(X509V3_SIGN_RSA_SHA1)) {
                throw new SshException("The encoded key is not X509 RSA", 5);
            }
            byte[] byArray2 = byteArrayReader.readBinaryString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            CertificateFactory certificateFactory = JCEProvider.getProviderForAlgorithm("X.509") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", JCEProvider.getProviderForAlgorithm("X.509"));
            this.d = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            if (!(this.d.getPublicKey() instanceof RSAPublicKey)) {
                throw new SshException("Certificate public key is not an RSA public key!", 4);
            }
            this.c = (RSAPublicKey)this.d.getPublicKey();
        }
        catch (Throwable throwable) {
            throw new SshException(throwable.getMessage(), 16, throwable);
        }
    }

    public X509Certificate getCertificate() {
        return this.d;
    }
}

