/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.events.Event;
import com.maverick.events.EventServiceImplementation;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh2.AuthenticationClient;
import com.maverick.ssh2.AuthenticationResult;
import com.maverick.ssh2.BannerDisplay;
import com.maverick.ssh2.TransportProtocol;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;

public class AuthenticationProtocol {
    public static final int SSH_MSG_USERAUTH_REQUEST = 50;
    TransportProtocol d;
    BannerDisplay c;
    int b = 2;
    public static final String SERVICE_NAME = "ssh-userauth";

    public SshKeyExchangeClient getKeyExchange() {
        return this.d.getKeyExchange();
    }

    public AuthenticationProtocol(TransportProtocol transportProtocol) throws SshException {
        this.d = transportProtocol;
        transportProtocol.startService(SERVICE_NAME);
    }

    public void setBannerDisplay(BannerDisplay bannerDisplay) {
        this.c = bannerDisplay;
    }

    public byte[] readMessage() throws SshException, AuthenticationResult {
        byte[] byArray;
        while (this.b(byArray = this.d.nextMessage())) {
        }
        return byArray;
    }

    public int authenticate(AuthenticationClient authenticationClient, String string) throws SshException {
        try {
            authenticationClient.authenticate(this, string);
            this.readMessage();
            this.d.disconnect(2, "Unexpected response received from Authentication Protocol");
            throw new SshException("Unexpected response received from Authentication Protocol", 3);
        }
        catch (AuthenticationResult authenticationResult) {
            this.b = authenticationResult.getResult();
            if (this.b == 1) {
                this.d.i();
            }
            return this.b;
        }
    }

    public String getAuthenticationMethods(String string, String string2) throws SshException {
        this.sendRequest(string, string2, "none", null);
        try {
            this.readMessage();
            this.d.disconnect(2, "Unexpected response received from Authentication Protocol");
            throw new SshException("Unexpected response received from Authentication Protocol", 3);
        }
        catch (AuthenticationResult authenticationResult) {
            this.b = authenticationResult.getResult();
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 11, true).addAttribute("AUTHENTICATION_METHODS", authenticationResult.getAuthenticationMethods()));
            return authenticationResult.getAuthenticationMethods();
        }
    }

    public void sendRequest(String string, String string2, String string3, byte[] byArray) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(50);
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString(string2);
            byteArrayWriter.writeString(string3);
            if (byArray != null) {
                byteArrayWriter.write(byArray);
            }
            this.d.sendMessage(byteArrayWriter.toByteArray(), true);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean isAuthenticated() {
        return this.b == 1;
    }

    public byte[] getSessionIdentifier() {
        return this.d.getSessionIdentifier();
    }

    private boolean b(byte[] byArray) throws SshException, AuthenticationResult {
        try {
            switch (byArray[0]) {
                case 51: {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    byteArrayReader.skip(1L);
                    String string = byteArrayReader.readString();
                    if (byteArrayReader.read() == 0) {
                        EventServiceImplementation.getInstance().fireEvent(new Event(this, 14, true));
                        throw new AuthenticationResult(2, string);
                    }
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 15, true));
                    throw new AuthenticationResult(3, string);
                }
                case 52: {
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 13, true));
                    throw new AuthenticationResult(1);
                }
                case 53: {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    byteArrayReader.skip(1L);
                    if (this.c != null) {
                        this.c.displayBanner(byteArrayReader.readString());
                    }
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public void sendMessage(byte[] byArray) throws SshException {
        this.d.sendMessage(byArray, true);
    }

    public String getHost() {
        return this.d.kb.getHost();
    }
}

