/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.util;

import java.io.IOException;

public class SimpleASNReader {
    private byte[] b;
    private int c;

    public SimpleASNReader(byte[] byArray) {
        this.b = byArray;
        this.c = 0;
    }

    public void assertByte(int n) throws IOException {
        int n2 = this.getByte();
        if (n2 != n) {
            throw new IOException("Assertion failed, next byte value is " + Integer.toHexString(n2) + " instead of asserted " + Integer.toHexString(n));
        }
    }

    public int getByte() {
        return this.b[this.c++] & 0xFF;
    }

    public byte[] getData() {
        int n = this.getLength();
        return this.b(n);
    }

    public int getLength() {
        int n;
        if (((n = this.b[this.c++] & 0xFF) & 0x80) != 0) {
            int n2 = 0;
            for (int k = n & 0x7F; k > 0; --k) {
                n2 <<= 8;
                n2 |= this.b[this.c++] & 0xFF;
            }
            return n2;
        }
        return n;
    }

    private byte[] b(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.b, this.c, byArray, 0, n);
        this.c += n;
        return byArray;
    }

    public boolean hasMoreData() {
        return this.c < this.b.length;
    }
}

