/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.common.StringHelper;

public class ExceptionHelper {
    protected static final String REASON_STR = " Reason: ";
    private static final String MATCH_ERROR_TEXT = ", Error text: ";
    private static final String MATCH_RESULT_TEXT = "result\" = \"";

    public static String convertToString(Throwable throwable) {
        ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return arrayStream.toString();
    }

    public static String getExceptionMessage(Throwable throwable) {
        StringBuffer exceptionMessage = new StringBuffer();
        if (throwable instanceof MoAccessException) {
            MoAccessException moAccessException = (MoAccessException)throwable;
            if (moAccessException.getCause() != null) {
                exceptionMessage.append(", Caused by: ").append(ExceptionHelper.getExceptionMessage(moAccessException.getCause()));
            }
            exceptionMessage.insert(0, StringHelper.doubleQuote(moAccessException.getVariablesAsString()));
            exceptionMessage.insert(1, StringHelper.doubleQuote(moAccessException.getReasonTag()));
        } else {
            if (throwable.getCause() != null) {
                exceptionMessage.append(", Caused by: ").append(ExceptionHelper.getExceptionMessage(throwable.getCause()));
            }
            exceptionMessage.insert(0, StringHelper.doubleQuote(throwable.getMessage()));
        }
        return exceptionMessage.toString();
    }

    public static String appendReason(String msgToAppendTo, Throwable throwable) {
        return msgToAppendTo + REASON_STR + ExceptionHelper.getExceptionMessage(throwable);
    }

    public static String getErrorString(String exceptionVariables) {
        String errorText = "";
        int startIndex = exceptionVariables.indexOf(MATCH_ERROR_TEXT) + MATCH_ERROR_TEXT.length();
        int stopIndex = exceptionVariables.indexOf(MATCH_RESULT_TEXT) - "\", \"".length();
        errorText = exceptionVariables.substring(startIndex, stopIndex);
        return errorText;
    }
}

