/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.common.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.ArrayHelper;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLogger;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerObserver;

public class ConfigurationReportLoggerImpl
implements ConfigurationReportLogger {
    public static final Object MUTEX_OBJECT = new Object();
    protected static final String THREAD_NAME = "CrbsGoamLm_ConfigurationReportLoggerThread";
    private static final int MAX_ATTRIBUTE_SIZE = 65000;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    private static final SimpleDateFormat sdfFile = new SimpleDateFormat("yyyy-MM-dd_HHmmss", Locale.ENGLISH);
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl == null ? (class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl = ConfigurationReportLoggerImpl.class$("se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerImpl")) : class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl;
    private static final AbstractLogger logger = LoggingService.getLogger((class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl == null ? (class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl = ConfigurationReportLoggerImpl.class$("se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerImpl")) : class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl).getName());
    private StringBuffer reportBuffer = null;
    private File reportFile = null;
    private int maxNumberOfFiles = new Integer(Integer.parseInt(System.getProperty("config.report.file.maxnum.", "5")));
    private double maxCrFileSizeMB = new Double(Double.parseDouble(System.getProperty("config.report.file.maxsize.", "10")));
    private double blockSize = 1048576.0;
    private long maxCrFileSizeBytes = Math.round(this.blockSize * this.maxCrFileSizeMB);
    ConfigurationReportLoggerObserver callback;
    private LogEntryWriter logEntryWriter;
    protected boolean attributeFull = false;
    protected int configurationReportUpdateCounter = 0;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$common$logger$ConfigurationReportLoggerImpl;

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public void stop() {
        this.logEntryWriter.stopIt();
    }

    public void finishAndSaveReportFile(boolean cancelAction) {
        logger.traceEnter(THIS_CLASS, "finishAndSaveReportFile()");
        if (this.reportFile.exists() || cancelAction) {
            this.flushLogEntryBufferToFile();
            File test = new File(this.getDefaultConfigurationReportPath());
            test.getParent();
            String newFileName = test.getParent() + File.separator + "reportFile_" + this.getFileTimeStamp() + ".log";
            boolean success = this.reportFile.renameTo(new File(newFileName));
            if (success) {
                logger.traceDebug(THIS_CLASS, "Renamed report file, " + this.reportFile.getPath() + ", to " + newFileName + ".");
            } else {
                logger.traceDebug(THIS_CLASS, "Failed to rename report file, " + this.reportFile.getPath() + ".");
            }
        }
        logger.traceReturn(THIS_CLASS, "finishAndSaveReportFile()");
    }

    public String getFileTimeStamp() {
        return DateTimeHelper.dateToString(System.currentTimeMillis(), sdfFile);
    }

    public StringBuffer getTimeStamp() {
        return this.padString(DateTimeHelper.dateToString(System.currentTimeMillis(), sdf), 25);
    }

    public void setConfigurationReportStringBuffer(StringBuffer reportAttribute) {
        logger.traceEnter(THIS_CLASS, "setConfigurationReportStringBuffer()");
        this.attributeFull = false;
        StringBuffer data = new StringBuffer("");
        if (reportAttribute != null) {
            data = reportAttribute;
        }
        if ("".equals(data.toString())) {
            data.append(NEW_LINE).append(this.padString("Time Stamp", 25)).append(this.padString("Attr. Name", 47)).append("Attr. Value").append(NEW_LINE).append(NEW_LINE);
        }
        this.saveLogEntry(data);
        logger.traceReturn(THIS_CLASS, "setConfigurationReportStringBuffer()");
    }

    public void logAction(String moType, String action, String attributes, String attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAction() action: " + action + " on " + moType);
        StringBuffer logEntry = new StringBuffer().append(this.getTimeStamp()).append(this.padString(moType + ":" + action, 47));
        if (!"".equals(attributes)) {
            logEntry.append("Attributes: ").append(attributes).append(NEW_LINE).append(this.padString("", 72)).append("Values:     ").append(attributeValues);
        }
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logAction(String moType, String action, String[] attributes, Object[] attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAction([]) action: " + action + " on " + moType);
        StringBuffer logEntry = new StringBuffer(32).append(this.getTimeStamp()).append(this.padString(moType + ":" + action, 47)).append("<- Attribute = Value ->").append(NEW_LINE);
        for (int index = 0; index < attributes.length && index < attributeValues.length; ++index) {
            logEntry.append(this.padString("", 72));
            this.appendAttribute(logEntry, attributes[index], attributeValues[index]);
            logEntry.append(NEW_LINE);
        }
        this.saveLogEntry(logEntry);
    }

    public void logAttribute(String moType, String attributeName, Object attributeValue) {
        logger.traceDebug(THIS_CLASS, "logAttribute() attribute " + attributeName + " on " + moType);
        StringBuffer logEntry = new StringBuffer().append(this.getTimeStamp()).append(this.padString(moType, 47));
        this.appendAttribute(logEntry, attributeName, attributeValue);
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logAttributes(String moType, String[] attributeNames, Object[] attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAttributes() attributes on " + moType);
        StringBuffer logEntry = new StringBuffer(32).append(this.getTimeStamp()).append(this.padString(moType + ":", 47)).append("<- Attribute = Value ->").append(NEW_LINE);
        for (int index = 0; index < attributeNames.length && index < attributeValues.length; ++index) {
            logEntry.append(this.padString("", 72));
            this.appendAttribute(logEntry, attributeNames[index], attributeValues[index]);
            logEntry.append(NEW_LINE);
        }
        this.saveLogEntry(logEntry);
    }

    public void logFailure(String failureSlogan, String failureDescr) {
        logger.traceDebug(THIS_CLASS, "logFailure() - " + failureSlogan + " : " + failureDescr);
        if ("".equals(failureSlogan) && "".equals(failureDescr)) {
            logger.traceDebug(THIS_CLASS, "Fault reason resetted.");
        } else {
            StringBuffer logEntry = new StringBuffer().append(this.padString("", 112, '-')).append(NEW_LINE).append(this.getTimeStamp()).append(this.padString(failureSlogan, 47)).append(failureDescr).append(NEW_LINE);
            this.saveLogEntry(logEntry);
        }
    }

    public void logInformation(String informationSlogan, String information) {
        logger.traceDebug(THIS_CLASS, "logInformation() - " + informationSlogan + " : " + information);
        StringBuffer logEntry = new StringBuffer().append(NEW_LINE).append(this.getTimeStamp()).append(this.padString(informationSlogan, 47)).append(information).append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logInformation(String informationSlogan, String information, Coordinator coordinator) {
        logger.traceDebug(THIS_CLASS, "logInformation() - " + informationSlogan + " : " + information);
        StringBuffer logEntry = new StringBuffer().append(NEW_LINE).append(this.getTimeStamp()).append(this.padString(informationSlogan, 47)).append(information).append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    private void appendAttribute(StringBuffer logEntry, String attributeName, Object attributeValue) {
        if (!logEntry.toString().endsWith(" ")) {
            logEntry.append(' ');
        }
        if (attributeValue == null) {
            logEntry.append(attributeName).append(" = <EMPTY>");
        } else if (attributeValue instanceof Struct) {
            this.apppendStructAttribute(logEntry, attributeName, (Struct)attributeValue);
        } else if (attributeValue.getClass().isArray()) {
            this.appendArrayAttribute(logEntry, attributeName, attributeValue);
        } else if (attributeValue instanceof ManagedObject) {
            logEntry.append(attributeName).append(" = ").append(((ManagedObject)attributeValue).getLocalDistinguishedName());
        } else {
            logEntry.append(attributeName).append(" = ").append(attributeValue);
        }
    }

    private void appendArrayAttribute(StringBuffer logEntry, String attributeName, Object arrayAttributeValue) {
        if (arrayAttributeValue instanceof int[]) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, ArrayHelper.convertToIntegerArray((int[])arrayAttributeValue));
        } else if (arrayAttributeValue instanceof boolean[]) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, ArrayHelper.convertToBooleanArray((boolean[])arrayAttributeValue));
        } else if (this.isIntegerBooleanOrStringArray(arrayAttributeValue) || this.isObjectArrayOfIntegerBooleanOrString(arrayAttributeValue)) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, (Object[])arrayAttributeValue);
        } else {
            this.appendComplexArrayAttribute(logEntry, attributeName, (Object[])arrayAttributeValue);
        }
    }

    private void appendComplexArrayAttribute(StringBuffer logEntry, String attributeName, Object[] objectArray) {
        String combinedName = attributeName + "[";
        for (int index = 0; index < objectArray.length; ++index) {
            if (index != 0) {
                logEntry.append(this.padString("", 72));
            }
            this.appendAttribute(logEntry, combinedName + index + ']', objectArray[index]);
            if (index == objectArray.length - 1) continue;
            logEntry.append(NEW_LINE);
        }
    }

    private void appendPrintableArrayToStringbuffer(StringBuffer logEntry, String attributName, Object[] printableArray) {
        logEntry.append(attributName).append(" = ");
        for (int i = 0; i < printableArray.length; ++i) {
            logEntry.append(printableArray[i]);
            if (i == printableArray.length - 1) continue;
            logEntry.append(", ");
        }
    }

    private void apppendStructAttribute(StringBuffer logEntry, String attributeName, Struct structObject) {
        try {
            String[] structmemberNames = structObject.getNames();
            Object[] structmemberValues = structObject.getValues();
            for (int index = 0; index < structmemberNames.length; ++index) {
                String combinedName = attributeName + "." + structmemberNames[index];
                if (index != 0) {
                    logEntry.append(this.padString("", 72));
                }
                this.appendAttribute(logEntry, combinedName, structmemberValues[index]);
                if (index == structmemberNames.length - 1) continue;
                logEntry.append(NEW_LINE);
            }
        }
        catch (MoAccessException mnfe) {
            logEntry.append(attributeName).append("=Struct");
            logger.traceAbnormal(THIS_CLASS, "Exception caught while trying to traverse struct: " + attributeName);
        }
    }

    private boolean isIntegerBooleanOrStringArray(Object arrayAttributeValue) {
        boolean isIntegerBooleanOrStringArray = false;
        if (arrayAttributeValue instanceof Integer[] || arrayAttributeValue instanceof Boolean[] || arrayAttributeValue instanceof String[]) {
            isIntegerBooleanOrStringArray = true;
        }
        return isIntegerBooleanOrStringArray;
    }

    private boolean isObjectArrayOfIntegerBooleanOrString(Object arrayAttributeValue) {
        boolean isObjectArrayOfIntegerBooleanOrString = false;
        Object[] objectArrayAttributeValue = (Object[])arrayAttributeValue;
        if (objectArrayAttributeValue.length > 0 && objectArrayAttributeValue[0] instanceof Integer || objectArrayAttributeValue[0] instanceof Boolean || objectArrayAttributeValue[0] instanceof String) {
            isObjectArrayOfIntegerBooleanOrString = true;
        }
        return isObjectArrayOfIntegerBooleanOrString;
    }

    protected StringBuffer padString(String text, int requiredLength) {
        return this.padString(text, requiredLength, ' ');
    }

    protected StringBuffer padString(String text, int requiredLength, char fillChar) {
        StringBuffer str = new StringBuffer(text);
        int strLength = str.length();
        if (requiredLength > 0 && requiredLength > strLength) {
            for (int i = strLength; i < requiredLength; ++i) {
                str.append(fillChar);
            }
        }
        return str;
    }

    public void restoreConfigurationReport(boolean nlhFileExists, StringBuffer reportAttribute) {
        logger.traceEnter(THIS_CLASS, "restoreConfigurationReport()");
        try {
            File tmpFile = this.createRestoreReportFile();
            FileHelper.copyFile(tmpFile, this.reportFile);
            String firstPartOfReportFile = FileHelper.getInitialFileContents(this.reportFile, 65000L);
            if (!nlhFileExists && reportAttribute.length() > 0 && firstPartOfReportFile.indexOf(reportAttribute.toString()) == -1) {
                this.recreateFromAttribute(reportAttribute);
            } else {
                this.recreateFromFile(firstPartOfReportFile);
            }
            tmpFile.delete();
        }
        catch (FileNotFoundException fnfe) {
            logger.traceDebug(THIS_CLASS, "No old report file found for recovery.");
        }
        catch (IOException ioe) {
            logger.traceDebug(THIS_CLASS, "Could not open any old report file for recovery. Original exception: " + ioe.getLocalizedMessage());
        }
        catch (MoAccessException mae) {
            logger.traceAbnormal(THIS_CLASS, "Generic problem when trying to recover old report file. Original exception: " + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "restoreConfigurationReport()");
    }

    private void createBackupFile() throws IOException {
        String filePath = this.reportFile.getParent() + File.separator + this.reportFile.getName() + "_" + this.getFileTimeStamp() + "_" + ".crbak";
        FileHelper.copyFile(this.reportFile, new File(filePath));
    }

    private void recreateFromAttribute(StringBuffer reportAttribute) throws IOException {
        logger.traceEnter(THIS_CLASS, "recreateFromAttribute()");
        this.createBackupFile();
        FileHelper.writeToFile(this.reportFile.getAbsolutePath(), reportAttribute.toString(), false);
        this.removeOldBackupFiles(false);
        if (this.callback != null) {
            this.callback.updateAttribute(reportAttribute);
        }
        String logString = "Report file is old or not complete. Report file backup created and then recreated with contents of attribute.";
        logger.traceDebug(THIS_CLASS, "Report file is old or not complete. Report file backup created and then recreated with contents of attribute.");
        logger.traceReturn(THIS_CLASS, "recreateFromAttribute()");
    }

    public void removeOldBackupFiles(boolean cleanUpAction) {
        logger.traceEnter(THIS_CLASS, "removeOldBackupFiles()");
        List backupFiles = FileHelper.getFilesOfType(this.reportFile.getParentFile(), ".crbak", 1);
        File[] files = new File[backupFiles.size()];
        int loopItCounter = 0;
        ListIterator myIterator = backupFiles.listIterator();
        while (myIterator.hasNext()) {
            File file;
            Object o = myIterator.next();
            if (!(o instanceof File)) continue;
            files[loopItCounter] = file = (File)o;
            ++loopItCounter;
            if (!cleanUpAction) continue;
            file.delete();
        }
        if (!cleanUpAction) {
            File[] sortedFiles = FileHelper.sortFilesByDate(files);
            logger.traceDebug(THIS_CLASS, "MAX_NUMBER_OF_BACKUP_FILES: " + this.maxNumberOfFiles + "Value is " + backupFiles.size());
            if (sortedFiles.length > this.maxNumberOfFiles) {
                int numberOfFilesToRemove = sortedFiles.length - this.maxNumberOfFiles;
                for (int loopCounter = 0; loopCounter < numberOfFilesToRemove; ++loopCounter) {
                    int index = sortedFiles.length - loopCounter - 1;
                    sortedFiles[index].delete();
                    logger.traceDebug(THIS_CLASS, " Backup file " + sortedFiles[index].getAbsolutePath() + " has been deleted ");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "removeOldBackupFiles()");
    }

    private void recreateFromFile(String firstPartOfReportFile) throws MoAccessException, IOException {
        if (firstPartOfReportFile.length() >= 65000) {
            StringBuffer exceededMessage = new StringBuffer().append("......").append(NEW_LINE).append(this.getTimeStamp()).append(" : Configuration report too long. New log entries written to file (").append(this.reportFile.getAbsolutePath()).append(") only.");
            int length = 65000 - exceededMessage.length() - 1;
            StringBuffer fullReport = new StringBuffer().append(firstPartOfReportFile.substring(0, length)).append(exceededMessage);
            if (this.callback != null) {
                this.callback.updateAttribute(fullReport);
            }
            this.attributeFull = true;
        } else if (this.callback != null) {
            this.callback.updateAttribute(new StringBuffer(firstPartOfReportFile));
        }
    }

    private File createRestoreReportFile() {
        File tmpFile = new File(this.reportFile.getAbsoluteFile() + ".restore");
        if (tmpFile.exists()) {
            File newFile = new File(tmpFile.getParent(), tmpFile.getName() + "_" + this.getFileTimeStamp());
            boolean successful = tmpFile.renameTo(newFile);
            if (successful) {
                logger.traceAbnormal(THIS_CLASS, "File " + tmpFile.toString() + " should not exist. Renaming file to: " + newFile.getPath());
            } else {
                logger.traceAbnormal(THIS_CLASS, "File " + tmpFile.toString() + " should not exist. Failed to rename file.");
            }
        }
        this.reportFile.renameTo(tmpFile);
        this.reportFile.delete();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogEntry(StringBuffer logEntry) {
        this.filterLogEntry(logEntry);
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            if (null != logEntry) {
                this.reportBuffer.append(logEntry);
            }
        }
    }

    protected void filterLogEntry(StringBuffer logEntry) {
        String[] illegalCharacters = new String[]{"\u00a4", "|", "^", "'"};
        if (logEntry.indexOf("couldn't") != -1) {
            // empty if block
        }
        for (int i = 0; i < illegalCharacters.length; ++i) {
            if (logEntry.indexOf(illegalCharacters[i]) == -1) continue;
            StringHelper.removeString(logEntry, illegalCharacters[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLogEntryBufferToFile() {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            MUTEX_OBJECT.notifyAll();
        }
    }

    public void init(ConfigurationReportLoggerObserver mycallback, File file) {
        this.reportBuffer = new StringBuffer();
        this.callback = mycallback;
        this.attributeFull = false;
        this.reportFile = file;
        logger.traceReturn(THIS_CLASS, "init(rbsConfiguration)");
        this.logEntryWriter = new LogEntryWriter();
        this.logEntryWriter.start();
    }

    public StringBuffer checkSizeOfConfigurationReportAttribute(StringBuffer dataAttribute) {
        int deltaSize = dataAttribute.length() - 65000;
        if (deltaSize >= 0) {
            String textToDisplay = new String(this.getTimeStamp() + "... Configuration report too long, max size limit reached entries must be removed, please see file for full log: " + this.getReportFile().getAbsolutePath() + NEW_LINE);
            logger.traceDebug(THIS_CLASS, textToDisplay);
            dataAttribute.delete(0, deltaSize + textToDisplay.length());
            dataAttribute.insert(0, textToDisplay);
            this.attributeFull = true;
            return dataAttribute;
        }
        this.attributeFull = false;
        return dataAttribute;
    }

    public String getDefaultConfigurationReportPath() {
        String pathfilename = null;
        String propertyLogFileDir = System.getProperty("configReport.path");
        String unitTestString = System.getProperty("UNIT_TEST", "false");
        if (this.reportFile == null) {
            if ("true".equalsIgnoreCase(unitTestString)) {
                if (propertyLogFileDir == null) {
                    String dirName = System.getProperty("user.home") + File.separator + System.currentTimeMillis() + File.separator;
                    pathfilename = dirName + "configurationReport.log";
                } else {
                    pathfilename = propertyLogFileDir;
                }
            } else {
                pathfilename = "/c/logfiles/autointegration" + File.separator + "configurationReport.log";
            }
        } else {
            return this.reportFile.getAbsolutePath();
        }
        return pathfilename;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LogEntryWriter
    extends Thread {
        private volatile boolean keepRunning = true;

        public LogEntryWriter() {
            super(ConfigurationReportLoggerImpl.THREAD_NAME);
        }

        public void stopIt() {
            this.keepRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringBuffer copiedReportBuffer = new StringBuffer();
            while (this.keepRunning) {
                try {
                    Object object = MUTEX_OBJECT;
                    synchronized (object) {
                        MUTEX_OBJECT.wait(2000L);
                        copiedReportBuffer.append(ConfigurationReportLoggerImpl.this.reportBuffer);
                        ConfigurationReportLoggerImpl.this.reportBuffer.setLength(0);
                    }
                    int length = copiedReportBuffer.length();
                    if (length <= 0) continue;
                    if (ConfigurationReportLoggerImpl.this.reportFile != null) {
                        if (FileHelper.getFileSize(ConfigurationReportLoggerImpl.this.reportFile) < ConfigurationReportLoggerImpl.this.maxCrFileSizeBytes) {
                            FileHelper.writeToFile(ConfigurationReportLoggerImpl.this.reportFile.getAbsolutePath(), copiedReportBuffer.toString(), ConfigurationReportLoggerImpl.this.reportFile.exists());
                        } else {
                            ConfigurationReportLoggerImpl.this.createBackupFile();
                            FileHelper.writeToFile(ConfigurationReportLoggerImpl.this.reportFile.getAbsolutePath(), copiedReportBuffer.toString(), false);
                            ConfigurationReportLoggerImpl.this.removeOldBackupFiles(false);
                        }
                    }
                    if (ConfigurationReportLoggerImpl.this.callback != null && !ConfigurationReportLoggerImpl.this.attributeFull) {
                        ConfigurationReportLoggerImpl.this.callback.updateAttribute(copiedReportBuffer);
                    }
                    copiedReportBuffer.setLength(0);
                    Object object2 = MUTEX_OBJECT;
                    synchronized (object2) {
                        MUTEX_OBJECT.notifyAll();
                    }
                }
                catch (Exception e) {
                    logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason("Failed to write buffered log entries", e));
                }
            }
        }
    }
}

