/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.ChildMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.indications.MaoFroAlarmObject;

class MoMetaDataImpl
implements MoMetaData {
    private final String name;
    private String froPvVersion;
    private String froType;
    private String productInventory = "NO_PI";
    private String serviceName = "NO_SERVICE";
    private int swRevision;
    private boolean implementedAsGenericMAO = false;
    private final Map attributes;
    private Map alarms;
    private final boolean systemCreated;
    private boolean hasMultipleParents = false;
    private boolean partlySystemCreated = false;
    private Struct replacedBy;
    private Struct replacing;
    private final Map domainSpecificMap = new HashMap();

    public MoMetaDataImpl(String name, Map attributes, boolean systemCreated, Struct replacedBy) {
        this.name = name;
        this.attributes = attributes;
        this.systemCreated = systemCreated;
        this.alarms = new HashMap();
        this.replacedBy = replacedBy;
    }

    public int getAbsoluteCardinality(MoMetaDataFinder aFinder) throws MoAccessException, IOException {
        int maxCardinality = 0;
        List childMetaDataList = this.getChildMetaData(aFinder);
        Iterator childIter = childMetaDataList.iterator();
        while (childIter.hasNext()) {
            ChildMetaData currentChild = (ChildMetaData)childIter.next();
            if (!currentChild.getName().equals(this.name)) continue;
            int cardinality = currentChild.getMaxCardinality();
            int parentCardinality = 1;
            String parentName = currentChild.getParentName();
            if (this.isGoamType(parentName, aFinder)) {
                MoMetaData parentMetaData = aFinder.getMoData(parentName);
                parentCardinality = parentMetaData.getAbsoluteCardinality(aFinder);
            }
            cardinality = parentCardinality * cardinality;
            maxCardinality += cardinality;
        }
        return maxCardinality;
    }

    public int getAbsoluteCardinalityPerParent(String parent, MoMetaDataFinder aFinder) throws MoAccessException, IOException {
        int maxCardinality = 0;
        List childMetaDataList = this.getChildMetaData(aFinder);
        Iterator childIter = childMetaDataList.iterator();
        while (childIter.hasNext()) {
            ChildMetaData currentChild = (ChildMetaData)childIter.next();
            if (!currentChild.getName().equals(this.name) || !currentChild.getParentName().equals(parent)) continue;
            int cardinality = currentChild.getMaxCardinality();
            int parentCardinality = 1;
            String parentName = currentChild.getParentName();
            if (this.isGoamType(parentName, aFinder)) {
                MoMetaData parentMetaData = aFinder.getMoData(parentName);
                parentCardinality = parentMetaData.getAbsoluteCardinality(aFinder);
            }
            cardinality = parentCardinality * cardinality;
            maxCardinality += cardinality;
        }
        return maxCardinality;
    }

    private boolean isGoamType(String moName, MoMetaDataFinder aFinder) {
        MoMetaData moMetaData = (MoMetaData)aFinder.getMoMap().get(moName);
        return moMetaData != null && moMetaData.isImplementedAsGenericMAO();
    }

    public MaoFroAlarmObject getAlarm(int faultId) {
        return (MaoFroAlarmObject)this.alarms.get(new Integer(faultId));
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List getChildMetaData(MoMetaDataFinder aFinder) throws MoAccessException {
        return aFinder.getChildMetaData(this.name);
    }

    public String getFroProtocolVersion() {
        return this.froPvVersion;
    }

    public String getFroType() {
        return this.froType;
    }

    public int getMaxCardinality(String parentType, MoMetaDataFinder aFinder) throws MoAccessException {
        int maxCardinality = -1;
        List childMetaDataList = this.getChildMetaData(aFinder);
        Iterator childIter = childMetaDataList.iterator();
        while (childIter.hasNext()) {
            ChildMetaData currentChild = (ChildMetaData)childIter.next();
            if (!currentChild.getParentName().equals(parentType)) continue;
            maxCardinality = currentChild.getMaxCardinality();
            break;
        }
        return maxCardinality;
    }

    public String getName() {
        return this.name;
    }

    public String getPiType() {
        return this.productInventory;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getSwRevision() {
        return this.swRevision;
    }

    public Struct getReplacedBy() {
        return this.replacedBy;
    }

    public Struct getReplacing() {
        return this.replacing;
    }

    public String getDomainSpecific(String domainName) {
        return (String)this.domainSpecificMap.get(domainName);
    }

    public boolean isHasMultipleParents() {
        return this.hasMultipleParents;
    }

    public boolean isImplementedAsGenericMAO() {
        return this.implementedAsGenericMAO;
    }

    public boolean isPartlySystemCreated() {
        return this.partlySystemCreated;
    }

    public boolean isSystemCreated() {
        return this.systemCreated;
    }

    public void setAlarmMap(Map alarmMap) {
        this.alarms = alarmMap;
    }

    public void setFroProtocolVersion(String pvVersion) {
        this.froPvVersion = pvVersion;
    }

    public void setFroType(String froType) {
        this.froType = froType;
    }

    public void setHasMultipleParents(boolean newVal) {
        this.hasMultipleParents = newVal;
    }

    public void setImplementedAsGenericMAO(boolean newVal) {
        this.implementedAsGenericMAO = newVal;
    }

    public void setPartlySystemCreated(boolean newVal) {
        this.partlySystemCreated = newVal;
    }

    public void setPiType(String productInventory) {
        if (productInventory != null) {
            this.productInventory = productInventory;
        }
    }

    public void setServiceName(String serviceName) {
        if (serviceName != null) {
            this.serviceName = serviceName;
        }
    }

    public void setSwRevision(int swRev) {
        this.swRevision = swRev;
    }

    public void setReplacedBy(Struct replacedBy) {
        this.replacedBy = replacedBy;
    }

    public void setReplacing(Struct replacing) {
        this.replacing = replacing;
    }

    public void storeNonMomAttribute(String theName, AttributeMetaData metaData) {
        this.attributes.put(theName, metaData);
    }

    public void storeDomainSpecific(String doaminName, String doaminSpecific) {
        this.domainSpecificMap.put(doaminName, doaminSpecific);
    }

    public void addAlarmMap(Map alarmMap) {
        if (this.alarms == null) {
            this.setAlarmMap(alarmMap);
        } else {
            this.alarms.putAll(alarmMap);
        }
    }
}

