/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.types;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StructMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AbstractAttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeVisitor;

public class StructRefType
extends AbstractAttributeDataType {
    private final String refStructName;

    public StructRefType(String refStruct, String moType, String attributeName) {
        this.refStructName = refStruct;
        this.javaReturnType = "struct";
        this.froDataType = "STRUCT";
        this.moType = moType;
        this.attributeName = attributeName;
    }

    public void accept(AttributeVisitor visitor, String attribName, Object attribValue, boolean isMandatory) throws MoAccessException {
        visitor.visitStructRef(attribName, attribValue, isMandatory, this);
    }

    public Object getDefaultValue(MoMetaDataFinder aFinder) throws MoAccessException {
        StructImpl defaultValueAsStructImpl = null;
        Map structs = aFinder.getStructmap();
        Object[] structMembers = ((StructMetaData)structs.get(this.refStructName)).getMembers().values().toArray();
        String[] attribNames = ((StructMetaData)structs.get(this.refStructName)).getMemberNames();
        Object[] attribValues = new Object[structMembers.length];
        for (int i = 0; i < structMembers.length; ++i) {
            attribValues[i] = ((AttributeDataType)structMembers[i]).getDefaultValue(aFinder);
        }
        defaultValueAsStructImpl = new StructImpl(attribNames, attribValues);
        return defaultValueAsStructImpl;
    }

    public String getReferencedStruct() {
        return this.refStructName;
    }

    public AttributeDataType[] getStructMembers(MoMetaDataFinder aFinder) throws IOException {
        Map structs = aFinder.getStructmap();
        Collection members = ((StructMetaData)structs.get(this.refStructName)).getMembers().values();
        AttributeDataType[] structMembers = members.toArray(new AttributeDataType[members.size()]);
        return structMembers;
    }
}

