/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Resource2;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.mo.LdnProvider;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionManager;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionManagerFactory;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionManagerFactory2;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.genericmo.AlarmClassificationType;
import se.ericsson.crbs.omf.mao.genericmo.AlarmClassificationTypeImpl;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMao;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.AttributeManager;
import se.ericsson.crbs.omf.mao.indications.IndicationHandler;
import se.ericsson.crbs.omf.mao.indications.MaoFroAlarmObject;
import se.ericsson.crbs.omf.mao.indications.NotificationHandler;
import se.ericsson.crbs.omf.mao.indications.ServiceHandler;
import se.ericsson.crbs.omf.mao.pi.CrbsHardwareProductData;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class GenericMaoHelperImpl
implements GenericMaoHelper {
    private static AbstractLogger logger = LoggingService.getLogger(GenericMaoHelperImpl.class.getName());
    private static final Class THIS_CLASS = GenericMaoHelperImpl.class;
    private String moType = null;
    private GenericMaoContext genericMaoContext = null;
    private AttributeManager attributeManager = null;
    private TransactionManager transactionManager = null;
    private GenericMao genericMao = null;
    private MoValidator moValidator;
    private IndicationHandler indicationSubscriber = null;
    private CrbsHardwareProductData crbsHardwareProductData = null;

    public void init(ManagedObject parent, AttrList attributes, String identity, String moType, GenericMaoContext genericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext, GenericMao genericMao) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "init(): create constructor for " + moType);
        this.moType = moType;
        this.genericMaoContext = genericMaoContext;
        this.genericMao = genericMao;
        this.attributeManager = genericMaoContext.getAttributeManagerFactory().createAttributeManager(genericMao, this.getIndicationSubscriber(), genericMaoContext);
        this.instanciateTransactionManager();
        this.registerGenericMaoInTransaction(coordinator);
        this.moValidator = genericMaoContext.getMoValidator();
        this.attributeManager.createMo(attributes, softwareRevision, parent, genericMao, false, coordinator);
        this.preCreateValidation(attributes, coordinator);
        this.postCreate(attributes, coordinator);
        this.registerLdn(coordinator);
        this.registerServiceHandler(coordinator);
        this.registerIndications();
        this.registerPi(moType, coordinator);
        this.handleTransactionWrite(coordinator);
        if (this.replacesAnotherMO()) {
            String replacedMoName = DeprecatedGenericMaoHelper.getReplacedMoName(moType, genericMaoContext);
            new DeprecatedGenericMao(parent, identity, replacedMoName, genericMaoContext, coordinator, initialmaocontext);
        }
        logger.traceReturn(THIS_CLASS, "init(): create constructor for " + moType);
    }

    public void init(ManagedObject parent, String identity, String moType, GenericMaoContext genericMaoContext, Coordinator coordinator, InitialMaoContext initialmaocontext, GenericMao genericMao) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "init(): create constructor for DeprecatedGenericMao for " + moType);
        this.moType = moType;
        this.genericMaoContext = genericMaoContext;
        this.genericMao = genericMao;
        this.attributeManager = genericMaoContext.getAttributeManagerFactory().createAttributeManager(genericMao, this.getIndicationSubscriber(), genericMaoContext);
        this.instanciateTransactionManager();
        this.registerGenericMaoInTransaction(coordinator);
        this.moValidator = null;
        this.attributeManager.createMo(new AttrListImpl(genericMaoContext.getMoRepositoryWrapper()), new Integer(0), parent, genericMao, true, coordinator);
        this.handleTransactionWrite(coordinator);
        logger.traceReturn(THIS_CLASS, "init(): create constructor for DeprecatedGenericMao for " + moType);
    }

    public void init(MoDataWrapper recoveredData, String moType, GenericMaoContext genericMaoContext, InitialMaoContext initialmaocontext, GenericMao genericMao) throws MoNameAlreadyTakenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "init(): recovery constructor for " + moType);
        this.moType = moType;
        this.genericMaoContext = genericMaoContext;
        this.genericMao = genericMao;
        this.attributeManager = genericMaoContext.getAttributeManagerFactory().createAttributeManager(genericMao, this.getIndicationSubscriber(), genericMaoContext);
        this.instanciateTransactionManager();
        this.moValidator = genericMaoContext.getMoValidator();
        this.attributeManager.recover(recoveredData);
        this.postRecover();
        logger.traceReturn(THIS_CLASS, "init(): recovery constructor for " + moType);
    }

    private void instanciateTransactionManager() {
        TransactionManagerFactory transactionManagerFactory = this.genericMaoContext.getTransactionManagerFactory();
        this.transactionManager = this.genericMao instanceof Resource2 && transactionManagerFactory instanceof TransactionManagerFactory2 ? ((TransactionManagerFactory2)transactionManagerFactory).createTransactionManager(this.genericMao, this.genericMao.getType()) : transactionManagerFactory.createTransactionManager(this.genericMao, this.genericMao.getType());
    }

    public boolean replacesAnotherMO() {
        boolean replacesAnotherMo = false;
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.moType);
        Struct replacingValue = moMetaData.getReplacing();
        if (replacingValue != null) {
            replacesAnotherMo = true;
        }
        return replacesAnotherMo;
    }

    public void registerLdn(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        LdnProvider ldnProvider;
        if (this.getFroId(coordinator) != -1 && (ldnProvider = (LdnProvider)ServiceLocatorFacade.getRepository().getService(LdnProvider.class)) != null) {
            ldnProvider.registerLdn(this.getFroType(), this.getFroId(coordinator), this.genericMao.getLocalDistinguishedName());
        }
    }

    private void deregisterLdn(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        LdnProvider ldnProvider;
        if (this.getFroId(coordinator) != -1 && (ldnProvider = (LdnProvider)ServiceLocatorFacade.getRepository().getService(LdnProvider.class)) != null) {
            ldnProvider.deregisterLdn(this.getFroType(), this.getFroId(coordinator));
        }
    }

    public AttrList addFroParametersAtCreate(AttrList signalParameters, AttrList clientProvidedParameters, Coordinator coordinator) throws MoAccessException {
        return this.genericMao.addFroParametersAtCreate(signalParameters, clientProvidedParameters, coordinator);
    }

    public final Object getAdditionalAttribute(String attributeName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAdditionalAttribute(" + attributeName + ") - " + this.moType);
        Object res = this.attributeManager.getAdditionalAttribute(attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "getAdditionalAttribute(" + attributeName + ") - " + this.moType);
        return res;
    }

    public Map addFroParametersAtSet(Map attributes, Map attributeNameValuePairs, Coordinator coordinator) throws MoAccessException {
        return this.genericMao.addFroParametersAtSet(attributes, attributeNameValuePairs, coordinator);
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete() - " + this.genericMao.getLocalDistinguishedName());
        this.handleTransactionWrite(coordinator);
        try {
            this.moValidator.verifyAtDelete(false, this.genericMao);
            this.preDelete(coordinator);
            if (this.indicationSubscriber != null) {
                this.indicationSubscriber.ceaseAllAlarms(coordinator);
            }
            this.registerGenericMaoInTransaction(coordinator);
            this.deleteMo(coordinator);
            this.deregisterServiceHandler(coordinator);
            this.deregisterIndications("deleting mo.");
            this.deregisterLdn(coordinator);
            this.deregisterPi(this.crbsHardwareProductData, coordinator);
            if (this.replacesAnotherMO()) {
                DeprecatedGenericMao replacedMo = (DeprecatedGenericMao)DeprecatedGenericMaoHelper.lookupReplacedMo(this.moType, this.genericMao.getNamingAttributeValue(), this.genericMao.getLocalDistinguishedName(), this.genericMao.getParent().getLocalDistinguishedName(), this.genericMaoContext);
                replacedMo.deprecatedDelete(coordinator);
            }
            logger.traceDebug(THIS_CLASS, "Deletion complete");
        }
        catch (ProcessingFailureException proEx) {
            String info = "Managed Object " + this.genericMao.getType() + " cannot be deleted by calling delete(): " + proEx.getVariablesAsString();
            logger.info(this.getClass(), info);
            this.transactionManager.markRollBackOnly(coordinator);
            throw new UndeletableMoException((ManagedObject)this.genericMao, info);
        }
        catch (MoAccessException e) {
            this.transactionManager.markRollBackOnly(coordinator);
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "delete() - " + this.moType);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        this.handleTransactionWrite(coordinator);
        this.attributeManager.deleteMo(null, false, coordinator);
        this.postDelete(coordinator);
    }

    public void delete(AttrList attrList, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete() - " + this.genericMao.getLocalDistinguishedName());
        this.handleTransactionWrite(coordinator);
        try {
            this.moValidator.verifyAtDelete(false, this.genericMao);
            this.preDelete(coordinator);
            if (this.indicationSubscriber != null) {
                this.indicationSubscriber.ceaseAllAlarms(coordinator);
            }
            this.registerGenericMaoInTransaction(coordinator);
            AttrListImpl attrListOut = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
            for (int i = 0; i < attrList.size(); ++i) {
                if (Definitions.isTransparentData(attrList.getName(i))) {
                    try {
                        attrListOut.addAttribute(attrList.getName(i), attrList.getValue(i));
                        continue;
                    }
                    catch (NotHandledAttributeTypeException e) {
                        logger.traceError(THIS_CLASS, "Exception when trying to get value for pnpTranspData", e);
                        throw new ProcessingFailureException("Exception when trying to get value for pnpTranspData");
                    }
                    catch (MoNotFoundException e) {
                        logger.traceError(THIS_CLASS, "Exception when trying to get value for pnpTranspData", e);
                        throw e;
                    }
                }
                logger.traceAbnormal(THIS_CLASS, "Attribute: " + attrList.getName(i) + " is not allowed. Only attribute pnpTranspData is allowed to be sent in delete. Delete is now performed without the attribute.");
            }
            if (attrListOut.size() < 1) {
                this.attributeManager.delete(coordinator);
            } else {
                this.attributeManager.deleteMo(attrList, false, coordinator);
            }
            this.postDelete(coordinator);
            this.deregisterServiceHandler(coordinator);
            this.deregisterIndications("deleting mo.");
            this.deregisterLdn(coordinator);
            this.deregisterPi(this.crbsHardwareProductData, coordinator);
            logger.traceDebug(THIS_CLASS, "Deletion complete");
        }
        catch (ProcessingFailureException proEx) {
            String info = "Managed Object " + this.genericMao.getType() + " cannot be deleted by calling delete(): " + proEx.getVariablesAsString();
            logger.info(this.getClass(), info);
            this.transactionManager.markRollBackOnly(coordinator);
            throw new UndeletableMoException((ManagedObject)this.genericMao, info);
        }
        catch (MoAccessException e) {
            this.transactionManager.markRollBackOnly(coordinator);
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "delete() - " + this.moType);
    }

    public final void deleteAdditionalAttribute(String attributeName, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.moType);
        this.attributeManager.deleteAdditionalAttribute(attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.moType);
    }

    public void deleteInternal(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "deleteInternal() - " + this.genericMao.getLocalDistinguishedName());
        this.handleTransactionWrite(coordinator);
        try {
            this.moValidator.verifyAtDelete(true, this.genericMao);
        }
        catch (ProcessingFailureException proEx) {
            String info = "Managed Object " + this.genericMao.getType() + " cannot be deleted by calling deleteInternal(): " + proEx.getMessage();
            logger.info(this.getClass(), info);
            this.transactionManager.markRollBackOnly(coordinator);
            throw new UndeletableMoException((ManagedObject)this.genericMao, info);
        }
        this.preDelete(coordinator);
        if (this.indicationSubscriber != null) {
            this.indicationSubscriber.ceaseAllAlarms(coordinator);
        }
        try {
            this.registerGenericMaoInTransaction(coordinator);
            AttrList attributes = null;
            this.attributeManager.deleteMo(attributes, false, coordinator);
            this.postDelete(coordinator);
            this.deregisterLdn(coordinator);
            this.deregisterPi(this.crbsHardwareProductData, coordinator);
            this.deregisterServiceHandler(coordinator);
            this.deregisterIndications("deleting mo.");
            if (this.replacesAnotherMO()) {
                DeprecatedGenericMao replacedMo = (DeprecatedGenericMao)DeprecatedGenericMaoHelper.lookupReplacedMo(this.moType, this.genericMao.getNamingAttributeValue(), this.genericMao.getLocalDistinguishedName(), this.genericMao.getParent().getLocalDistinguishedName(), this.genericMaoContext);
                replacedMo.deprecatedDelete(coordinator);
            }
        }
        catch (MoAccessException e) {
            this.transactionManager.markRollBackOnly(coordinator);
            String msg = "Managed Object " + this.genericMao.getType() + " could not be deleted! " + e.getMessage();
            logger.traceError(this.getClass(), msg);
        }
        logger.traceReturn(THIS_CLASS, "deleteInternal() - " + this.moType);
    }

    private final void deregisterIndications(String operation) {
        logger.traceEnter(THIS_CLASS, "deregisterIndications() - " + this.moType);
        NotificationHandler nHandler = this.genericMaoContext.getNotificationHandlerFactory().getNotificationHandler(this.getServiceName(), this.getFroType());
        try {
            nHandler.deregisterForNotifications(this.transactionManager.getCoordinator(), this.getFroId(null));
        }
        catch (TransactionRequiredException e) {
            logger.traceError(this.getClass(), "Could not unregister for notifications when " + operation, e);
        }
        catch (MoAccessException e) {
            logger.traceError(this.getClass(), "Could not unregister for notifications when " + operation, e);
        }
        catch (NullPointerException ex) {
            String msg = "Program error when deregistering from notification handler! " + ex.getMessage();
            logger.traceError(this.getClass(), msg, ex);
        }
        logger.traceReturn(THIS_CLASS, "deregisterIndications() - " + this.moType);
    }

    private final void deregisterServiceHandler(Coordinator coordinator) throws TransactionRequiredException {
        logger.traceEnter(THIS_CLASS, "deregisterServiceHandler() - " + this.moType);
        ServiceHandler handler = this.genericMaoContext.getServiceHandlerFactory().getServiceHandler(this.getServiceName());
        handler.removeListener(this.genericMao, coordinator);
        logger.traceReturn(THIS_CLASS, "deregisterServiceHandler() - " + this.moType);
    }

    public final Map filterPmCounters(Coordinator coordinator) throws MoAccessException {
        String tempAttrName;
        logger.traceEnter(THIS_CLASS, "filterPmCounters(): " + this.moType);
        Map allMoAttributes = this.genericMaoContext.getMoMetaDataFinder().getMoAttributes(this.moType);
        Iterator iterator = allMoAttributes.keySet().iterator();
        String[] attrNames = new String[allMoAttributes.size()];
        int mapIndex = 0;
        int mapIndex2 = 0;
        while (iterator.hasNext()) {
            tempAttrName = (String)iterator.next();
            if (tempAttrName.startsWith("pm")) continue;
            attrNames[mapIndex] = tempAttrName;
            ++mapIndex;
        }
        String[] attrNamesWithoutCounters = new String[mapIndex];
        for (int i = 0; i < mapIndex; ++i) {
            attrNamesWithoutCounters[mapIndex2] = tempAttrName = attrNames[i];
            logger.traceDebug(THIS_CLASS, "filterPmCounters(): " + tempAttrName + " added to the list of attributes to be checked");
            ++mapIndex2;
        }
        Object[] attrValues = this.getAttributes(attrNamesWithoutCounters, coordinator);
        HashMap<String, Object> tmpAttrValues = new HashMap<String, Object>();
        for (int arrayIndex = 0; arrayIndex < attrNamesWithoutCounters.length; ++arrayIndex) {
            tmpAttrValues.put(attrNames[arrayIndex], attrValues[arrayIndex]);
        }
        logger.traceReturn(THIS_CLASS, "filterPmCounters(): " + this.moType + ": " + tmpAttrValues);
        return tmpAttrValues;
    }

    public final Object getAttribute(String attrName, boolean clearCache, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getAttribute(" + attrName + ", " + clearCache + ", " + coordinator + ") - " + this.moType);
        Object result = null;
        if (clearCache) {
            this.attributeManager.clear();
        }
        result = attrName.equalsIgnoreCase(this.genericMao.getType() + "Id") ? this.genericMao.getNamingAttributeValue() : this.getMoAttribute(attrName, coordinator);
        logger.traceReturn(THIS_CLASS, "getAttribute(" + attrName + ", " + clearCache + ", " + coordinator + ") " + this.moType);
        return result;
    }

    public final Object[] getAttributes(String[] attrNames, boolean clearCache, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        String attrNamesToString = StringHelper.objToString(attrNames);
        logger.traceEnter(THIS_CLASS, "getAttributes(" + attrNamesToString + ", " + clearCache + ", " + coordinator + ") - " + this.moType);
        Object[] result = null;
        String[] moAttrNames = this.removeNamingElements(attrNames);
        Object[] moAttrValues = this.getMoAttributes(moAttrNames, coordinator);
        result = moAttrNames.length == attrNames.length ? moAttrValues : this.addNamingElementValues(attrNames, moAttrValues);
        logger.traceReturn(THIS_CLASS, "getAttributes(" + attrNamesToString + ", " + clearCache + ", " + coordinator + ") - " + this.moType);
        return result;
    }

    private Object[] addNamingElementValues(String[] attrNames, Object[] moAttrValues) {
        ArrayList<Object> result = new ArrayList<Object>();
        int j = 0;
        for (int i = 0; i < attrNames.length; ++i) {
            if (attrNames[i].equalsIgnoreCase(this.genericMao.getType() + "Id")) {
                result.add(this.genericMao.getNamingAttributeValue());
                continue;
            }
            result.add(moAttrValues[j++]);
        }
        return result.toArray(new Object[result.size()]);
    }

    private String[] removeNamingElements(String[] elementNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < elementNames.length; ++i) {
            if (elementNames[i].equalsIgnoreCase(this.genericMao.getType() + "Id")) continue;
            result.add(elementNames[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object getAttribute(String attrName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getAttribute(" + attrName + ") - " + this.moType);
        Object res = null;
        this.handleTransactionRead(coordinator);
        res = this.getAttribute(attrName, true, coordinator);
        logger.traceReturn(THIS_CLASS, "getAttribute(" + attrName + ") - " + this.moType);
        return res;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator context) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes() - " + this.moType);
        this.handleTransactionRead(context);
        this.attributeManager.clear();
        logger.traceReturn(THIS_CLASS, "getAttributes() - " + this.moType);
        return this.getAttributes(attrNames, false, context);
    }

    public void preGetAttributes(String[] attrNames, Coordinator context) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preGetAttributes(): " + this.moType);
        StringBuffer arrBuf = new StringBuffer();
        for (int i = 0; i < attrNames.length; ++i) {
            if (i != 0) {
                arrBuf.append(',');
            }
            arrBuf.append(attrNames[i]);
        }
        logger.traceDebug(THIS_CLASS, "preGetAttributes(): " + arrBuf.toString());
        this.handleTransactionRead(context);
        this.attributeManager.clear();
        logger.traceReturn(THIS_CLASS, "preGetAttributes():" + this.moType);
    }

    public final int getFroId(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        if (this.attributeManager == null) {
            logger.traceError(THIS_CLASS, "HW87853 : getFroId(): attributeManager == null, moType = " + this.moType);
        }
        logger.traceEnter(THIS_CLASS, "getFroId() - " + this.moType);
        int result = -1;
        logger.traceDebug(THIS_CLASS, "Getting FRO Id");
        this.handleTransactionRead(coordinator);
        result = this.attributeManager.getFroId(coordinator);
        logger.traceReturn(THIS_CLASS, "getFroId() - " + this.moType + " = " + result);
        return result;
    }

    public final int getFroType() {
        logger.traceEnter(THIS_CLASS, "getFroType() - " + this.moType);
        int froType = -1;
        MoMetaData moData = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.moType);
        String froTypeStr = moData.getFroType();
        if (froTypeStr != null) {
            froType = Integer.parseInt(froTypeStr, 16);
        }
        logger.traceReturn(THIS_CLASS, "getFroType() - " + this.moType + " = " + froType);
        return froType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndicationHandler getIndicationSubscriber() {
        logger.traceEnter(THIS_CLASS, "getIndicationSubscriber() - " + this.moType);
        GenericMaoHelperImpl genericMaoHelperImpl = this;
        synchronized (genericMaoHelperImpl) {
            if (this.indicationSubscriber == null) {
                this.indicationSubscriber = this.genericMaoContext.getIndicationHandlerFactory().createIndicationHandler(this.genericMao, this.genericMaoContext);
            }
        }
        logger.traceReturn(THIS_CLASS, "getIndicationSubscriber() - " + this.moType);
        return this.indicationSubscriber;
    }

    public final Object getMoAttribute(String attributeName, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getMoAttribute(" + attributeName + ", " + coordinator + ") - " + this.moType);
        Object res = this.attributeManager.getAttribute(attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "getMoAttribute(" + attributeName + ", " + coordinator + ") - " + this.moType);
        return res;
    }

    private Object[] getMoAttributes(String[] attrNames, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        String attrNamesToString = StringHelper.objToString(attrNames);
        logger.traceEnter(THIS_CLASS, "getMoAttributes(" + attrNamesToString + ", " + coordinator + ") - " + this.moType);
        Object[] res = this.attributeManager.getAttributes(attrNames, coordinator);
        logger.traceReturn(THIS_CLASS, "getMoAttributes(" + attrNamesToString + ", " + coordinator + ") - " + this.moType);
        return res;
    }

    public final String getRdnId(Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getRdnId() - " + this.moType);
        this.handleTransactionRead(coordinator);
        String res = this.genericMao.getLocalDistinguishedName().substring(this.genericMao.getLocalDistinguishedName().lastIndexOf("=") + 1);
        logger.traceReturn(THIS_CLASS, "getRdnId() - " + this.moType + " = " + res);
        return res;
    }

    protected String getResultFromString(String exceptionVariables) {
        String searchString = "result\" = \"";
        int start = exceptionVariables.indexOf("result\" = \"") + "result\" = \"".length();
        int stop = exceptionVariables.indexOf(34, start);
        String result = exceptionVariables.substring(start, stop);
        return result;
    }

    public final String getServiceName() {
        logger.traceEnter(THIS_CLASS, "getServiceName() - " + this.moType);
        String serviceName = "NOT_FOUND";
        MoMetaData moData = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.moType);
        serviceName = moData.getServiceName();
        logger.traceReturn(THIS_CLASS, "getServiceName() - " + this.moType + " = " + serviceName);
        return serviceName;
    }

    public final void registerGenericMaoInTransaction(Coordinator coordinator) throws MoAccessException {
        this.transactionManager.registerAndCheckResource(coordinator);
    }

    public final void handleTransactionRead(Coordinator coordinator) throws TransactionRequiredException, NoPermissionException, ResourceLockedException {
        this.attributeManager.handleTransactionRead(coordinator);
    }

    public final void handleTransactionWrite(Coordinator coordinator) throws TransactionRequiredException, NoPermissionException, ResourceLockedException {
        this.attributeManager.handleTransactionWrite(coordinator);
    }

    public void parameterChanged(String attributeName, Object attributeValue) {
        this.genericMao.parameterChanged(attributeName, attributeValue);
    }

    public void preCreateValidation(AttrList attributes, Coordinator coordinator) throws MoAccessException {
        this.genericMao.preCreateValidation(attributes, coordinator);
    }

    public void postCreate(AttrList attributes, Coordinator coordinator) throws MoAccessException {
        this.genericMao.postCreate(attributes, coordinator);
    }

    public void postRecover() throws MoAccessException {
        this.genericMao.postRecover();
    }

    public void postDelete(Coordinator coordinator) throws MoAccessException {
        this.genericMao.postDelete(coordinator);
    }

    public void postSet(String attributeName, Object value, Coordinator coordinator) throws MoAccessException {
        this.genericMao.postSet(attributeName, value, coordinator);
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        this.genericMao.preDelete(coordinator);
    }

    public Object preSet(String attributeName, Map attributes, Object value, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        return value;
    }

    public final void registerServiceHandler(Coordinator coordinator) throws TransactionRequiredException {
        logger.traceEnter(THIS_CLASS, "registerServiceHandler()");
        ServiceHandler handler = this.genericMaoContext.getServiceHandlerFactory().getServiceHandler(this.getServiceName());
        handler.addListener(this.genericMao, coordinator);
        logger.traceReturn(THIS_CLASS, "registerServiceHandler()");
    }

    public final void registerIndications() throws MoAccessException, TransactionRequiredException {
        logger.traceEnter(THIS_CLASS, "registerIndications() - " + this.moType);
        NotificationHandler nHandler = this.genericMaoContext.getNotificationHandlerFactory().getNotificationHandler(this.getServiceName(), this.getFroType());
        nHandler.registerForNotifications(this.transactionManager.getCoordinator(), this.getIndicationSubscriber(), this.getFroId(null));
        logger.traceReturn(THIS_CLASS, "registerIndications() - " + this.moType);
    }

    public void release(ManagedObject moToRemove, Coordinator coordinator) throws TransactionRequiredException, MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "release(" + moToRemove.getLocalDistinguishedName() + ") - " + this.moType);
        this.handleTransactionWrite(coordinator);
        this.attributeManager.removeReservedBy(moToRemove, coordinator);
        logger.traceReturn(THIS_CLASS, "release(" + moToRemove.getLocalDistinguishedName() + ") - " + this.moType);
    }

    public void reserve(ManagedObject moToReference, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "reserve(" + moToReference.getLocalDistinguishedName() + ") - " + this.moType);
        this.handleTransactionWrite(coordinator);
        this.attributeManager.addReservedBy(moToReference, coordinator);
        logger.traceReturn(THIS_CLASS, "reserve(" + moToReference.getLocalDistinguishedName() + ") - " + this.moType);
    }

    public final Map sendActionWithCfm(String actionName, Coordinator coordinator, Map attributes) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "sendActionWithCfm(" + actionName + ") - " + this.moType);
        Map res = this.attributeManager.sendActionWithCfm(actionName, coordinator, attributes);
        logger.traceReturn(THIS_CLASS, "sendActionWithCfm(" + actionName + ") - " + this.moType);
        return res;
    }

    public final void sendActionWithoutCfm(String actionName, Coordinator coordinator, Map attributes) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "sendActionWithoutCfm(" + actionName + ") - " + this.moType);
        this.attributeManager.sendActionWithoutCfm(actionName, coordinator, attributes);
        logger.traceReturn(THIS_CLASS, "sendActionWithoutCfm(" + actionName + ") - " + this.moType);
    }

    public final void serviceAdded() {
    }

    public final void serviceRemoved() {
        logger.traceEnter(THIS_CLASS, "serviceRemoved() - " + this.moType);
        String serviceName = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.moType).getServiceName();
        logger.traceGeneral(THIS_CLASS, "serviceRemoved() from metadata serviceName=" + serviceName);
        if (serviceName != null) {
            this.getIndicationSubscriber().ceaseAllAlarms(serviceName);
        }
        logger.traceReturn(THIS_CLASS, "serviceRemoved() - " + this.moType);
    }

    public final void setAdditionalAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAdditionalAttribute(" + attributeName + ", " + attributeValue + ") - " + this.moType);
        this.handleTransactionWrite(coordinator);
        this.attributeManager.setAdditionalAttribute(attributeName, attributeValue, coordinator);
        logger.traceReturn(THIS_CLASS, "setAdditionalAttribute(" + attributeName + ", " + attributeValue + ") - " + this.moType);
    }

    public void setAttribute(String attrName, Object value, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(" + attrName + ") - " + this.moType);
        this.handleTransactionWrite(coord);
        HashMap<String, Object> moAttributeNameValuePairs = new HashMap<String, Object>();
        moAttributeNameValuePairs.put(attrName, value);
        boolean performValidation = true;
        this.setAttributes(moAttributeNameValuePairs, true, coord);
        logger.traceReturn(THIS_CLASS, "setAttribute(" + attrName + ") - " + this.moType);
    }

    public final void setAttributeWithoutValidation(String attrName, Object value, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributeWithoutValidation(" + attrName + ", " + value + ") - " + this.moType);
        this.handleTransactionWrite(coord);
        HashMap<String, Object> moAttributeNameValuePairs = new HashMap<String, Object>();
        moAttributeNameValuePairs.put(attrName, value);
        boolean performValidation = false;
        this.setAttributes(moAttributeNameValuePairs, false, coord);
        logger.traceReturn(THIS_CLASS, "setAttributeWithoutValidation(" + attrName + ", " + value + ") - " + this.moType);
    }

    private void setAttributes(Map attributeNameValuePairs, boolean performValidation, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes() - " + this.moType);
        boolean isSystemWriteableOnly = false;
        this.attributeManager.setAttributes(attributeNameValuePairs, false, performValidation, this.moValidator, coordinator);
        Iterator attributeIter = attributeNameValuePairs.entrySet().iterator();
        while (attributeIter.hasNext()) {
            Map.Entry entry = attributeIter.next();
            String currentAttributeName = (String)entry.getKey();
            Object currentAttributeValue = entry.getValue();
            this.postSet(currentAttributeName, currentAttributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttributes() - " + this.moType);
    }

    public void setAttributes(String[] attrNames, Object[] attrValues, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes() - " + this.moType);
        this.handleTransactionWrite(coord);
        HashMap<String, Object> attributeNameValuePairs = new HashMap<String, Object>();
        for (int i = 0; i < attrNames.length; ++i) {
            attributeNameValuePairs.put(attrNames[i], attrValues[i]);
        }
        boolean performValidation = true;
        if (attributeNameValuePairs.containsKey("rfBranchTxRef")) {
            HashMap txPair = new HashMap();
            txPair.put("rfBranchTxRef", attributeNameValuePairs.get("rfBranchTxRef"));
            attributeNameValuePairs.remove("rfBranchTxRef");
            this.setAttributes(txPair, true, coord);
        }
        this.setAttributes(attributeNameValuePairs, true, coord);
        logger.traceReturn(THIS_CLASS, "setAttributes() - " + this.moType);
    }

    public void setReadOnlyAttributes(String[] attrNames, Object[] values, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "setReadOnlyAttributes() - " + this.moType);
        this.setReadOnlyAndRestrictedAttributes(attrNames, values, coordinator);
        logger.traceReturn(THIS_CLASS, "setReadOnlyAttributes() - " + this.moType);
    }

    public final void setReadOnlyAttribute(String attrName, Object value, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setReadOnlyAttribute(" + attrName + ", " + value + ") - " + this.moType);
        this.setReadOnlyAndRestrictedAttribute(attrName, value, coord);
        logger.traceReturn(THIS_CLASS, "setReadOnlyAttribute(" + attrName + ", " + value + ") - " + this.moType);
    }

    public void setRestrictedAttributes(String[] attrNames, Object[] values, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "setRestrictedAttributes() - " + this.moType);
        this.setReadOnlyAndRestrictedAttributes(attrNames, values, coordinator);
        logger.traceReturn(THIS_CLASS, "setRestrictedAttributes() - " + this.moType);
    }

    public final void setRestrictedAttribute(String attrName, Object value, Coordinator coord) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setRestrictedAttribute(" + attrName + ", " + value + ") - " + this.moType);
        this.setReadOnlyAndRestrictedAttribute(attrName, value, coord);
        logger.traceReturn(THIS_CLASS, "setRestrictedAttribute(" + attrName + ", " + value + ") - " + this.moType);
    }

    public String getMoType() {
        return this.moType;
    }

    private void setReadOnlyAndRestrictedAttributes(String[] attrNames, Object[] values, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        if (attrNames.length != values.length) {
            throw new ProcessingFailureException("Number of attribute names (" + attrNames.length + ") are not the same as values (" + values.length + ")");
        }
        HashMap<String, Object> moAttributeNameValuePairs = new HashMap<String, Object>();
        for (int i = 0; i < attrNames.length; ++i) {
            moAttributeNameValuePairs.put(attrNames[i], values[i]);
        }
        this.handleTransactionWrite(coordinator);
        this.setReadOnlyAndRestrictedAttributes(moAttributeNameValuePairs, coordinator);
    }

    private final void setReadOnlyAndRestrictedAttribute(String attrName, Object value, Coordinator coord) throws MoAccessException {
        this.handleTransactionWrite(coord);
        HashMap<String, Object> moAttributeNameValuePairs = new HashMap<String, Object>();
        moAttributeNameValuePairs.put(attrName, value);
        this.setReadOnlyAndRestrictedAttributes(moAttributeNameValuePairs, coord);
    }

    private final void setReadOnlyAndRestrictedAttributes(Map attributeNameValuePairs, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setReadOnlyAndRestrictedAttributes() - " + this.moType);
        boolean isSystemWriteableOnly = true;
        boolean performValidation = true;
        this.attributeManager.setAttributes(attributeNameValuePairs, true, true, this.moValidator, coordinator);
        Iterator attributeIter = attributeNameValuePairs.entrySet().iterator();
        while (attributeIter.hasNext()) {
            Map.Entry entry = attributeIter.next();
            String currentAttributeName = (String)entry.getKey();
            Object currentAttributeValue = entry.getValue();
            this.postSet(currentAttributeName, currentAttributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setReadOnlyAndRestrictedAttributes() - " + this.moType);
    }

    public void registerPi(String inputMoType, Coordinator coordinator) {
        MoMetaData moData = this.genericMaoContext.getMoMetaDataFinder().getMoData(inputMoType);
        String piType = moData.getPiType();
        if ("HW".equalsIgnoreCase(piType)) {
            this.crbsHardwareProductData = coordinator == null ? this.genericMaoContext.getCrbsHardwareProductDataFactory().createCrbsHardwareProductDataInv(this.genericMao) : this.genericMaoContext.getCrbsHardwareProductDataFactory().createCrbsHardwareProductDataInv(this.genericMao, coordinator);
        }
    }

    public void deregisterPi(CrbsHardwareProductData inputCrbsHardwareProductData, Coordinator coordinator) {
        if (inputCrbsHardwareProductData != null) {
            inputCrbsHardwareProductData.delete(coordinator);
        }
    }

    public AlarmClassificationType getAlarmClassification(String alarmDefinitionId) {
        logger.traceEnter(THIS_CLASS, "getAlarmClassification() - " + alarmDefinitionId);
        MoMetaDataFinder moMetadataFinder = this.genericMaoContext.getMoMetaDataFinder();
        MoMetaData moMetadata = moMetadataFinder.getMoData(this.moType);
        MaoFroAlarmObject maoFroAlarmObject = moMetadata.getAlarm(Integer.parseInt(alarmDefinitionId));
        AlarmClassificationTypeImpl alarmClassType = new AlarmClassificationTypeImpl();
        alarmClassType.setAlarmClassification(maoFroAlarmObject);
        logger.traceReturn(THIS_CLASS, "getAlarmClassification() - " + alarmClassType.getAlarmType());
        return alarmClassType;
    }
}

