/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications;

import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalList;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.froproxy.FroProxyFactory;
import se.ericsson.crbs.omf.mao.indications.ServiceHandler;

public class ServiceHandlerImpl
implements ServiceSubscriber,
ServiceHandler {
    private static final AbstractLogger logger = LoggingService.getLogger(ServiceHandlerImpl.class.getName());
    private static final Class THIS_CLASS = ServiceHandlerImpl.class;
    private final FroProxyFactory froProxyFactory;
    private final TransactionalList listeners = new TransactionalList((TransactionHandler)new ConcurrentTransactionHandler());
    private boolean sessionCreated = false;
    private final String serviceName;

    protected ServiceHandlerImpl(String serviceName) {
        this.serviceName = serviceName;
        this.froProxyFactory = null;
        this.sessionCreated = true;
    }

    protected ServiceHandlerImpl(String serviceName, FroProxyFactory aFroProxyFactory) {
        this.froProxyFactory = aFroProxyFactory;
        this.serviceName = serviceName;
        if ("NO_SERVICE".equals(serviceName)) {
            this.sessionCreated = true;
        }
        new NameServerWrapper(serviceName, (ServiceSubscriber)this);
    }

    public void addListener(ServiceSubscriber listener) {
        this.listeners.add((Object)listener);
    }

    public void addListener(ServiceSubscriber listener, Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            this.listeners.add((Object)listener);
        } else {
            this.listeners.add((Object)listener, coordinator);
        }
    }

    public boolean isSessionCreated() {
        return this.sessionCreated;
    }

    public void removeListener(ServiceSubscriber listener) {
        try {
            TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
            Control control = transFact.create(59);
            Coordinator coordinator = control.getCoordinator();
            this.removeListener(listener, coordinator);
            control.getTerminator().commit();
        }
        catch (TransactionRequiredException e) {
            logger.traceError(THIS_CLASS, "Could not remove Listener " + listener.toString() + " from the ServiceHandler due to a Transaction Required Exception!", e);
        }
        catch (TransactionRolledBackException e) {
            logger.traceError(THIS_CLASS, "Could not remove Listener " + listener.toString() + " from the ServiceHandler due to a Transaction Rolled Back Exception!", e);
        }
        catch (InactiveTransactionException e) {
            logger.traceError(THIS_CLASS, "Could not remove Listener " + listener.toString() + " from the ServiceHandler due to a Inactive Transaction Exception!", e);
        }
    }

    public void removeListener(ServiceSubscriber listener, Coordinator coordinator) throws TransactionRequiredException {
        if (this.listeners.contains((Object)listener, coordinator)) {
            this.listeners.remove((Object)listener, coordinator);
        }
    }

    public void serviceAdded() {
        this.sessionCreated = true;
        try {
            ServiceSubscriber[] theSubscribers = (ServiceSubscriber[])this.listeners.toArray(null, (Object[])new ServiceSubscriber[this.listeners.size(null)]);
            for (int i = 0; i < theSubscribers.length; ++i) {
                theSubscribers[i].serviceAdded();
            }
        }
        catch (TransactionRequiredException tre) {
            logger.traceError(THIS_CLASS, "Could not perform serviceAdded() on all listeners.", tre);
        }
    }

    public void serviceRemoved() {
        if (!"NO_SERVICE".equals(this.serviceName)) {
            this.sessionCreated = false;
        }
        try {
            ServiceSubscriber[] theSubscribers = (ServiceSubscriber[])this.listeners.toArray(null, (Object[])new ServiceSubscriber[this.listeners.size(null)]);
            for (int i = 0; i < theSubscribers.length; ++i) {
                theSubscribers[i].serviceRemoved();
            }
        }
        catch (TransactionRequiredException e) {
            logger.traceError(THIS_CLASS, "Could not perform serviceRemoved() on all listeners due to missing transaction", e);
        }
    }

    public void subscribeService(String moType) {
        if (!"NO_SERVICE".equals(this.serviceName)) {
            this.froProxyFactory.getInstance(moType).subscribeService();
        }
    }
}

