/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications.avc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcConnector;
import se.ericsson.crbs.omf.mao.indications.avc.AvcConnectorFactory;
import se.ericsson.crbs.omf.mao.indications.avc.AvcException;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistrator;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.indications.avc.TopologyRegistrator;
import se.ericsson.crbs.omf.mao.indications.avc.TopologySubscriber;

public class AvcRegistratorImpl
implements AvcRegistrator,
TopologyRegistrator {
    private static final int TX_TIMEOUT = 0;
    private static final Class THIS_CLASS = AvcRegistratorImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final GoamLmRegistrationThread thread;
    private final Map subscribedItemsToSubscriber = new HashMap();
    protected final AvcConnector avcConnector;
    private static TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();

    protected AvcRegistratorImpl(int pollTime) {
        logger.traceEnter(THIS_CLASS, "AvcRegistratorImpl()");
        this.avcConnector = AvcConnectorFactory.getInstance().getAvcConnector(this);
        this.thread = new GoamLmRegistrationThread(pollTime, this.avcConnector);
        this.thread.start();
        logger.traceReturn(THIS_CLASS, "AvcRegistratorImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForUpdate(AvcSubscriber subscriber, String moTypeToListenForUpdate, String attributeToListenForUpdate) {
        logger.traceEnter(THIS_CLASS, "registerForUpdate(subscriber='" + subscriber + "', moTypeToListenForUpdate='" + moTypeToListenForUpdate + "', attributeToListenForUpdate='" + attributeToListenForUpdate + "')");
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            if (!this.subscribeExist(moTypeToListenForUpdate)) {
                this.thread.register(moTypeToListenForUpdate);
            }
            List subscribers = this.getSubscriberList(moTypeToListenForUpdate, attributeToListenForUpdate, false);
            subscribers.add(subscriber);
        }
        logger.traceReturn(THIS_CLASS, "registerForUpdate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForTopologyUpdates(TopologySubscriber subscriber, String moTypeToListenForUpdate) {
        logger.traceEnter(THIS_CLASS, "registerForTopologyUpdate(subscriber='" + subscriber + "', moTypeToListenForUpdate='" + moTypeToListenForUpdate + "', topologyChange'" + "')");
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            if (!this.subscribeExist(moTypeToListenForUpdate)) {
                this.thread.register(moTypeToListenForUpdate);
            }
            List subscribers = this.getSubscriberList(moTypeToListenForUpdate, "moCreated", false);
            subscribers.add(subscriber);
            subscribers = this.getSubscriberList(moTypeToListenForUpdate, "moDeleted", false);
            subscribers.add(subscriber);
        }
        logger.traceReturn(THIS_CLASS, "registerForTopologyUpdates()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForUpdate(AvcSubscriber subscriber, String moTypeToListenForUpdate, String attributeToListenForUpdate) {
        logger.traceEnter(THIS_CLASS, "unregisterForUpdate(subscriber='" + subscriber + "', moTypeToListenForUpdate='" + moTypeToListenForUpdate + "', attributeToListenForUpdate='" + attributeToListenForUpdate + "')");
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            List subscribers = this.getSubscriberList(moTypeToListenForUpdate, attributeToListenForUpdate, true);
            Iterator iterator = subscribers.iterator();
            while (iterator.hasNext()) {
                AvcSubscriber subscriberInList = (AvcSubscriber)iterator.next();
                if (!subscriber.equals(subscriberInList)) continue;
                subscribers.remove(subscriberInList);
                break;
            }
            if (subscribers.isEmpty() && this.removeSubscriberList(moTypeToListenForUpdate, attributeToListenForUpdate)) {
                logger.traceDebug(THIS_CLASS, "This is the last subscription for this MO type " + moTypeToListenForUpdate + ", unregister in AVC service");
                this.thread.unregister(moTypeToListenForUpdate);
            }
        }
        logger.traceReturn(THIS_CLASS, "unregisterForUpdate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForTopologyUpdates(TopologySubscriber subscriber, String moTypeToListenForUpdate, String topologyChange) {
        logger.traceEnter(THIS_CLASS, "unregisterForTopologyUpdates(subscriber='" + subscriber + "', moTypeToListenForUpdate='" + moTypeToListenForUpdate + " topologyChange=" + topologyChange + "')");
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            List subscribers = this.getSubscriberList(moTypeToListenForUpdate, "moCreated", true);
            Iterator iterator = subscribers.iterator();
            while (iterator.hasNext()) {
                TopologySubscriber subscriberInList = (TopologySubscriber)iterator.next();
                if (!subscriber.equals(subscriberInList)) continue;
                subscribers.remove(subscriberInList);
                break;
            }
            if (subscribers.isEmpty() && this.removeSubscriberList(moTypeToListenForUpdate, topologyChange)) {
                logger.traceDebug(THIS_CLASS, "This is the last subscription for this MO type " + moTypeToListenForUpdate + ", unregister in AVC service");
                this.thread.unregister(moTypeToListenForUpdate);
            }
        }
        logger.traceReturn(THIS_CLASS, "unregisterForTopologyUpdates()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSubscriptionProblem() {
        List subscribers;
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem");
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            ArrayList subscribersList = (ArrayList)this.getAllSubscribers();
            subscribers = (List)subscribersList.clone();
        }
        Iterator iterator = subscribers.iterator();
        Object subscriber = null;
        while (iterator.hasNext()) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    Object sub;
                    subscriber = iterator.next();
                    if (subscriber instanceof AvcSubscriber) {
                        sub = subscriber;
                        sub.reportSubscriptionProblem(coordinator);
                    } else if (subscriber instanceof TopologySubscriber) {
                        sub = subscriber;
                        sub.reportSubscriptionProblem(coordinator);
                    }
                    control.getTerminator().commit();
                }
                catch (Exception e) {
                    logger.traceError(THIS_CLASS, "Got exception during reportSubscriptionProblem to subscriber");
                    control.getTerminator().rollback();
                }
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (TransactionRolledBackException) " + e.toString());
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (InactiveTransactionException) " + e.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    public void stopSubscriptions() throws AvcException {
        this.avcConnector.stopSubscriptions();
    }

    private List getAllSubscribers() {
        ArrayList subscriberList = new ArrayList();
        Iterator mapIter = this.subscribedItemsToSubscriber.values().iterator();
        while (mapIter.hasNext()) {
            Map attributeToSubscriberMap = (Map)mapIter.next();
            Iterator listIter = attributeToSubscriberMap.values().iterator();
            while (listIter.hasNext()) {
                List subscribers = (List)listIter.next();
                Iterator subscriberIter = subscribers.iterator();
                while (subscriberIter.hasNext()) {
                    Object subscriber = subscriberIter.next();
                    if (subscriberList.contains(subscriber)) continue;
                    subscriberList.add(subscriber);
                }
            }
        }
        return subscriberList;
    }

    protected void stop() {
        logger.traceEnter(THIS_CLASS, "stop()");
        this.thread.stopIt();
        logger.traceReturn(THIS_CLASS, "stop()");
    }

    private List getSubscriberList(String moType, String attribute, boolean readOnly) {
        Map attrToMoMap;
        logger.traceEnter(THIS_CLASS, "getSubscriberList(moType = " + moType + ", attribute = " + attribute + ", readOnly=" + readOnly + ")");
        List subscribers = null;
        if (this.subscribedItemsToSubscriber.containsKey(moType)) {
            attrToMoMap = (HashMap)this.subscribedItemsToSubscriber.get(moType);
            subscribers = (List)attrToMoMap.get(attribute);
        }
        if (subscribers == null) {
            subscribers = new ArrayList();
            if (!readOnly) {
                if (this.subscribedItemsToSubscriber.containsKey(moType)) {
                    attrToMoMap = (Map)this.subscribedItemsToSubscriber.get(moType);
                } else {
                    attrToMoMap = new HashMap();
                    this.subscribedItemsToSubscriber.put(moType, attrToMoMap);
                }
                attrToMoMap.put(attribute, subscribers);
            }
        }
        logger.traceReturn(THIS_CLASS, "getSubscriberList(numberOfSubscribers=" + subscribers.size() + ")");
        return subscribers;
    }

    private boolean subscribeExist(String moTypeToListenForUpdate) {
        return this.subscribedItemsToSubscriber.containsKey(moTypeToListenForUpdate);
    }

    private boolean removeSubscriberList(String moTypeToListenForUpdate, String attributeToListenForUpdate) {
        boolean removedMoType = false;
        Map attributeToMoMap = (Map)this.subscribedItemsToSubscriber.get(moTypeToListenForUpdate);
        if (attributeToMoMap != null) {
            attributeToMoMap.remove(attributeToListenForUpdate);
            if (attributeToMoMap.isEmpty()) {
                this.subscribedItemsToSubscriber.remove(moTypeToListenForUpdate);
                removedMoType = true;
            }
        }
        return removedMoType;
    }

    private void sendUpdate(Iterator iter, String ldn, String attributeName, Object attributeValue) {
        logger.traceEnter(THIS_CLASS, "sendUpdate(attributeName = " + attributeName + ", attributeValue = " + attributeValue + ")");
        AvcSubscriber subscriber = null;
        while (iter.hasNext()) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    subscriber = (AvcSubscriber)iter.next();
                    logger.traceDebug(THIS_CLASS, "Send update on attribute=" + attributeName + ", " + "value=" + attributeValue + " to subscriber=" + subscriber);
                    subscriber.reportAvc(ldn, attributeName, attributeValue, coordinator);
                    control.getTerminator().commit();
                }
                catch (Exception e) {
                    logger.traceDebugStackTrace(THIS_CLASS, e);
                    StringBuffer buff = new StringBuffer(256).append("Got exception during reportAvc to subscriber ").append(subscriber).append(" for attribute ").append(attributeName).append(" with value ").append(attributeValue).append(": ").append(e.toString());
                    logger.traceError(THIS_CLASS, buff.toString());
                    control.getTerminator().rollback();
                }
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (TransactionRolledBackException) " + e.toString());
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (InactiveTransactionException) " + e.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "sendUpdate()");
    }

    private void sendTopologyUpdate(Iterator iter, String ldn, String attributeName, Object attributeValue) {
        logger.traceEnter(THIS_CLASS, "sendTopologyUpdate(attributeName = " + attributeName + ", attributeValue = " + attributeValue + ")");
        TopologySubscriber subscriber = null;
        while (iter.hasNext()) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    subscriber = (TopologySubscriber)iter.next();
                    logger.traceDebug(THIS_CLASS, "Send update on attribute=" + attributeName + ", " + "value=" + attributeValue + " to subscriber=" + subscriber);
                    if ("moCreated".equals(attributeName)) {
                        subscriber.reportMoCreated(ldn, coordinator);
                    } else if ("moDeleted".equals(attributeName)) {
                        subscriber.reportMoDeleted(ldn, coordinator);
                    }
                    control.getTerminator().commit();
                }
                catch (Exception e) {
                    logger.traceDebugStackTrace(THIS_CLASS, e);
                    StringBuffer buff = new StringBuffer(256).append("Got exception during reportAvc to subscriber ").append(subscriber).append(" for attribute ").append(attributeName).append(" with value ").append(attributeValue).append(": ").append(e.toString());
                    logger.traceError(THIS_CLASS, buff.toString());
                    control.getTerminator().rollback();
                }
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (TransactionRolledBackException) " + e.toString());
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, "Could not do rollback: (InactiveTransactionException) " + e.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "sendTopologyUpdate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAvc(String ldn, String attributeName, Object attributeValue) {
        List subscribers;
        logger.traceEnter(THIS_CLASS, "reportAvc(ldn = " + ldn + ", attributeName = " + attributeName + ", attributeValue = " + attributeValue + ")");
        String moType = LdnHelper.getLastLdnElement(ldn);
        String convertedAttributeName = this.getRightAttributeName(moType, attributeName);
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            ArrayList subscribersList = (ArrayList)this.getSubscriberList(moType, convertedAttributeName, true);
            subscribers = (List)subscribersList.clone();
        }
        Iterator iterator = subscribers.iterator();
        this.sendUpdate(iterator, ldn, convertedAttributeName, attributeValue);
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMoCreated(String ldn) {
        List subscribers;
        logger.traceEnter(THIS_CLASS, "reportMoCreated(ldn = " + ldn + ")");
        String moType = LdnHelper.getLastLdnElement(ldn);
        String convertedAttributeName = "moCreated";
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            ArrayList subscribersList = (ArrayList)this.getSubscriberList(moType, "moCreated", true);
            subscribers = (List)subscribersList.clone();
        }
        Iterator iterator = subscribers.iterator();
        Object attributeValue = null;
        this.sendTopologyUpdate(iterator, ldn, "moCreated", attributeValue);
        logger.traceReturn(THIS_CLASS, "reportMoCreated()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMoDeleted(String ldn) {
        List subscribers;
        logger.traceEnter(THIS_CLASS, "reportMoDeleted(ldn = " + ldn + ")");
        String moType = LdnHelper.getLastLdnElement(ldn);
        String convertedAttributeName = "moDeleted";
        AvcRegistratorImpl avcRegistratorImpl = this;
        synchronized (avcRegistratorImpl) {
            ArrayList subscribersList = (ArrayList)this.getSubscriberList(moType, "moDeleted", true);
            subscribers = (List)subscribersList.clone();
        }
        Iterator iterator = subscribers.iterator();
        Object attributeValue = null;
        this.sendTopologyUpdate(iterator, ldn, "moDeleted", attributeValue);
        logger.traceReturn(THIS_CLASS, "reportMoDeleted()");
    }

    public void registerForTopologyUpdate(TopologySubscriber subscriber, String moTypeToListenForUpdate) {
        this.registerForTopologyUpdates(subscriber, moTypeToListenForUpdate);
    }

    public void unregisterForTopologyUpdate(TopologySubscriber subscriber, String moTypeToListenForUpdate) {
        this.unregisterForTopologyUpdates(subscriber, moTypeToListenForUpdate, "moCreated");
        this.unregisterForTopologyUpdates(subscriber, moTypeToListenForUpdate, "moDeleted");
    }

    private String getRightAttributeName(String moType, String attributeName) {
        String returnStr = attributeName;
        if (this.subscribedItemsToSubscriber.containsKey(moType)) {
            Map attributeToMoMap = (Map)this.subscribedItemsToSubscriber.get(moType);
            Iterator attributes = attributeToMoMap.keySet().iterator();
            while (attributes.hasNext()) {
                String attributeInMap = (String)attributes.next();
                if (!attributeInMap.equalsIgnoreCase(attributeName)) continue;
                returnStr = attributeInMap;
                break;
            }
        }
        return returnStr;
    }

    class GoamLmRegistrationThread
    extends Thread {
        public boolean notExit;
        private final AvcConnector connector;
        private final int pollTime;
        private final LinkedList actions;
        private final Object threadLock;

        public GoamLmRegistrationThread(int pollTime, AvcConnector avcConnector) {
            super("crbs_AVC_Registration_Thread");
            this.notExit = true;
            this.actions = new LinkedList();
            this.threadLock = new Object();
            this.pollTime = pollTime;
            this.connector = avcConnector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopIt() {
            logger.traceEnter(THIS_CLASS, "lteRbsSoamLmRegistrationThread:stopIt()");
            Object object = this.threadLock;
            synchronized (object) {
                this.notExit = false;
                this.actions.clear();
                this.threadLock.notifyAll();
            }
            logger.traceReturn(THIS_CLASS, "lteRbsSoamLmRegistrationThread:stopIt()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            boolean logged = false;
            logger.info(THIS_CLASS, "Waiting for CM service to be available");
            while (this.notExit) {
                Object[] action = this.getNextAction();
                while (action != null) {
                    boolean gotException = false;
                    boolean shouldRegister = (Boolean)action[0];
                    String moType = (String)action[1];
                    try {
                        if (shouldRegister) {
                            logger.traceDebug(THIS_CLASS, "lteRbsSoamLmRegistrationThread:Register " + moType + " in AVC service");
                            this.connector.registerAvcSubscriber(moType);
                            if (!logged) {
                                logger.info(THIS_CLASS, "CmService is avaliable");
                                logged = true;
                            }
                        } else {
                            logger.traceDebug(THIS_CLASS, "lteRbsSoamLmRegistrationThread:Unregister " + moType + " in AVC service");
                            this.connector.unregisterAvcSubscriber(moType);
                            if (!logged) {
                                logger.info(THIS_CLASS, "CmService is available");
                                logged = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        gotException = true;
                        try {
                            Thread.sleep(this.pollTime);
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                        }
                    }
                    if (gotException) continue;
                    action = this.getNextAction();
                }
                try {
                    Object gotException = this.threadLock;
                    synchronized (gotException) {
                        if (this.actions.isEmpty()) {
                            this.threadLock.wait(this.pollTime);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public void register(String moTypeToListenForUpdate) {
            logger.traceEnter(THIS_CLASS, "lteRbsSoamLmRegistrationThread:register(moTypeToListenForUpdate = " + moTypeToListenForUpdate + ")");
            this.addOperationToList(true, moTypeToListenForUpdate);
            logger.traceReturn(THIS_CLASS, "lteRbsSoamLmRegistrationThread:register()");
        }

        public void unregister(String moTypeToListenForUpdate) {
            logger.traceEnter(THIS_CLASS, "lteRbsSoamLmRegistrationThread:unregister(moTypeToListenForUpdate = " + moTypeToListenForUpdate + ")");
            this.addOperationToList(false, moTypeToListenForUpdate);
            logger.traceReturn(THIS_CLASS, "lteRbsSoamLmRegistrationThread:unregister()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addOperationToList(boolean shouldRegister, String moType) {
            Object object = this.threadLock;
            synchronized (object) {
                logger.traceEnter(THIS_CLASS, "lteRbsSoamLmRegistrationThread:addOperationToList(shouldRegister = " + shouldRegister + ", MO type = " + moType + ")");
                Object[] action = new Object[]{shouldRegister, moType};
                this.actions.addLast(action);
                this.threadLock.notifyAll();
                logger.traceEnter(THIS_CLASS, "lteRbsSoamLmRegistrationThread:addOperationToList()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getNextAction() {
            Object[] action = null;
            Object object = this.threadLock;
            synchronized (object) {
                if (!this.actions.isEmpty()) {
                    action = (Object[])this.actions.removeFirst();
                }
            }
            return action;
        }
    }
}

