/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.wrappers;

import java.io.File;
import se.ericsson.cello.net.FTPClient;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.net.OutOfResourcesException;
import se.ericsson.cello.pms.generic.FailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.FTPClientWrapper;

public class FTPClientWrapperImpl
implements FTPClientWrapper {
    private static final Class THIS_CLASS = FTPClientWrapperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(FTPClientWrapperImpl.class.getName());
    private final FTPClient ftpClient;

    public FTPClientWrapperImpl() {
        logger.traceEnter(THIS_CLASS, "FTPClientWrapperImpl()");
        this.ftpClient = new FTPClient();
        logger.traceReturn(THIS_CLASS, "FTPClientWrapperImpl()");
    }

    public void get(String ipAddress, String username, String password, String localFilePath, String remotFilePath) throws FTPException, OutOfResourcesException, FailedException {
        logger.traceEnter(THIS_CLASS, "get()");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            File localFile = new File(localFilePath);
            try {
                while (localFile.exists()) {
                    try {
                        localFile.delete();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Unable to remove previous file: " + localFilePath);
            }
        }
        try {
            this.ftpClient.get(ipAddress, username, password, localFilePath, remotFilePath);
        }
        catch (FTPException ftpe) {
            throw ftpe;
        }
        catch (OutOfResourcesException oore) {
            throw oore;
        }
        catch (Exception e) {
            FailedException fe = new FailedException();
            fe.setStackTrace(e.getStackTrace());
            throw fe;
        }
        logger.traceReturn(THIS_CLASS, "get()");
    }

    public void put(String ipAddress, String username, String password, String localFilePath, String remotFilePath) throws FTPException, OutOfResourcesException, FailedException {
        logger.traceEnter(THIS_CLASS, "put()");
        try {
            this.ftpClient.put(ipAddress, username, password, localFilePath, remotFilePath);
        }
        catch (FTPException ftpe) {
            throw ftpe;
        }
        catch (OutOfResourcesException oore) {
            throw oore;
        }
        catch (Exception e) {
            FailedException fe = new FailedException();
            fe.setStackTrace(e.getStackTrace());
            throw fe;
        }
        logger.traceReturn(THIS_CLASS, "put()");
    }
}

