/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XmlFileResolver;

class XmlFileResolverImpl
implements XmlFileResolver {
    private static final Class THIS_CLASS = XmlFileResolverImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private List extraPathsBefore = null;
    private List extraPathsAfter = null;
    private String dtdFilePath = null;

    XmlFileResolverImpl() {
    }

    XmlFileResolverImpl(List pathsBefore, List pathsAfter) {
        this.extraPathsBefore = pathsBefore;
        this.extraPathsAfter = pathsAfter;
    }

    private URL findLocalFile(List pathsToCheck) {
        logger.traceEnter(THIS_CLASS, "findLocalFile()");
        URL ret = null;
        Iterator iterator = pathsToCheck.iterator();
        while (ret == null && iterator.hasNext()) {
            String fileToCheck = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + fileToCheck + " exists");
            try {
                ret = new URL(fileToCheck);
            }
            catch (MalformedURLException ignore) {
                File file = new File(fileToCheck);
                if (!file.exists()) continue;
                try {
                    ret = new File(this.encodePercent(fileToCheck)).toURL();
                }
                catch (MalformedURLException e) {
                    logger.traceError(this.getClass(), " Error in converting file " + file + " to URL", e);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "findLocalFile()");
        return ret;
    }

    private String encodePercent(String fileToCheck) {
        String ret = fileToCheck;
        int index = fileToCheck.indexOf(37);
        if (index != -1) {
            ret = fileToCheck.substring(0, index + 1) + "25" + fileToCheck.substring(index + 1);
        }
        return ret;
    }

    private List createPathList(String href) {
        ArrayList<String> pathsToCheck = new ArrayList<String>();
        if (this.extraPathsBefore != null) {
            this.addPaths(pathsToCheck, this.extraPathsBefore, href);
        }
        pathsToCheck.add(href);
        if (this.extraPathsAfter != null) {
            this.addPaths(pathsToCheck, this.extraPathsAfter, href);
        }
        return pathsToCheck;
    }

    private void addPaths(List paths, List extraPaths, String href) {
        Iterator iterator = extraPaths.iterator();
        while (iterator.hasNext()) {
            String path = ((String)iterator.next()).trim();
            if (path.length() <= 0) continue;
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            paths.add(path + href);
        }
    }

    private String getSystemId(String href) {
        logger.traceEnter(this.getClass(), "getSystemId(" + href + ")");
        String systemId = "";
        if (href != null && !href.trim().equals("")) {
            List pathsToCheck = this.createPathList(href);
            URL url = this.findFileViaClassLoader(pathsToCheck);
            if (url == null) {
                url = this.findLocalFile(pathsToCheck);
            }
            if (url == null) {
                logger.traceError(this.getClass(), " Error in getting file:" + href);
            } else {
                systemId = url.toExternalForm();
            }
        }
        logger.traceReturn(this.getClass(), "getSystemId(" + href + ") = " + systemId);
        return systemId;
    }

    private URL findFileViaClassLoader(List pathsToCheck) {
        String fileToCheck;
        URL resource = null;
        Iterator iterator = pathsToCheck.iterator();
        do {
            fileToCheck = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + fileToCheck + " can be found using class loader");
        } while ((resource = ClassLoader.getSystemClassLoader().getResource(fileToCheck)) == null && iterator.hasNext());
        if (resource != null) {
            logger.traceDebug(THIS_CLASS, "Found file using class loader");
        }
        return resource;
    }

    public Source resolve(String href, String base) {
        logger.traceEnter(this.getClass(), "resolve(" + href + ", " + base + ")");
        StreamSource res = new StreamSource(this.getSystemId(href));
        logger.traceReturn(this.getClass(), "resolve(" + href + ", " + base + ")");
        return res;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        logger.traceEnter(this.getClass(), "resolveEntity(" + publicId + ", " + systemId + ")");
        InputSource source = new InputSource(this.getSystemId(systemId));
        logger.traceReturn(this.getClass(), "resolveEntity(" + publicId + ", " + systemId + ") = " + source.getSystemId());
        return source;
    }

    public InputSource getExternalSubset(String rootElement, String baseUri) throws SAXException, IOException {
        InputSource source = null;
        if (this.dtdFilePath != null) {
            String docTypeString = this.dtdFilePath;
            source = new InputSource(this.getSystemId(docTypeString));
        }
        return source;
    }

    public InputSource resolveEntity(String externalEntity, String publicId, String baseUri, String systemId) throws SAXException, IOException {
        return null;
    }

    public void setDtdFilePath(String inputDtdFilePath) {
        this.dtdFilePath = inputDtdFilePath;
    }
}

