/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.omfapplication;

import java.util.Iterator;
import java.util.Map;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactoryFactory;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactoryImpl;
import se.ericsson.crbs.omf.omfapplication.FactoryInitializer;

public class GenericFactoryInitializer
implements FactoryInitializer {
    private static final Class THIS_CLASS = GenericFactoryInitializer.class;
    private static AbstractLogger logger = LoggingService.getLogger();
    private final MaoFactoryFactory theFactory;
    private final MoMetaDataFinder theFinder;

    public GenericFactoryInitializer(MoMetaDataFinder aFinder, MaoFactoryFactory aFactory) {
        this.theFactory = aFactory;
        this.theFinder = aFinder;
    }

    public void initializeFactories() {
        logger.traceEnter(THIS_CLASS, "initializeFactories()");
        Map mos = this.theFinder.getMoMap();
        Iterator moIter = mos.values().iterator();
        while (moIter.hasNext()) {
            MoMetaData currentMo = (MoMetaData)moIter.next();
            MaoFactory currentFac = this.theFactory.getMoFactory(currentMo);
            currentFac.init();
        }
        logger.traceReturn(THIS_CLASS, "initializeFactories()");
    }

    public void startFactories() {
        logger.traceEnter(THIS_CLASS, "startFactories()");
        Map mos = this.theFinder.getMoMap();
        Iterator moIter = mos.values().iterator();
        while (moIter.hasNext()) {
            MoMetaData currentMo = (MoMetaData)moIter.next();
            if (!currentMo.isImplementedAsGenericMAO()) continue;
            MaoFactory currentFac = this.theFactory.getMoFactory(currentMo);
            currentFac.start();
        }
        logger.traceReturn(THIS_CLASS, "startFactories()");
    }

    public void synch() {
        logger.traceEnter(THIS_CLASS, "synch()");
        Map mos = this.theFinder.getMoMap();
        Iterator moIter = mos.values().iterator();
        while (moIter.hasNext()) {
            SystemCreatedMaoFactoryImpl currentFac;
            MoMetaData currentMo = (MoMetaData)moIter.next();
            if (!currentMo.isSystemCreated() || !currentMo.isImplementedAsGenericMAO() || (currentFac = (SystemCreatedMaoFactoryImpl)this.theFactory.getMoFactory(currentMo)).isSynch()) continue;
            currentFac.synch();
        }
        logger.traceReturn(THIS_CLASS, "synch()");
    }
}

